/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.unc.genomics.util.FileUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.log4j.Logger;

public class SequenceFileSniffer {
    private static final Logger log = Logger.getLogger(SequenceFileSniffer.class);
    protected Path p;

    public SequenceFileSniffer(Path p) {
        this.p = p;
    }

    public boolean isFasta() throws IOException {
        String line1;
        if (!FileUtils.isAsciiText(this.p)) {
            return false;
        }
        try (BufferedReader reader = Files.newBufferedReader(this.p, Charset.defaultCharset());){
            line1 = reader.readLine();
        }
        if (line1 == null) {
            return false;
        }
        return line1.startsWith(">");
    }

    public boolean isFastq() throws IOException {
        String line3;
        String line1;
        if (!FileUtils.isAsciiText(this.p)) {
            return false;
        }
        try (BufferedReader reader = Files.newBufferedReader(this.p, Charset.defaultCharset());){
            line1 = reader.readLine();
            reader.readLine();
            line3 = reader.readLine();
        }
        if (line1 == null || line3 == null) {
            return false;
        }
        return line1.startsWith("@") && line3.startsWith("+");
    }

    public boolean isTwoBit() throws IOException {
        return !FileUtils.isAsciiText(this.p);
    }
}

