/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.wigmath.WigMathTool;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.log4j.Logger;

public class MovingAverageSmooth
extends WigMathTool {
    private static final Logger log = Logger.getLogger(MovingAverageSmooth.class);
    @Parameter(names={"-i", "--input"}, description="Input file", required=true)
    public WigFile inputFile;
    @Parameter(names={"-w", "--width"}, description="Width of kernel (bp)")
    public int width = 10;
    DescriptiveStatistics stats;

    @Override
    public void setup() {
        this.inputs.add(this.inputFile);
        log.debug((Object)"Initializing statistics");
        this.stats = new DescriptiveStatistics();
        this.stats.setWindowSize(this.width);
    }

    @Override
    public float[] compute(String chr, int start, int stop) throws IOException, WigFileException {
        int queryStart = Math.max(start - this.width / 2, this.inputFile.getChrStart(chr));
        int queryStop = Math.min(stop + this.width / 2, this.inputFile.getChrStop(chr));
        Iterator result = this.inputFile.query(chr, queryStart, queryStop);
        float[] data = WigFile.flattenData((Iterator)result, (int)queryStart, (int)queryStop);
        float[] smoothed = new float[stop - start + 1];
        for (int bp = start; bp <= stop; ++bp) {
            this.stats.addValue((double)data[bp - queryStart]);
            if (bp - start - this.width / 2 < 0) continue;
            smoothed[bp - start - this.width / 2] = (float)this.stats.getMean();
        }
        return smoothed;
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new MovingAverageSmooth().instanceMain(args);
    }
}

