/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.dna;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.utils.Samtools;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.sf.picard.reference.FastaSequenceIndex;
import net.sf.picard.reference.FastaSequenceIndexEntry;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.samtools.util.StringUtil;
import org.apache.log4j.Logger;
import org.genomeview.dnaproperties.DNAProperty;

public class DNAPropertyCalculator
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(DNAPropertyCalculator.class);
    @Parameter(names={"-i", "--input"}, description="Input file (FASTA)", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-p", "--property"}, description="DNA property to calculate", required=true)
    public String propertyName;
    @Parameter(names={"-n", "--normalize"}, description="Output normalized values")
    public boolean normalize = false;
    @Parameter(names={"-o", "--output"}, description="Output file (Wiggle)", required=true)
    public Path outputFile;

    @Override
    public void run() throws IOException {
        DNAProperty property = DNAProperty.create((String)this.propertyName);
        if (property == null) {
            log.error((Object)("Unknown DNA property: " + this.propertyName));
            throw new CommandLineToolException("Unknown DNA property: " + this.propertyName);
        }
        if (!IndexedFastaSequenceFile.canCreateIndexedFastaReader((File)this.inputFile.toFile())) {
            try {
                Samtools.indexFasta(this.inputFile);
            }
            catch (Exception e) {
                log.error((Object)"Error indexing FASTA file with samtools. Is samtools available in the PATH?");
                throw new CommandLineToolException("Error indexing FASTA file with samtools");
            }
        }
        IndexedFastaSequenceFile fasta = new IndexedFastaSequenceFile(this.inputFile.toFile());
        Path indexFile = this.inputFile.resolveSibling(this.inputFile.getFileName() + ".fai");
        FastaSequenceIndex faidx = new FastaSequenceIndex(indexFile.toFile());
        try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            writer.write("track type=wiggle_0 name='" + this.propertyName + "' description='" + this.propertyName + "'");
            writer.newLine();
            for (FastaSequenceIndexEntry contig : faidx) {
                log.debug((Object)("Processing FASTA entry " + contig.getContig() + " (length = " + contig.getSize() + ")"));
                writer.write("fixedStep chrom=" + contig.getContig() + " start=1 step=1 span=1");
                writer.newLine();
                long start = 1L;
                while (start <= contig.getSize()) {
                    long stop = Math.min(start + 300000L - 1L, contig.getSize());
                    log.debug((Object)("Processing chunk " + contig.getContig() + ":" + start + "-" + stop));
                    ReferenceSequence seq = fasta.getSubsequenceAt(contig.getContig(), start, stop);
                    double[] values = this.normalize ? property.normalizedProfile(StringUtil.bytesToString((byte[])seq.getBases())) : property.profile(StringUtil.bytesToString((byte[])seq.getBases()));
                    for (double value : values) {
                        writer.write(Float.toString((float)value));
                        writer.newLine();
                    }
                    start = stop + 1L;
                }
            }
        }
    }

    public static void main(String[] args) {
        new DNAPropertyCalculator().instanceMain(args);
    }
}

