/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.converters;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.GeneTrackEntry;
import edu.unc.genomics.io.GeneTrackFile;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.log4j.Logger;

public class GeneTrackToBedGraph
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(GeneTrackToBedGraph.class);
    @Parameter(names={"-i", "--input"}, description="Input file (GeneTrack format)", required=true)
    public Path gtFile;
    @Parameter(names={"-o", "--output"}, description="Output file (BedGraph)", required=true)
    public Path outputFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws IOException {
        log.debug((Object)"Initializing input GeneTrack file");
        log.debug((Object)"Initializing output file");
        try (GeneTrackFile gt = new GeneTrackFile(this.gtFile);
             BufferedWriter writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            for (GeneTrackEntry entry : gt) {
                writer.write(entry.toBedGraph());
                writer.newLine();
            }
        }
    }

    public static void main(String[] args) {
        new GeneTrackToBedGraph().instanceMain(args);
    }
}

