/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.nucleosomes;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.IntervalFile;
import edu.unc.genomics.nucleosomes.NucleosomeCall;
import edu.unc.genomics.nucleosomes.NucleosomeCallsFile;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class NRLCalculator
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(NRLCalculator.class);
    @Parameter(names={"-i", "--input"}, description="Input file (nucleosome calls)", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-l", "--loci"}, description="Genomic loci (Bed format)", required=true)
    public IntervalFile<? extends Interval> lociFile;
    @Parameter(names={"-o", "--output"}, description="Output file (NRLs for each gene)", required=true)
    public Path outputFile;

    @Override
    public void run() throws IOException {
        log.debug((Object)"Initializing input file");
        NucleosomeCallsFile nucsFile = new NucleosomeCallsFile(this.inputFile);
        log.debug((Object)"Initializing output file");
        try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            log.debug((Object)"Calculating nucleosome spacing for each interval");
            writer.write("#chr\tlow\thigh\tid\talignment\tstrand\tSpacing: +1 to +2 (etc)");
            writer.newLine();
            NucleosomeCall.DyadComparator comparator = new NucleosomeCall.DyadComparator();
            for (Interval interval : this.lociFile) {
                writer.write(interval.toBed());
                Iterator it = nucsFile.query(interval);
                ArrayList intervalNucs = new ArrayList();
                while (it.hasNext()) {
                    intervalNucs.add(it.next());
                }
                if (intervalNucs.size() > 1) {
                    Collections.sort(intervalNucs, comparator);
                    if (interval.isCrick()) {
                        Collections.reverse(intervalNucs);
                    }
                    for (int i = 1; i < intervalNucs.size(); ++i) {
                        writer.write("\t" + Math.abs(((NucleosomeCall)intervalNucs.get(i)).getDyad() - ((NucleosomeCall)intervalNucs.get(i - 1)).getDyad()));
                    }
                }
                writer.newLine();
            }
        }
        this.lociFile.close();
        nucsFile.close();
    }

    public static void main(String[] args) throws IOException {
        new NRLCalculator().instanceMain(args);
    }
}

