/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dct;

import edu.emory.mathcs.jtransforms.dct.FloatDCT_1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class FloatDCT_3D {
    private int slices;
    private int rows;
    private int columns;
    private int sliceStride;
    private int rowStride;
    private float[] t;
    private FloatDCT_1D dctSlices;
    private FloatDCT_1D dctRows;
    private FloatDCT_1D dctColumns;
    private int oldNthreads;
    private int nt;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public FloatDCT_3D(int n, int n2, int n3) {
        if (n <= 1 || n2 <= 1 || n3 <= 1) {
            throw new IllegalArgumentException("slices, rows and columns must be greater than 1");
        }
        this.slices = n;
        this.rows = n2;
        this.columns = n3;
        this.sliceStride = n2 * n3;
        this.rowStride = n3;
        if (n * n2 * n3 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.useThreads = true;
        }
        if (ConcurrencyUtils.isPowerOf2(n) && ConcurrencyUtils.isPowerOf2(n2) && ConcurrencyUtils.isPowerOf2(n3)) {
            this.isPowerOfTwo = true;
            this.oldNthreads = ConcurrencyUtils.getNumberOfThreads();
            this.nt = n;
            if (this.nt < n2) {
                this.nt = n2;
            }
            this.nt *= 4;
            if (this.oldNthreads > 1) {
                this.nt *= this.oldNthreads;
            }
            if (n3 == 2) {
                this.nt >>= 1;
            }
            this.t = new float[this.nt];
        }
        this.dctSlices = new FloatDCT_1D(n);
        this.dctRows = n == n2 ? this.dctSlices : new FloatDCT_1D(n2);
        this.dctColumns = n == n3 ? this.dctSlices : (n2 == n3 ? this.dctRows : new FloatDCT_1D(n3));
    }

    public void forward(final float[] fArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 4;
                if (n > 1) {
                    this.nt *= n;
                }
                if (this.columns == 2) {
                    this.nt >>= 1;
                }
                this.t = new float[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, fArray, bl);
                this.ddxt3db_subth(-1, fArray, bl);
            } else {
                this.ddxt3da_sub(-1, fArray, bl);
                this.ddxt3db_sub(-1, fArray, bl);
            }
        } else if (n > 1 && this.useThreads && this.slices >= n && this.rows >= n && this.columns >= n) {
            int n2;
            int n3;
            int n4;
            Future[] futureArray = new Future[n];
            int n5 = this.slices / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.slices : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n2; ++i) {
                            int n = i * FloatDCT_3D.this.sliceStride;
                            for (int j = 0; j < FloatDCT_3D.this.rows; ++j) {
                                FloatDCT_3D.this.dctColumns.forward(fArray, n + j * FloatDCT_3D.this.rowStride, bl);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.slices : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray2 = new float[FloatDCT_3D.this.rows];
                        for (int i = n3; i < n2; ++i) {
                            int n = i * FloatDCT_3D.this.sliceStride;
                            for (int j = 0; j < FloatDCT_3D.this.columns; ++j) {
                                int n22;
                                int n32;
                                for (n32 = 0; n32 < FloatDCT_3D.this.rows; ++n32) {
                                    n22 = n + n32 * FloatDCT_3D.this.rowStride + j;
                                    fArray2[n32] = fArray[n22];
                                }
                                FloatDCT_3D.this.dctRows.forward(fArray2, bl);
                                for (n32 = 0; n32 < FloatDCT_3D.this.rows; ++n32) {
                                    n22 = n + n32 * FloatDCT_3D.this.rowStride + j;
                                    fArray[n22] = fArray2[n32];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n5 = this.rows / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.rows : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray2 = new float[FloatDCT_3D.this.slices];
                        for (int i = n3; i < n2; ++i) {
                            int n = i * FloatDCT_3D.this.rowStride;
                            for (int j = 0; j < FloatDCT_3D.this.columns; ++j) {
                                int n22;
                                int n32;
                                for (n32 = 0; n32 < FloatDCT_3D.this.slices; ++n32) {
                                    n22 = n32 * FloatDCT_3D.this.sliceStride + n + j;
                                    fArray2[n32] = fArray[n22];
                                }
                                FloatDCT_3D.this.dctSlices.forward(fArray2, bl);
                                for (n32 = 0; n32 < FloatDCT_3D.this.slices; ++n32) {
                                    n22 = n32 * FloatDCT_3D.this.sliceStride + n + j;
                                    fArray[n22] = fArray2[n32];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            for (int i = 0; i < this.slices; ++i) {
                n10 = i * this.sliceStride;
                for (n9 = 0; n9 < this.rows; ++n9) {
                    this.dctColumns.forward(fArray, n10 + n9 * this.rowStride, bl);
                }
            }
            float[] fArray2 = new float[this.rows];
            for (n10 = 0; n10 < this.slices; ++n10) {
                n9 = n10 * this.sliceStride;
                for (n8 = 0; n8 < this.columns; ++n8) {
                    for (n7 = 0; n7 < this.rows; ++n7) {
                        n6 = n9 + n7 * this.rowStride + n8;
                        fArray2[n7] = fArray[n6];
                    }
                    this.dctRows.forward(fArray2, bl);
                    for (n7 = 0; n7 < this.rows; ++n7) {
                        n6 = n9 + n7 * this.rowStride + n8;
                        fArray[n6] = fArray2[n7];
                    }
                }
            }
            fArray2 = new float[this.slices];
            for (n10 = 0; n10 < this.rows; ++n10) {
                n9 = n10 * this.rowStride;
                for (n8 = 0; n8 < this.columns; ++n8) {
                    for (n7 = 0; n7 < this.slices; ++n7) {
                        n6 = n7 * this.sliceStride + n9 + n8;
                        fArray2[n7] = fArray[n6];
                    }
                    this.dctSlices.forward(fArray2, bl);
                    for (n7 = 0; n7 < this.slices; ++n7) {
                        n6 = n7 * this.sliceStride + n9 + n8;
                        fArray[n6] = fArray2[n7];
                    }
                }
            }
        }
    }

    public void forward(final float[][][] fArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 4;
                if (n > 1) {
                    this.nt *= n;
                }
                if (this.columns == 2) {
                    this.nt >>= 1;
                }
                this.t = new float[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, fArray, bl);
                this.ddxt3db_subth(-1, fArray, bl);
            } else {
                this.ddxt3da_sub(-1, fArray, bl);
                this.ddxt3db_sub(-1, fArray, bl);
            }
        } else if (n > 1 && this.useThreads && this.slices >= n && this.rows >= n && this.columns >= n) {
            int n2;
            int n3;
            int n4;
            Future[] futureArray = new Future[n];
            int n5 = this.slices / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.slices : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n2; ++i) {
                            for (int j = 0; j < FloatDCT_3D.this.rows; ++j) {
                                FloatDCT_3D.this.dctColumns.forward(fArray[i][j], bl);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.slices : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray2 = new float[FloatDCT_3D.this.rows];
                        for (int i = n3; i < n2; ++i) {
                            for (int j = 0; j < FloatDCT_3D.this.columns; ++j) {
                                int n;
                                for (n = 0; n < FloatDCT_3D.this.rows; ++n) {
                                    fArray2[n] = fArray[i][n][j];
                                }
                                FloatDCT_3D.this.dctRows.forward(fArray2, bl);
                                for (n = 0; n < FloatDCT_3D.this.rows; ++n) {
                                    fArray[i][n][j] = fArray2[n];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n5 = this.rows / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.rows : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray2 = new float[FloatDCT_3D.this.slices];
                        for (int i = n3; i < n2; ++i) {
                            for (int j = 0; j < FloatDCT_3D.this.columns; ++j) {
                                int n;
                                for (n = 0; n < FloatDCT_3D.this.slices; ++n) {
                                    fArray2[n] = fArray[n][i][j];
                                }
                                FloatDCT_3D.this.dctSlices.forward(fArray2, bl);
                                for (n = 0; n < FloatDCT_3D.this.slices; ++n) {
                                    fArray[n][i][j] = fArray2[n];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6;
            int n7;
            int n8;
            for (int i = 0; i < this.slices; ++i) {
                for (n8 = 0; n8 < this.rows; ++n8) {
                    this.dctColumns.forward(fArray[i][n8], bl);
                }
            }
            float[] fArray2 = new float[this.rows];
            for (n8 = 0; n8 < this.slices; ++n8) {
                for (n7 = 0; n7 < this.columns; ++n7) {
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        fArray2[n6] = fArray[n8][n6][n7];
                    }
                    this.dctRows.forward(fArray2, bl);
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        fArray[n8][n6][n7] = fArray2[n6];
                    }
                }
            }
            fArray2 = new float[this.slices];
            for (n8 = 0; n8 < this.rows; ++n8) {
                for (n7 = 0; n7 < this.columns; ++n7) {
                    for (n6 = 0; n6 < this.slices; ++n6) {
                        fArray2[n6] = fArray[n6][n8][n7];
                    }
                    this.dctSlices.forward(fArray2, bl);
                    for (n6 = 0; n6 < this.slices; ++n6) {
                        fArray[n6][n8][n7] = fArray2[n6];
                    }
                }
            }
        }
    }

    public void inverse(final float[] fArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 4;
                if (n > 1) {
                    this.nt *= n;
                }
                if (this.columns == 2) {
                    this.nt >>= 1;
                }
                this.t = new float[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.ddxt3da_subth(1, fArray, bl);
                this.ddxt3db_subth(1, fArray, bl);
            } else {
                this.ddxt3da_sub(1, fArray, bl);
                this.ddxt3db_sub(1, fArray, bl);
            }
        } else if (n > 1 && this.useThreads && this.slices >= n && this.rows >= n && this.columns >= n) {
            int n2;
            int n3;
            int n4;
            Future[] futureArray = new Future[n];
            int n5 = this.slices / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.slices : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n2; ++i) {
                            int n = i * FloatDCT_3D.this.sliceStride;
                            for (int j = 0; j < FloatDCT_3D.this.rows; ++j) {
                                FloatDCT_3D.this.dctColumns.inverse(fArray, n + j * FloatDCT_3D.this.rowStride, bl);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.slices : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray2 = new float[FloatDCT_3D.this.rows];
                        for (int i = n3; i < n2; ++i) {
                            int n = i * FloatDCT_3D.this.sliceStride;
                            for (int j = 0; j < FloatDCT_3D.this.columns; ++j) {
                                int n22;
                                int n32;
                                for (n32 = 0; n32 < FloatDCT_3D.this.rows; ++n32) {
                                    n22 = n + n32 * FloatDCT_3D.this.rowStride + j;
                                    fArray2[n32] = fArray[n22];
                                }
                                FloatDCT_3D.this.dctRows.inverse(fArray2, bl);
                                for (n32 = 0; n32 < FloatDCT_3D.this.rows; ++n32) {
                                    n22 = n + n32 * FloatDCT_3D.this.rowStride + j;
                                    fArray[n22] = fArray2[n32];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n5 = this.rows / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.rows : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray2 = new float[FloatDCT_3D.this.slices];
                        for (int i = n3; i < n2; ++i) {
                            int n = i * FloatDCT_3D.this.rowStride;
                            for (int j = 0; j < FloatDCT_3D.this.columns; ++j) {
                                int n22;
                                int n32;
                                for (n32 = 0; n32 < FloatDCT_3D.this.slices; ++n32) {
                                    n22 = n32 * FloatDCT_3D.this.sliceStride + n + j;
                                    fArray2[n32] = fArray[n22];
                                }
                                FloatDCT_3D.this.dctSlices.inverse(fArray2, bl);
                                for (n32 = 0; n32 < FloatDCT_3D.this.slices; ++n32) {
                                    n22 = n32 * FloatDCT_3D.this.sliceStride + n + j;
                                    fArray[n22] = fArray2[n32];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            for (int i = 0; i < this.slices; ++i) {
                n10 = i * this.sliceStride;
                for (n9 = 0; n9 < this.rows; ++n9) {
                    this.dctColumns.inverse(fArray, n10 + n9 * this.rowStride, bl);
                }
            }
            float[] fArray2 = new float[this.rows];
            for (n10 = 0; n10 < this.slices; ++n10) {
                n9 = n10 * this.sliceStride;
                for (n8 = 0; n8 < this.columns; ++n8) {
                    for (n7 = 0; n7 < this.rows; ++n7) {
                        n6 = n9 + n7 * this.rowStride + n8;
                        fArray2[n7] = fArray[n6];
                    }
                    this.dctRows.inverse(fArray2, bl);
                    for (n7 = 0; n7 < this.rows; ++n7) {
                        n6 = n9 + n7 * this.rowStride + n8;
                        fArray[n6] = fArray2[n7];
                    }
                }
            }
            fArray2 = new float[this.slices];
            for (n10 = 0; n10 < this.rows; ++n10) {
                n9 = n10 * this.rowStride;
                for (n8 = 0; n8 < this.columns; ++n8) {
                    for (n7 = 0; n7 < this.slices; ++n7) {
                        n6 = n7 * this.sliceStride + n9 + n8;
                        fArray2[n7] = fArray[n6];
                    }
                    this.dctSlices.inverse(fArray2, bl);
                    for (n7 = 0; n7 < this.slices; ++n7) {
                        n6 = n7 * this.sliceStride + n9 + n8;
                        fArray[n6] = fArray2[n7];
                    }
                }
            }
        }
    }

    public void inverse(final float[][][] fArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 4;
                if (n > 1) {
                    this.nt *= n;
                }
                if (this.columns == 2) {
                    this.nt >>= 1;
                }
                this.t = new float[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.ddxt3da_subth(1, fArray, bl);
                this.ddxt3db_subth(1, fArray, bl);
            } else {
                this.ddxt3da_sub(1, fArray, bl);
                this.ddxt3db_sub(1, fArray, bl);
            }
        } else if (n > 1 && this.useThreads && this.slices >= n && this.rows >= n && this.columns >= n) {
            int n2;
            int n3;
            int n4;
            Future[] futureArray = new Future[n];
            int n5 = this.slices / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.slices : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n2; ++i) {
                            for (int j = 0; j < FloatDCT_3D.this.rows; ++j) {
                                FloatDCT_3D.this.dctColumns.inverse(fArray[i][j], bl);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.slices : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray2 = new float[FloatDCT_3D.this.rows];
                        for (int i = n3; i < n2; ++i) {
                            for (int j = 0; j < FloatDCT_3D.this.columns; ++j) {
                                int n;
                                for (n = 0; n < FloatDCT_3D.this.rows; ++n) {
                                    fArray2[n] = fArray[i][n][j];
                                }
                                FloatDCT_3D.this.dctRows.inverse(fArray2, bl);
                                for (n = 0; n < FloatDCT_3D.this.rows; ++n) {
                                    fArray[i][n][j] = fArray2[n];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n5 = this.rows / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.rows : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray2 = new float[FloatDCT_3D.this.slices];
                        for (int i = n3; i < n2; ++i) {
                            for (int j = 0; j < FloatDCT_3D.this.columns; ++j) {
                                int n;
                                for (n = 0; n < FloatDCT_3D.this.slices; ++n) {
                                    fArray2[n] = fArray[n][i][j];
                                }
                                FloatDCT_3D.this.dctSlices.inverse(fArray2, bl);
                                for (n = 0; n < FloatDCT_3D.this.slices; ++n) {
                                    fArray[n][i][j] = fArray2[n];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6;
            int n7;
            int n8;
            for (int i = 0; i < this.slices; ++i) {
                for (n8 = 0; n8 < this.rows; ++n8) {
                    this.dctColumns.inverse(fArray[i][n8], bl);
                }
            }
            float[] fArray2 = new float[this.rows];
            for (n8 = 0; n8 < this.slices; ++n8) {
                for (n7 = 0; n7 < this.columns; ++n7) {
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        fArray2[n6] = fArray[n8][n6][n7];
                    }
                    this.dctRows.inverse(fArray2, bl);
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        fArray[n8][n6][n7] = fArray2[n6];
                    }
                }
            }
            fArray2 = new float[this.slices];
            for (n8 = 0; n8 < this.rows; ++n8) {
                for (n7 = 0; n7 < this.columns; ++n7) {
                    for (n6 = 0; n6 < this.slices; ++n6) {
                        fArray2[n6] = fArray[n6][n8][n7];
                    }
                    this.dctSlices.inverse(fArray2, bl);
                    for (n6 = 0; n6 < this.slices; ++n6) {
                        fArray[n6][n8][n7] = fArray2[n6];
                    }
                }
            }
        }
    }

    private void ddxt3da_sub(int n, float[] fArray, boolean bl) {
        if (n == -1) {
            for (int i = 0; i < this.slices; ++i) {
                int n2;
                int n3;
                int n4 = i * this.sliceStride;
                for (n3 = 0; n3 < this.rows; ++n3) {
                    this.dctColumns.forward(fArray, n4 + n3 * this.rowStride, bl);
                }
                if (this.columns > 2) {
                    for (n3 = 0; n3 < this.columns; n3 += 4) {
                        int n5;
                        int n6;
                        for (n6 = 0; n6 < this.rows; ++n6) {
                            n2 = n4 + n6 * this.rowStride + n3;
                            n5 = this.rows + n6;
                            this.t[n6] = fArray[n2];
                            this.t[n5] = fArray[n2 + 1];
                            this.t[n5 + this.rows] = fArray[n2 + 2];
                            this.t[n5 + 2 * this.rows] = fArray[n2 + 3];
                        }
                        this.dctRows.forward(this.t, 0, bl);
                        this.dctRows.forward(this.t, this.rows, bl);
                        this.dctRows.forward(this.t, 2 * this.rows, bl);
                        this.dctRows.forward(this.t, 3 * this.rows, bl);
                        for (n6 = 0; n6 < this.rows; ++n6) {
                            n2 = n4 + n6 * this.rowStride + n3;
                            n5 = this.rows + n6;
                            fArray[n2] = this.t[n6];
                            fArray[n2 + 1] = this.t[n5];
                            fArray[n2 + 2] = this.t[n5 + this.rows];
                            fArray[n2 + 3] = this.t[n5 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n3 = 0; n3 < this.rows; ++n3) {
                    n2 = n4 + n3 * this.rowStride;
                    this.t[n3] = fArray[n2];
                    this.t[this.rows + n3] = fArray[n2 + 1];
                }
                this.dctRows.forward(this.t, 0, bl);
                this.dctRows.forward(this.t, this.rows, bl);
                for (n3 = 0; n3 < this.rows; ++n3) {
                    n2 = n4 + n3 * this.rowStride;
                    fArray[n2] = this.t[n3];
                    fArray[n2 + 1] = this.t[this.rows + n3];
                }
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                int n7;
                int n8;
                int n9 = i * this.sliceStride;
                for (n8 = 0; n8 < this.rows; ++n8) {
                    this.dctColumns.inverse(fArray, n9 + n8 * this.rowStride, bl);
                }
                if (this.columns > 2) {
                    for (n8 = 0; n8 < this.columns; n8 += 4) {
                        int n10;
                        int n11;
                        for (n11 = 0; n11 < this.rows; ++n11) {
                            n7 = n9 + n11 * this.rowStride + n8;
                            n10 = this.rows + n11;
                            this.t[n11] = fArray[n7];
                            this.t[n10] = fArray[n7 + 1];
                            this.t[n10 + this.rows] = fArray[n7 + 2];
                            this.t[n10 + 2 * this.rows] = fArray[n7 + 3];
                        }
                        this.dctRows.inverse(this.t, 0, bl);
                        this.dctRows.inverse(this.t, this.rows, bl);
                        this.dctRows.inverse(this.t, 2 * this.rows, bl);
                        this.dctRows.inverse(this.t, 3 * this.rows, bl);
                        for (n11 = 0; n11 < this.rows; ++n11) {
                            n7 = n9 + n11 * this.rowStride + n8;
                            n10 = this.rows + n11;
                            fArray[n7] = this.t[n11];
                            fArray[n7 + 1] = this.t[n10];
                            fArray[n7 + 2] = this.t[n10 + this.rows];
                            fArray[n7 + 3] = this.t[n10 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n8 = 0; n8 < this.rows; ++n8) {
                    n7 = n9 + n8 * this.rowStride;
                    this.t[n8] = fArray[n7];
                    this.t[this.rows + n8] = fArray[n7 + 1];
                }
                this.dctRows.inverse(this.t, 0, bl);
                this.dctRows.inverse(this.t, this.rows, bl);
                for (n8 = 0; n8 < this.rows; ++n8) {
                    n7 = n9 + n8 * this.rowStride;
                    fArray[n7] = this.t[n8];
                    fArray[n7 + 1] = this.t[this.rows + n8];
                }
            }
        }
    }

    private void ddxt3da_sub(int n, float[][][] fArray, boolean bl) {
        if (n == -1) {
            for (int i = 0; i < this.slices; ++i) {
                int n2;
                for (n2 = 0; n2 < this.rows; ++n2) {
                    this.dctColumns.forward(fArray[i][n2], bl);
                }
                if (this.columns > 2) {
                    for (n2 = 0; n2 < this.columns; n2 += 4) {
                        int n3;
                        int n4;
                        for (n4 = 0; n4 < this.rows; ++n4) {
                            n3 = this.rows + n4;
                            this.t[n4] = fArray[i][n4][n2];
                            this.t[n3] = fArray[i][n4][n2 + 1];
                            this.t[n3 + this.rows] = fArray[i][n4][n2 + 2];
                            this.t[n3 + 2 * this.rows] = fArray[i][n4][n2 + 3];
                        }
                        this.dctRows.forward(this.t, 0, bl);
                        this.dctRows.forward(this.t, this.rows, bl);
                        this.dctRows.forward(this.t, 2 * this.rows, bl);
                        this.dctRows.forward(this.t, 3 * this.rows, bl);
                        for (n4 = 0; n4 < this.rows; ++n4) {
                            n3 = this.rows + n4;
                            fArray[i][n4][n2] = this.t[n4];
                            fArray[i][n4][n2 + 1] = this.t[n3];
                            fArray[i][n4][n2 + 2] = this.t[n3 + this.rows];
                            fArray[i][n4][n2 + 3] = this.t[n3 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n2 = 0; n2 < this.rows; ++n2) {
                    this.t[n2] = fArray[i][n2][0];
                    this.t[this.rows + n2] = fArray[i][n2][1];
                }
                this.dctRows.forward(this.t, 0, bl);
                this.dctRows.forward(this.t, this.rows, bl);
                for (n2 = 0; n2 < this.rows; ++n2) {
                    fArray[i][n2][0] = this.t[n2];
                    fArray[i][n2][1] = this.t[this.rows + n2];
                }
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                int n5;
                for (n5 = 0; n5 < this.rows; ++n5) {
                    this.dctColumns.inverse(fArray[i][n5], bl);
                }
                if (this.columns > 2) {
                    for (n5 = 0; n5 < this.columns; n5 += 4) {
                        int n6;
                        int n7;
                        for (n7 = 0; n7 < this.rows; ++n7) {
                            n6 = this.rows + n7;
                            this.t[n7] = fArray[i][n7][n5];
                            this.t[n6] = fArray[i][n7][n5 + 1];
                            this.t[n6 + this.rows] = fArray[i][n7][n5 + 2];
                            this.t[n6 + 2 * this.rows] = fArray[i][n7][n5 + 3];
                        }
                        this.dctRows.inverse(this.t, 0, bl);
                        this.dctRows.inverse(this.t, this.rows, bl);
                        this.dctRows.inverse(this.t, 2 * this.rows, bl);
                        this.dctRows.inverse(this.t, 3 * this.rows, bl);
                        for (n7 = 0; n7 < this.rows; ++n7) {
                            n6 = this.rows + n7;
                            fArray[i][n7][n5] = this.t[n7];
                            fArray[i][n7][n5 + 1] = this.t[n6];
                            fArray[i][n7][n5 + 2] = this.t[n6 + this.rows];
                            fArray[i][n7][n5 + 3] = this.t[n6 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n5 = 0; n5 < this.rows; ++n5) {
                    this.t[n5] = fArray[i][n5][0];
                    this.t[this.rows + n5] = fArray[i][n5][1];
                }
                this.dctRows.inverse(this.t, 0, bl);
                this.dctRows.inverse(this.t, this.rows, bl);
                for (n5 = 0; n5 < this.rows; ++n5) {
                    fArray[i][n5][0] = this.t[n5];
                    fArray[i][n5][1] = this.t[this.rows + n5];
                }
            }
        }
    }

    private void ddxt3db_sub(int n, float[] fArray, boolean bl) {
        block19: {
            block17: {
                block18: {
                    if (n != -1) break block17;
                    if (this.columns <= 2) break block18;
                    for (int i = 0; i < this.rows; ++i) {
                        int n2 = i * this.rowStride;
                        for (int j = 0; j < this.columns; j += 4) {
                            int n3;
                            int n4;
                            int n5;
                            for (n5 = 0; n5 < this.slices; ++n5) {
                                n4 = n5 * this.sliceStride + n2 + j;
                                n3 = this.slices + n5;
                                this.t[n5] = fArray[n4];
                                this.t[n3] = fArray[n4 + 1];
                                this.t[n3 + this.slices] = fArray[n4 + 2];
                                this.t[n3 + 2 * this.slices] = fArray[n4 + 3];
                            }
                            this.dctSlices.forward(this.t, 0, bl);
                            this.dctSlices.forward(this.t, this.slices, bl);
                            this.dctSlices.forward(this.t, 2 * this.slices, bl);
                            this.dctSlices.forward(this.t, 3 * this.slices, bl);
                            for (n5 = 0; n5 < this.slices; ++n5) {
                                n4 = n5 * this.sliceStride + n2 + j;
                                n3 = this.slices + n5;
                                fArray[n4] = this.t[n5];
                                fArray[n4 + 1] = this.t[n3];
                                fArray[n4 + 2] = this.t[n3 + this.slices];
                                fArray[n4 + 3] = this.t[n3 + 2 * this.slices];
                            }
                        }
                    }
                    break block19;
                }
                if (this.columns != 2) break block19;
                for (int i = 0; i < this.rows; ++i) {
                    int n6;
                    int n7;
                    int n8 = i * this.rowStride;
                    for (n7 = 0; n7 < this.slices; ++n7) {
                        n6 = n7 * this.sliceStride + n8;
                        this.t[n7] = fArray[n6];
                        this.t[this.slices + n7] = fArray[n6 + 1];
                    }
                    this.dctSlices.forward(this.t, 0, bl);
                    this.dctSlices.forward(this.t, this.slices, bl);
                    for (n7 = 0; n7 < this.slices; ++n7) {
                        n6 = n7 * this.sliceStride + n8;
                        fArray[n6] = this.t[n7];
                        fArray[n6 + 1] = this.t[this.slices + n7];
                    }
                }
                break block19;
            }
            if (this.columns > 2) {
                for (int i = 0; i < this.rows; ++i) {
                    int n9 = i * this.rowStride;
                    for (int j = 0; j < this.columns; j += 4) {
                        int n10;
                        int n11;
                        int n12;
                        for (n12 = 0; n12 < this.slices; ++n12) {
                            n11 = n12 * this.sliceStride + n9 + j;
                            n10 = this.slices + n12;
                            this.t[n12] = fArray[n11];
                            this.t[n10] = fArray[n11 + 1];
                            this.t[n10 + this.slices] = fArray[n11 + 2];
                            this.t[n10 + 2 * this.slices] = fArray[n11 + 3];
                        }
                        this.dctSlices.inverse(this.t, 0, bl);
                        this.dctSlices.inverse(this.t, this.slices, bl);
                        this.dctSlices.inverse(this.t, 2 * this.slices, bl);
                        this.dctSlices.inverse(this.t, 3 * this.slices, bl);
                        for (n12 = 0; n12 < this.slices; ++n12) {
                            n11 = n12 * this.sliceStride + n9 + j;
                            n10 = this.slices + n12;
                            fArray[n11] = this.t[n12];
                            fArray[n11 + 1] = this.t[n10];
                            fArray[n11 + 2] = this.t[n10 + this.slices];
                            fArray[n11 + 3] = this.t[n10 + 2 * this.slices];
                        }
                    }
                }
            } else if (this.columns == 2) {
                for (int i = 0; i < this.rows; ++i) {
                    int n13;
                    int n14;
                    int n15 = i * this.rowStride;
                    for (n14 = 0; n14 < this.slices; ++n14) {
                        n13 = n14 * this.sliceStride + n15;
                        this.t[n14] = fArray[n13];
                        this.t[this.slices + n14] = fArray[n13 + 1];
                    }
                    this.dctSlices.inverse(this.t, 0, bl);
                    this.dctSlices.inverse(this.t, this.slices, bl);
                    for (n14 = 0; n14 < this.slices; ++n14) {
                        n13 = n14 * this.sliceStride + n15;
                        fArray[n13] = this.t[n14];
                        fArray[n13 + 1] = this.t[this.slices + n14];
                    }
                }
            }
        }
    }

    private void ddxt3db_sub(int n, float[][][] fArray, boolean bl) {
        block19: {
            block17: {
                block18: {
                    if (n != -1) break block17;
                    if (this.columns <= 2) break block18;
                    for (int i = 0; i < this.rows; ++i) {
                        for (int j = 0; j < this.columns; j += 4) {
                            int n2;
                            int n3;
                            for (n3 = 0; n3 < this.slices; ++n3) {
                                n2 = this.slices + n3;
                                this.t[n3] = fArray[n3][i][j];
                                this.t[n2] = fArray[n3][i][j + 1];
                                this.t[n2 + this.slices] = fArray[n3][i][j + 2];
                                this.t[n2 + 2 * this.slices] = fArray[n3][i][j + 3];
                            }
                            this.dctSlices.forward(this.t, 0, bl);
                            this.dctSlices.forward(this.t, this.slices, bl);
                            this.dctSlices.forward(this.t, 2 * this.slices, bl);
                            this.dctSlices.forward(this.t, 3 * this.slices, bl);
                            for (n3 = 0; n3 < this.slices; ++n3) {
                                n2 = this.slices + n3;
                                fArray[n3][i][j] = this.t[n3];
                                fArray[n3][i][j + 1] = this.t[n2];
                                fArray[n3][i][j + 2] = this.t[n2 + this.slices];
                                fArray[n3][i][j + 3] = this.t[n2 + 2 * this.slices];
                            }
                        }
                    }
                    break block19;
                }
                if (this.columns != 2) break block19;
                for (int i = 0; i < this.rows; ++i) {
                    int n4;
                    for (n4 = 0; n4 < this.slices; ++n4) {
                        this.t[n4] = fArray[n4][i][0];
                        this.t[this.slices + n4] = fArray[n4][i][1];
                    }
                    this.dctSlices.forward(this.t, 0, bl);
                    this.dctSlices.forward(this.t, this.slices, bl);
                    for (n4 = 0; n4 < this.slices; ++n4) {
                        fArray[n4][i][0] = this.t[n4];
                        fArray[n4][i][1] = this.t[this.slices + n4];
                    }
                }
                break block19;
            }
            if (this.columns > 2) {
                for (int i = 0; i < this.rows; ++i) {
                    for (int j = 0; j < this.columns; j += 4) {
                        int n5;
                        int n6;
                        for (n6 = 0; n6 < this.slices; ++n6) {
                            n5 = this.slices + n6;
                            this.t[n6] = fArray[n6][i][j];
                            this.t[n5] = fArray[n6][i][j + 1];
                            this.t[n5 + this.slices] = fArray[n6][i][j + 2];
                            this.t[n5 + 2 * this.slices] = fArray[n6][i][j + 3];
                        }
                        this.dctSlices.inverse(this.t, 0, bl);
                        this.dctSlices.inverse(this.t, this.slices, bl);
                        this.dctSlices.inverse(this.t, 2 * this.slices, bl);
                        this.dctSlices.inverse(this.t, 3 * this.slices, bl);
                        for (n6 = 0; n6 < this.slices; ++n6) {
                            n5 = this.slices + n6;
                            fArray[n6][i][j] = this.t[n6];
                            fArray[n6][i][j + 1] = this.t[n5];
                            fArray[n6][i][j + 2] = this.t[n5 + this.slices];
                            fArray[n6][i][j + 3] = this.t[n5 + 2 * this.slices];
                        }
                    }
                }
            } else if (this.columns == 2) {
                for (int i = 0; i < this.rows; ++i) {
                    int n7;
                    for (n7 = 0; n7 < this.slices; ++n7) {
                        this.t[n7] = fArray[n7][i][0];
                        this.t[this.slices + n7] = fArray[n7][i][1];
                    }
                    this.dctSlices.inverse(this.t, 0, bl);
                    this.dctSlices.inverse(this.t, this.slices, bl);
                    for (n7 = 0; n7 < this.slices; ++n7) {
                        fArray[n7][i][0] = this.t[n7];
                        fArray[n7][i][1] = this.t[this.slices + n7];
                    }
                }
            }
        }
    }

    private void ddxt3da_subth(final int n, final float[] fArray, final boolean bl) {
        final int n2 = ConcurrencyUtils.getNumberOfThreads() > this.slices ? this.slices : ConcurrencyUtils.getNumberOfThreads();
        int n3 = 4 * this.rows;
        if (this.columns == 2) {
            n3 >>= 1;
        }
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final int n4 = i;
            final int n5 = n3 * i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    if (n == -1) {
                        for (int i = n4; i < FloatDCT_3D.this.slices; i += n2) {
                            int n10;
                            int n22;
                            int n3 = i * FloatDCT_3D.this.sliceStride;
                            for (n22 = 0; n22 < FloatDCT_3D.this.rows; ++n22) {
                                FloatDCT_3D.this.dctColumns.forward(fArray, n3 + n22 * FloatDCT_3D.this.rowStride, bl);
                            }
                            if (FloatDCT_3D.this.columns > 2) {
                                for (n22 = 0; n22 < FloatDCT_3D.this.columns; n22 += 4) {
                                    int n42;
                                    int n52;
                                    for (n52 = 0; n52 < FloatDCT_3D.this.rows; ++n52) {
                                        n10 = n3 + n52 * FloatDCT_3D.this.rowStride + n22;
                                        n42 = n5 + FloatDCT_3D.this.rows + n52;
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[n5 + n52] = fArray[n10];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[n42] = fArray[n10 + 1];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[n42 + ((FloatDCT_3D)FloatDCT_3D.this).rows] = fArray[n10 + 2];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[n42 + 2 * ((FloatDCT_3D)FloatDCT_3D.this).rows] = fArray[n10 + 3];
                                    }
                                    FloatDCT_3D.this.dctRows.forward(FloatDCT_3D.this.t, n5, bl);
                                    FloatDCT_3D.this.dctRows.forward(FloatDCT_3D.this.t, n5 + FloatDCT_3D.this.rows, bl);
                                    FloatDCT_3D.this.dctRows.forward(FloatDCT_3D.this.t, n5 + 2 * FloatDCT_3D.this.rows, bl);
                                    FloatDCT_3D.this.dctRows.forward(FloatDCT_3D.this.t, n5 + 3 * FloatDCT_3D.this.rows, bl);
                                    for (n52 = 0; n52 < FloatDCT_3D.this.rows; ++n52) {
                                        n10 = n3 + n52 * FloatDCT_3D.this.rowStride + n22;
                                        n42 = n5 + FloatDCT_3D.this.rows + n52;
                                        fArray[n10] = FloatDCT_3D.this.t[n5 + n52];
                                        fArray[n10 + 1] = FloatDCT_3D.this.t[n42];
                                        fArray[n10 + 2] = FloatDCT_3D.this.t[n42 + FloatDCT_3D.this.rows];
                                        fArray[n10 + 3] = FloatDCT_3D.this.t[n42 + 2 * FloatDCT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (FloatDCT_3D.this.columns != 2) continue;
                            for (n22 = 0; n22 < FloatDCT_3D.this.rows; ++n22) {
                                n10 = n3 + n22 * FloatDCT_3D.this.rowStride;
                                ((FloatDCT_3D)FloatDCT_3D.this).t[n5 + n22] = fArray[n10];
                                ((FloatDCT_3D)FloatDCT_3D.this).t[n5 + ((FloatDCT_3D)FloatDCT_3D.this).rows + n22] = fArray[n10 + 1];
                            }
                            FloatDCT_3D.this.dctRows.forward(FloatDCT_3D.this.t, n5, bl);
                            FloatDCT_3D.this.dctRows.forward(FloatDCT_3D.this.t, n5 + FloatDCT_3D.this.rows, bl);
                            for (n22 = 0; n22 < FloatDCT_3D.this.rows; ++n22) {
                                n10 = n3 + n22 * FloatDCT_3D.this.rowStride;
                                fArray[n10] = FloatDCT_3D.this.t[n5 + n22];
                                fArray[n10 + 1] = FloatDCT_3D.this.t[n5 + FloatDCT_3D.this.rows + n22];
                            }
                        }
                    } else {
                        for (int i = n4; i < FloatDCT_3D.this.slices; i += n2) {
                            int n11;
                            int n6;
                            int n7 = i * FloatDCT_3D.this.sliceStride;
                            for (n6 = 0; n6 < FloatDCT_3D.this.rows; ++n6) {
                                FloatDCT_3D.this.dctColumns.inverse(fArray, n7 + n6 * FloatDCT_3D.this.rowStride, bl);
                            }
                            if (FloatDCT_3D.this.columns > 2) {
                                for (n6 = 0; n6 < FloatDCT_3D.this.columns; n6 += 4) {
                                    int n8;
                                    int n9;
                                    for (n9 = 0; n9 < FloatDCT_3D.this.rows; ++n9) {
                                        n11 = n7 + n9 * FloatDCT_3D.this.rowStride + n6;
                                        n8 = n5 + FloatDCT_3D.this.rows + n9;
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[n5 + n9] = fArray[n11];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[n8] = fArray[n11 + 1];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[n8 + ((FloatDCT_3D)FloatDCT_3D.this).rows] = fArray[n11 + 2];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[n8 + 2 * ((FloatDCT_3D)FloatDCT_3D.this).rows] = fArray[n11 + 3];
                                    }
                                    FloatDCT_3D.this.dctRows.inverse(FloatDCT_3D.this.t, n5, bl);
                                    FloatDCT_3D.this.dctRows.inverse(FloatDCT_3D.this.t, n5 + FloatDCT_3D.this.rows, bl);
                                    FloatDCT_3D.this.dctRows.inverse(FloatDCT_3D.this.t, n5 + 2 * FloatDCT_3D.this.rows, bl);
                                    FloatDCT_3D.this.dctRows.inverse(FloatDCT_3D.this.t, n5 + 3 * FloatDCT_3D.this.rows, bl);
                                    for (n9 = 0; n9 < FloatDCT_3D.this.rows; ++n9) {
                                        n11 = n7 + n9 * FloatDCT_3D.this.rowStride + n6;
                                        n8 = n5 + FloatDCT_3D.this.rows + n9;
                                        fArray[n11] = FloatDCT_3D.this.t[n5 + n9];
                                        fArray[n11 + 1] = FloatDCT_3D.this.t[n8];
                                        fArray[n11 + 2] = FloatDCT_3D.this.t[n8 + FloatDCT_3D.this.rows];
                                        fArray[n11 + 3] = FloatDCT_3D.this.t[n8 + 2 * FloatDCT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (FloatDCT_3D.this.columns != 2) continue;
                            for (n6 = 0; n6 < FloatDCT_3D.this.rows; ++n6) {
                                n11 = n7 + n6 * FloatDCT_3D.this.rowStride;
                                ((FloatDCT_3D)FloatDCT_3D.this).t[n5 + n6] = fArray[n11];
                                ((FloatDCT_3D)FloatDCT_3D.this).t[n5 + ((FloatDCT_3D)FloatDCT_3D.this).rows + n6] = fArray[n11 + 1];
                            }
                            FloatDCT_3D.this.dctRows.inverse(FloatDCT_3D.this.t, n5, bl);
                            FloatDCT_3D.this.dctRows.inverse(FloatDCT_3D.this.t, n5 + FloatDCT_3D.this.rows, bl);
                            for (n6 = 0; n6 < FloatDCT_3D.this.rows; ++n6) {
                                n11 = n7 + n6 * FloatDCT_3D.this.rowStride;
                                fArray[n11] = FloatDCT_3D.this.t[n5 + n6];
                                fArray[n11 + 1] = FloatDCT_3D.this.t[n5 + FloatDCT_3D.this.rows + n6];
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void ddxt3da_subth(final int n, final float[][][] fArray, final boolean bl) {
        final int n2 = ConcurrencyUtils.getNumberOfThreads() > this.slices ? this.slices : ConcurrencyUtils.getNumberOfThreads();
        int n3 = 4 * this.rows;
        if (this.columns == 2) {
            n3 >>= 1;
        }
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final int n4 = i;
            final int n5 = n3 * i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    if (n == -1) {
                        for (int i = n4; i < FloatDCT_3D.this.slices; i += n2) {
                            int n6;
                            for (n6 = 0; n6 < FloatDCT_3D.this.rows; ++n6) {
                                FloatDCT_3D.this.dctColumns.forward(fArray[i][n6], bl);
                            }
                            if (FloatDCT_3D.this.columns > 2) {
                                for (n6 = 0; n6 < FloatDCT_3D.this.columns; n6 += 4) {
                                    int n22;
                                    int n3;
                                    for (n3 = 0; n3 < FloatDCT_3D.this.rows; ++n3) {
                                        n22 = n5 + FloatDCT_3D.this.rows + n3;
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[n5 + n3] = fArray[i][n3][n6];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[n22] = fArray[i][n3][n6 + 1];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[n22 + ((FloatDCT_3D)FloatDCT_3D.this).rows] = fArray[i][n3][n6 + 2];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[n22 + 2 * ((FloatDCT_3D)FloatDCT_3D.this).rows] = fArray[i][n3][n6 + 3];
                                    }
                                    FloatDCT_3D.this.dctRows.forward(FloatDCT_3D.this.t, n5, bl);
                                    FloatDCT_3D.this.dctRows.forward(FloatDCT_3D.this.t, n5 + FloatDCT_3D.this.rows, bl);
                                    FloatDCT_3D.this.dctRows.forward(FloatDCT_3D.this.t, n5 + 2 * FloatDCT_3D.this.rows, bl);
                                    FloatDCT_3D.this.dctRows.forward(FloatDCT_3D.this.t, n5 + 3 * FloatDCT_3D.this.rows, bl);
                                    for (n3 = 0; n3 < FloatDCT_3D.this.rows; ++n3) {
                                        n22 = n5 + FloatDCT_3D.this.rows + n3;
                                        fArray[i][n3][n6] = FloatDCT_3D.this.t[n5 + n3];
                                        fArray[i][n3][n6 + 1] = FloatDCT_3D.this.t[n22];
                                        fArray[i][n3][n6 + 2] = FloatDCT_3D.this.t[n22 + FloatDCT_3D.this.rows];
                                        fArray[i][n3][n6 + 3] = FloatDCT_3D.this.t[n22 + 2 * FloatDCT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (FloatDCT_3D.this.columns != 2) continue;
                            for (n6 = 0; n6 < FloatDCT_3D.this.rows; ++n6) {
                                ((FloatDCT_3D)FloatDCT_3D.this).t[n5 + n6] = fArray[i][n6][0];
                                ((FloatDCT_3D)FloatDCT_3D.this).t[n5 + ((FloatDCT_3D)FloatDCT_3D.this).rows + n6] = fArray[i][n6][1];
                            }
                            FloatDCT_3D.this.dctRows.forward(FloatDCT_3D.this.t, n5, bl);
                            FloatDCT_3D.this.dctRows.forward(FloatDCT_3D.this.t, n5 + FloatDCT_3D.this.rows, bl);
                            for (n6 = 0; n6 < FloatDCT_3D.this.rows; ++n6) {
                                fArray[i][n6][0] = FloatDCT_3D.this.t[n5 + n6];
                                fArray[i][n6][1] = FloatDCT_3D.this.t[n5 + FloatDCT_3D.this.rows + n6];
                            }
                        }
                    } else {
                        for (int i = n4; i < FloatDCT_3D.this.slices; i += n2) {
                            int n7;
                            for (n7 = 0; n7 < FloatDCT_3D.this.rows; ++n7) {
                                FloatDCT_3D.this.dctColumns.inverse(fArray[i][n7], bl);
                            }
                            if (FloatDCT_3D.this.columns > 2) {
                                for (n7 = 0; n7 < FloatDCT_3D.this.columns; n7 += 4) {
                                    int n42;
                                    int n52;
                                    for (n52 = 0; n52 < FloatDCT_3D.this.rows; ++n52) {
                                        n42 = n5 + FloatDCT_3D.this.rows + n52;
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[n5 + n52] = fArray[i][n52][n7];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[n42] = fArray[i][n52][n7 + 1];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[n42 + ((FloatDCT_3D)FloatDCT_3D.this).rows] = fArray[i][n52][n7 + 2];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[n42 + 2 * ((FloatDCT_3D)FloatDCT_3D.this).rows] = fArray[i][n52][n7 + 3];
                                    }
                                    FloatDCT_3D.this.dctRows.inverse(FloatDCT_3D.this.t, n5, bl);
                                    FloatDCT_3D.this.dctRows.inverse(FloatDCT_3D.this.t, n5 + FloatDCT_3D.this.rows, bl);
                                    FloatDCT_3D.this.dctRows.inverse(FloatDCT_3D.this.t, n5 + 2 * FloatDCT_3D.this.rows, bl);
                                    FloatDCT_3D.this.dctRows.inverse(FloatDCT_3D.this.t, n5 + 3 * FloatDCT_3D.this.rows, bl);
                                    for (n52 = 0; n52 < FloatDCT_3D.this.rows; ++n52) {
                                        n42 = n5 + FloatDCT_3D.this.rows + n52;
                                        fArray[i][n52][n7] = FloatDCT_3D.this.t[n5 + n52];
                                        fArray[i][n52][n7 + 1] = FloatDCT_3D.this.t[n42];
                                        fArray[i][n52][n7 + 2] = FloatDCT_3D.this.t[n42 + FloatDCT_3D.this.rows];
                                        fArray[i][n52][n7 + 3] = FloatDCT_3D.this.t[n42 + 2 * FloatDCT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (FloatDCT_3D.this.columns != 2) continue;
                            for (n7 = 0; n7 < FloatDCT_3D.this.rows; ++n7) {
                                ((FloatDCT_3D)FloatDCT_3D.this).t[n5 + n7] = fArray[i][n7][0];
                                ((FloatDCT_3D)FloatDCT_3D.this).t[n5 + ((FloatDCT_3D)FloatDCT_3D.this).rows + n7] = fArray[i][n7][1];
                            }
                            FloatDCT_3D.this.dctRows.inverse(FloatDCT_3D.this.t, n5, bl);
                            FloatDCT_3D.this.dctRows.inverse(FloatDCT_3D.this.t, n5 + FloatDCT_3D.this.rows, bl);
                            for (n7 = 0; n7 < FloatDCT_3D.this.rows; ++n7) {
                                fArray[i][n7][0] = FloatDCT_3D.this.t[n5 + n7];
                                fArray[i][n7][1] = FloatDCT_3D.this.t[n5 + FloatDCT_3D.this.rows + n7];
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void ddxt3db_subth(final int n, final float[] fArray, final boolean bl) {
        final int n2 = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        int n3 = 4 * this.slices;
        if (this.columns == 2) {
            n3 >>= 1;
        }
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final int n4 = i;
            final int n5 = n3 * i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    block19: {
                        block17: {
                            block18: {
                                if (n != -1) break block17;
                                if (FloatDCT_3D.this.columns <= 2) break block18;
                                for (int i = n4; i < FloatDCT_3D.this.rows; i += n2) {
                                    int n12 = i * FloatDCT_3D.this.rowStride;
                                    for (int j = 0; j < FloatDCT_3D.this.columns; j += 4) {
                                        int n22;
                                        int n3;
                                        int n42;
                                        for (n42 = 0; n42 < FloatDCT_3D.this.slices; ++n42) {
                                            n3 = n42 * FloatDCT_3D.this.sliceStride + n12 + j;
                                            n22 = n5 + FloatDCT_3D.this.slices + n42;
                                            ((FloatDCT_3D)FloatDCT_3D.this).t[n5 + n42] = fArray[n3];
                                            ((FloatDCT_3D)FloatDCT_3D.this).t[n22] = fArray[n3 + 1];
                                            ((FloatDCT_3D)FloatDCT_3D.this).t[n22 + ((FloatDCT_3D)FloatDCT_3D.this).slices] = fArray[n3 + 2];
                                            ((FloatDCT_3D)FloatDCT_3D.this).t[n22 + 2 * ((FloatDCT_3D)FloatDCT_3D.this).slices] = fArray[n3 + 3];
                                        }
                                        FloatDCT_3D.this.dctSlices.forward(FloatDCT_3D.this.t, n5, bl);
                                        FloatDCT_3D.this.dctSlices.forward(FloatDCT_3D.this.t, n5 + FloatDCT_3D.this.slices, bl);
                                        FloatDCT_3D.this.dctSlices.forward(FloatDCT_3D.this.t, n5 + 2 * FloatDCT_3D.this.slices, bl);
                                        FloatDCT_3D.this.dctSlices.forward(FloatDCT_3D.this.t, n5 + 3 * FloatDCT_3D.this.slices, bl);
                                        for (n42 = 0; n42 < FloatDCT_3D.this.slices; ++n42) {
                                            n3 = n42 * FloatDCT_3D.this.sliceStride + n12 + j;
                                            n22 = n5 + FloatDCT_3D.this.slices + n42;
                                            fArray[n3] = FloatDCT_3D.this.t[n5 + n42];
                                            fArray[n3 + 1] = FloatDCT_3D.this.t[n22];
                                            fArray[n3 + 2] = FloatDCT_3D.this.t[n22 + FloatDCT_3D.this.slices];
                                            fArray[n3 + 3] = FloatDCT_3D.this.t[n22 + 2 * FloatDCT_3D.this.slices];
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (FloatDCT_3D.this.columns != 2) break block19;
                            for (int i = n4; i < FloatDCT_3D.this.rows; i += n2) {
                                int n13;
                                int n52;
                                int n6 = i * FloatDCT_3D.this.rowStride;
                                for (n52 = 0; n52 < FloatDCT_3D.this.slices; ++n52) {
                                    n13 = n52 * FloatDCT_3D.this.sliceStride + n6;
                                    ((FloatDCT_3D)FloatDCT_3D.this).t[n5 + n52] = fArray[n13];
                                    ((FloatDCT_3D)FloatDCT_3D.this).t[n5 + ((FloatDCT_3D)FloatDCT_3D.this).slices + n52] = fArray[n13 + 1];
                                }
                                FloatDCT_3D.this.dctSlices.forward(FloatDCT_3D.this.t, n5, bl);
                                FloatDCT_3D.this.dctSlices.forward(FloatDCT_3D.this.t, n5 + FloatDCT_3D.this.slices, bl);
                                for (n52 = 0; n52 < FloatDCT_3D.this.slices; ++n52) {
                                    n13 = n52 * FloatDCT_3D.this.sliceStride + n6;
                                    fArray[n13] = FloatDCT_3D.this.t[n5 + n52];
                                    fArray[n13 + 1] = FloatDCT_3D.this.t[n5 + FloatDCT_3D.this.slices + n52];
                                }
                            }
                            break block19;
                        }
                        if (FloatDCT_3D.this.columns > 2) {
                            for (int i = n4; i < FloatDCT_3D.this.rows; i += n2) {
                                int n14 = i * FloatDCT_3D.this.rowStride;
                                for (int j = 0; j < FloatDCT_3D.this.columns; j += 4) {
                                    int n7;
                                    int n8;
                                    int n9;
                                    for (n9 = 0; n9 < FloatDCT_3D.this.slices; ++n9) {
                                        n8 = n9 * FloatDCT_3D.this.sliceStride + n14 + j;
                                        n7 = n5 + FloatDCT_3D.this.slices + n9;
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[n5 + n9] = fArray[n8];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[n7] = fArray[n8 + 1];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[n7 + ((FloatDCT_3D)FloatDCT_3D.this).slices] = fArray[n8 + 2];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[n7 + 2 * ((FloatDCT_3D)FloatDCT_3D.this).slices] = fArray[n8 + 3];
                                    }
                                    FloatDCT_3D.this.dctSlices.inverse(FloatDCT_3D.this.t, n5, bl);
                                    FloatDCT_3D.this.dctSlices.inverse(FloatDCT_3D.this.t, n5 + FloatDCT_3D.this.slices, bl);
                                    FloatDCT_3D.this.dctSlices.inverse(FloatDCT_3D.this.t, n5 + 2 * FloatDCT_3D.this.slices, bl);
                                    FloatDCT_3D.this.dctSlices.inverse(FloatDCT_3D.this.t, n5 + 3 * FloatDCT_3D.this.slices, bl);
                                    for (n9 = 0; n9 < FloatDCT_3D.this.slices; ++n9) {
                                        n8 = n9 * FloatDCT_3D.this.sliceStride + n14 + j;
                                        n7 = n5 + FloatDCT_3D.this.slices + n9;
                                        fArray[n8] = FloatDCT_3D.this.t[n5 + n9];
                                        fArray[n8 + 1] = FloatDCT_3D.this.t[n7];
                                        fArray[n8 + 2] = FloatDCT_3D.this.t[n7 + FloatDCT_3D.this.slices];
                                        fArray[n8 + 3] = FloatDCT_3D.this.t[n7 + 2 * FloatDCT_3D.this.slices];
                                    }
                                }
                            }
                        } else if (FloatDCT_3D.this.columns == 2) {
                            for (int i = n4; i < FloatDCT_3D.this.rows; i += n2) {
                                int n15;
                                int n10;
                                int n11 = i * FloatDCT_3D.this.rowStride;
                                for (n10 = 0; n10 < FloatDCT_3D.this.slices; ++n10) {
                                    n15 = n10 * FloatDCT_3D.this.sliceStride + n11;
                                    ((FloatDCT_3D)FloatDCT_3D.this).t[n5 + n10] = fArray[n15];
                                    ((FloatDCT_3D)FloatDCT_3D.this).t[n5 + ((FloatDCT_3D)FloatDCT_3D.this).slices + n10] = fArray[n15 + 1];
                                }
                                FloatDCT_3D.this.dctSlices.inverse(FloatDCT_3D.this.t, n5, bl);
                                FloatDCT_3D.this.dctSlices.inverse(FloatDCT_3D.this.t, n5 + FloatDCT_3D.this.slices, bl);
                                for (n10 = 0; n10 < FloatDCT_3D.this.slices; ++n10) {
                                    n15 = n10 * FloatDCT_3D.this.sliceStride + n11;
                                    fArray[n15] = FloatDCT_3D.this.t[n5 + n10];
                                    fArray[n15 + 1] = FloatDCT_3D.this.t[n5 + FloatDCT_3D.this.slices + n10];
                                }
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void ddxt3db_subth(final int n, final float[][][] fArray, final boolean bl) {
        final int n2 = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        int n3 = 4 * this.slices;
        if (this.columns == 2) {
            n3 >>= 1;
        }
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final int n4 = i;
            final int n5 = n3 * i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    block19: {
                        block17: {
                            block18: {
                                if (n != -1) break block17;
                                if (FloatDCT_3D.this.columns <= 2) break block18;
                                for (int i = n4; i < FloatDCT_3D.this.rows; i += n2) {
                                    for (int j = 0; j < FloatDCT_3D.this.columns; j += 4) {
                                        int n6;
                                        int n22;
                                        for (n22 = 0; n22 < FloatDCT_3D.this.slices; ++n22) {
                                            n6 = n5 + FloatDCT_3D.this.slices + n22;
                                            ((FloatDCT_3D)FloatDCT_3D.this).t[n5 + n22] = fArray[n22][i][j];
                                            ((FloatDCT_3D)FloatDCT_3D.this).t[n6] = fArray[n22][i][j + 1];
                                            ((FloatDCT_3D)FloatDCT_3D.this).t[n6 + ((FloatDCT_3D)FloatDCT_3D.this).slices] = fArray[n22][i][j + 2];
                                            ((FloatDCT_3D)FloatDCT_3D.this).t[n6 + 2 * ((FloatDCT_3D)FloatDCT_3D.this).slices] = fArray[n22][i][j + 3];
                                        }
                                        FloatDCT_3D.this.dctSlices.forward(FloatDCT_3D.this.t, n5, bl);
                                        FloatDCT_3D.this.dctSlices.forward(FloatDCT_3D.this.t, n5 + FloatDCT_3D.this.slices, bl);
                                        FloatDCT_3D.this.dctSlices.forward(FloatDCT_3D.this.t, n5 + 2 * FloatDCT_3D.this.slices, bl);
                                        FloatDCT_3D.this.dctSlices.forward(FloatDCT_3D.this.t, n5 + 3 * FloatDCT_3D.this.slices, bl);
                                        for (n22 = 0; n22 < FloatDCT_3D.this.slices; ++n22) {
                                            n6 = n5 + FloatDCT_3D.this.slices + n22;
                                            fArray[n22][i][j] = FloatDCT_3D.this.t[n5 + n22];
                                            fArray[n22][i][j + 1] = FloatDCT_3D.this.t[n6];
                                            fArray[n22][i][j + 2] = FloatDCT_3D.this.t[n6 + FloatDCT_3D.this.slices];
                                            fArray[n22][i][j + 3] = FloatDCT_3D.this.t[n6 + 2 * FloatDCT_3D.this.slices];
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (FloatDCT_3D.this.columns != 2) break block19;
                            for (int i = n4; i < FloatDCT_3D.this.rows; i += n2) {
                                int n7;
                                for (n7 = 0; n7 < FloatDCT_3D.this.slices; ++n7) {
                                    ((FloatDCT_3D)FloatDCT_3D.this).t[n5 + n7] = fArray[n7][i][0];
                                    ((FloatDCT_3D)FloatDCT_3D.this).t[n5 + ((FloatDCT_3D)FloatDCT_3D.this).slices + n7] = fArray[n7][i][1];
                                }
                                FloatDCT_3D.this.dctSlices.forward(FloatDCT_3D.this.t, n5, bl);
                                FloatDCT_3D.this.dctSlices.forward(FloatDCT_3D.this.t, n5 + FloatDCT_3D.this.slices, bl);
                                for (n7 = 0; n7 < FloatDCT_3D.this.slices; ++n7) {
                                    fArray[n7][i][0] = FloatDCT_3D.this.t[n5 + n7];
                                    fArray[n7][i][1] = FloatDCT_3D.this.t[n5 + FloatDCT_3D.this.slices + n7];
                                }
                            }
                            break block19;
                        }
                        if (FloatDCT_3D.this.columns > 2) {
                            for (int i = n4; i < FloatDCT_3D.this.rows; i += n2) {
                                for (int j = 0; j < FloatDCT_3D.this.columns; j += 4) {
                                    int n8;
                                    int n3;
                                    for (n3 = 0; n3 < FloatDCT_3D.this.slices; ++n3) {
                                        n8 = n5 + FloatDCT_3D.this.slices + n3;
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[n5 + n3] = fArray[n3][i][j];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[n8] = fArray[n3][i][j + 1];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[n8 + ((FloatDCT_3D)FloatDCT_3D.this).slices] = fArray[n3][i][j + 2];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[n8 + 2 * ((FloatDCT_3D)FloatDCT_3D.this).slices] = fArray[n3][i][j + 3];
                                    }
                                    FloatDCT_3D.this.dctSlices.inverse(FloatDCT_3D.this.t, n5, bl);
                                    FloatDCT_3D.this.dctSlices.inverse(FloatDCT_3D.this.t, n5 + FloatDCT_3D.this.slices, bl);
                                    FloatDCT_3D.this.dctSlices.inverse(FloatDCT_3D.this.t, n5 + 2 * FloatDCT_3D.this.slices, bl);
                                    FloatDCT_3D.this.dctSlices.inverse(FloatDCT_3D.this.t, n5 + 3 * FloatDCT_3D.this.slices, bl);
                                    for (n3 = 0; n3 < FloatDCT_3D.this.slices; ++n3) {
                                        n8 = n5 + FloatDCT_3D.this.slices + n3;
                                        fArray[n3][i][j] = FloatDCT_3D.this.t[n5 + n3];
                                        fArray[n3][i][j + 1] = FloatDCT_3D.this.t[n8];
                                        fArray[n3][i][j + 2] = FloatDCT_3D.this.t[n8 + FloatDCT_3D.this.slices];
                                        fArray[n3][i][j + 3] = FloatDCT_3D.this.t[n8 + 2 * FloatDCT_3D.this.slices];
                                    }
                                }
                            }
                        } else if (FloatDCT_3D.this.columns == 2) {
                            for (int i = n4; i < FloatDCT_3D.this.rows; i += n2) {
                                int n9;
                                for (n9 = 0; n9 < FloatDCT_3D.this.slices; ++n9) {
                                    ((FloatDCT_3D)FloatDCT_3D.this).t[n5 + n9] = fArray[n9][i][0];
                                    ((FloatDCT_3D)FloatDCT_3D.this).t[n5 + ((FloatDCT_3D)FloatDCT_3D.this).slices + n9] = fArray[n9][i][1];
                                }
                                FloatDCT_3D.this.dctSlices.inverse(FloatDCT_3D.this.t, n5, bl);
                                FloatDCT_3D.this.dctSlices.inverse(FloatDCT_3D.this.t, n5 + FloatDCT_3D.this.slices, bl);
                                for (n9 = 0; n9 < FloatDCT_3D.this.slices; ++n9) {
                                    fArray[n9][i][0] = FloatDCT_3D.this.t[n5 + n9];
                                    fArray[n9][i][1] = FloatDCT_3D.this.t[n5 + FloatDCT_3D.this.slices + n9];
                                }
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }
}

