/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.ngs;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.Interval;
import edu.unc.genomics.io.IntervalFile;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ReadLengthDistributionMatrix
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(ReadLengthDistributionMatrix.class);
    @Parameter(names={"-i", "--input"}, description="Input file (reads)", required=true)
    public IntervalFile<? extends Interval> intervalFile;
    @Parameter(names={"-c", "--chr"}, description="Chromosome", required=true)
    public String chr;
    @Parameter(names={"-s", "--start"}, description="Start base pair", required=true)
    public int start;
    @Parameter(names={"-e", "--stop"}, description="Stop base pair", required=true)
    public int stop;
    @Parameter(names={"-m", "--min"}, description="Minimum fragment length bin (bp)")
    public int min = 1;
    @Parameter(names={"-l", "--max"}, description="Maximum fragment length bin (bp)")
    public int max = 200;
    @Parameter(names={"-b", "--bin"}, description="Bin size (bp)")
    public int binSize = 1;
    @Parameter(names={"-o", "--output"}, description="Output file (tabular)", required=true)
    public Path outputFile;

    @Override
    public void run() throws IOException {
        int regionLength = this.stop - this.start + 1;
        int lengthRange = this.max - this.min + 1;
        int histLength = lengthRange / this.binSize;
        if (histLength * this.binSize != lengthRange) {
            ++histLength;
        }
        log.debug((Object)"Binning reads by genomic location and length");
        int[][] counts = new int[histLength][regionLength];
        Iterator reads = this.intervalFile.query(this.chr, this.start, this.stop);
        int skipped = 0;
        while (reads.hasNext()) {
            Interval read = (Interval)reads.next();
            if (read.length() < this.min || read.length() > this.max) {
                ++skipped;
                continue;
            }
            int bin = (read.length() - this.min) / this.binSize;
            int intersectStart = Math.max(read.getStart(), this.start);
            int intersectStop = Math.min(read.getStop(), this.stop);
            for (int i = intersectStart; i <= intersectStop; ++i) {
                int[] nArray = counts[bin];
                int n = i - this.start;
                nArray[n] = nArray[n] + 1;
            }
        }
        log.info((Object)("Skipped " + skipped + " reads with length outside range"));
        try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            writer.write(this.chr);
            for (int bp = this.start; bp <= this.stop; ++bp) {
                writer.write("\t" + bp);
            }
            for (int i = histLength - 1; i >= 0; --i) {
                writer.newLine();
                writer.write(String.valueOf(this.min + i * this.binSize));
                for (int j = 0; j < regionLength; ++j) {
                    writer.write("\t" + counts[i][j]);
                }
            }
        }
        this.intervalFile.close();
    }

    public static void main(String[] args) {
        new ReadLengthDistributionMatrix().instanceMain(args);
    }
}

