/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.nucleosomes;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class DynaPro
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(DynaPro.class);
    @Parameter(names={"-i", "--input"}, description="Energy landscape", required=true)
    public WigFile inputFile;
    @Parameter(names={"-n", "--size"}, description="Nucleosome size (bp)")
    public int nucleosomeSize = 147;
    @Parameter(names={"-m", "--mean"}, description="Shift energy landscape to have mean")
    public Double newMean;
    @Parameter(names={"-v", "--variance"}, description="Scale energy landscape to variance")
    public Double newVar;
    @Parameter(names={"-o", "--output"}, description="Output file (Wig)", required=true)
    public Path outputFile;
    Float shift;
    Float scale;

    @Override
    public void run() throws IOException {
        if (this.newMean != null) {
            log.debug((Object)("Shifting mean of energy landscape from " + this.inputFile.mean() + " to " + this.newMean));
            this.shift = Float.valueOf((float)(this.newMean - this.inputFile.mean()));
        }
        if (this.newVar != null) {
            log.debug((Object)("Rescaling variance of energy landscape from " + Math.pow(this.inputFile.stdev(), 2.0) + " to " + this.newVar));
            this.scale = Float.valueOf((float)Math.sqrt(this.newVar / Math.pow(this.inputFile.stdev(), 2.0)));
        }
        try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            writer.write("track type=wiggle_0");
            writer.newLine();
            for (String chr : this.inputFile.chromosomes()) {
                int i;
                int i2;
                log.debug((Object)("Processing chromosome " + chr));
                int start = this.inputFile.getChrStart(chr);
                int stop = this.inputFile.getChrStop(chr);
                Iterator data = null;
                try {
                    data = this.inputFile.query(chr, start, stop);
                }
                catch (WigFileException e) {
                    log.fatal((Object)("Error querying Wig file for data from chromosome " + chr));
                    e.printStackTrace();
                    throw new CommandLineToolException("Error querying Wig file for data from chromosome " + chr);
                }
                float[] energy = WigFile.flattenData((Iterator)data, (int)start, (int)stop, (float)0.0f);
                if (this.shift != null) {
                    i2 = 0;
                    while (i2 < energy.length) {
                        int n = i2++;
                        energy[n] = energy[n] + this.shift.floatValue();
                    }
                }
                if (this.scale != null) {
                    i2 = 0;
                    while (i2 < energy.length) {
                        int n = i2++;
                        energy[n] = energy[n] * this.scale.floatValue();
                    }
                }
                float[] forward = new float[energy.length];
                for (int i3 = this.nucleosomeSize; i3 < energy.length; ++i3) {
                    double factor = 1.0 + Math.exp(forward[i3 - this.nucleosomeSize] - forward[i3 - 1] - energy[i3 - this.nucleosomeSize]);
                    forward[i3] = (float)((double)forward[i3 - 1] + Math.log(factor));
                }
                float[] backward = new float[energy.length];
                for (int i4 = energy.length - this.nucleosomeSize - 1; i4 > 0; --i4) {
                    double factor = 1.0 + Math.exp(backward[i4 + this.nucleosomeSize] - backward[i4 + 1] - energy[i4 - 1]);
                    backward[i4] = (float)((double)backward[i4 + 1] + Math.log(factor));
                }
                float[] p = new float[energy.length];
                for (i = 0; i < energy.length - this.nucleosomeSize; ++i) {
                    p[i] = (float)Math.exp(forward[i] - energy[i] + backward[i + this.nucleosomeSize] - backward[1]);
                }
                writer.write("fixedStep chrom=" + chr + " start=" + start + " step=1 span=1");
                writer.newLine();
                for (i = 0; i < p.length; ++i) {
                    writer.write(Float.toString(p[i]));
                    writer.newLine();
                }
            }
        }
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new DynaPro().instanceMain(args);
    }
}

