/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.analysis;

import java.io.File;
import net.sf.picard.PicardException;
import net.sf.picard.analysis.SinglePassSamProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.io.IoUtil;
import net.sf.picard.metrics.MetricsFile;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.picard.util.Histogram;
import net.sf.picard.util.Log;
import net.sf.picard.util.RExecutor;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.SequenceUtil;

public class QualityScoreDistribution
extends SinglePassSamProgram {
    @Option(shortName="CHART", doc="A file (with .pdf extension) to write the chart to")
    public File CHART_OUTPUT;
    @Option(doc="If set to true calculate mean quality over aligned reads only")
    public boolean ALIGNED_READS_ONLY = false;
    @Option(shortName="PF", doc="If set to true calculate mean quality over PF reads only")
    public boolean PF_READS_ONLY = false;
    @Option(doc="If set to true, include quality for no-call bases in the distribution")
    public boolean INCLUDE_NO_CALLS = false;
    private final long[] qCounts = new long[128];
    private final long[] oqCounts = new long[128];
    private final Log log = Log.getInstance(QualityScoreDistribution.class);

    public static void main(String[] args) {
        System.exit(new QualityScoreDistribution().instanceMain(args));
    }

    @Override
    protected void setup(SAMFileHeader header, File samFile) {
        IoUtil.assertFileIsWritable(this.OUTPUT);
        IoUtil.assertFileIsWritable(this.CHART_OUTPUT);
    }

    @Override
    protected void acceptRead(SAMRecord rec, ReferenceSequence ref) {
        if (this.PF_READS_ONLY && rec.getReadFailsVendorQualityCheckFlag()) {
            return;
        }
        if (this.ALIGNED_READS_ONLY && rec.getReadUnmappedFlag()) {
            return;
        }
        if (rec.getNotPrimaryAlignmentFlag()) {
            return;
        }
        byte[] bases = rec.getReadBases();
        byte[] quals = rec.getBaseQualities();
        byte[] oq = rec.getOriginalBaseQualities();
        int length = quals.length;
        for (int i = 0; i < length; ++i) {
            if (!this.INCLUDE_NO_CALLS && SequenceUtil.isNoCall((byte)bases[i])) continue;
            byte by = quals[i];
            this.qCounts[by] = this.qCounts[by] + 1L;
            if (oq == null) continue;
            byte by2 = oq[i];
            this.oqCounts[by2] = this.oqCounts[by2] + 1L;
        }
    }

    @Override
    protected void finish() {
        Histogram<Byte> qHisto = new Histogram<Byte>("QUALITY", "COUNT_OF_Q");
        Histogram<Byte> oqHisto = new Histogram<Byte>("QUALITY", "COUNT_OF_OQ");
        for (int i = 0; i < this.qCounts.length; ++i) {
            if (this.qCounts[i] > 0L) {
                qHisto.increment((byte)i, this.qCounts[i]);
            }
            if (this.oqCounts[i] <= 0L) continue;
            oqHisto.increment((byte)i, this.oqCounts[i]);
        }
        MetricsFile metrics = this.getMetricsFile();
        metrics.addHistogram(qHisto);
        if (!oqHisto.isEmpty()) {
            metrics.addHistogram(oqHisto);
        }
        metrics.write(this.OUTPUT);
        if (qHisto.isEmpty() && oqHisto.isEmpty()) {
            this.log.warn("No valid bases found in input file. No plot will be produced.");
        } else {
            int rResult = RExecutor.executeFromClasspath("net/sf/picard/analysis/qualityScoreDistribution.R", this.OUTPUT.getAbsolutePath(), this.CHART_OUTPUT.getAbsolutePath(), this.INPUT.getName());
            if (rResult != 0) {
                throw new PicardException("R script qualityScoreDistribution.R failed with return code " + rResult);
            }
        }
    }
}

