/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import edu.unc.genomics.ContigException;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ValuedInterval;
import java.util.Arrays;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.commons.math3.util.ArithmeticUtils;

public class Contig
extends Interval {
    private static final long serialVersionUID = -4260411310249231783L;
    private float[] values;
    private SummaryStatistics stats;
    private int span = 1;

    public Contig(Interval interval) {
        this(interval, null);
    }

    public Contig(Interval interval, float[] values) throws ContigException {
        this(interval.getChr(), interval.getStart(), interval.getStop(), values);
    }

    public Contig(Interval interval, float[] values, int span) throws ContigException {
        this(interval.getChr(), interval.getStart(), interval.getStop(), values, span);
    }

    public Contig(String chr, int start, int stop, float[] values) throws ContigException {
        this(chr, start, stop, values, 1);
    }

    public Contig(String chr, int start, int stop, float[] values, int span) throws ContigException {
        super(chr, start, stop);
        this.span = span;
        if (values == null) {
            values = new float[this.actualNumberOfValues()];
            Arrays.fill(values, Float.NaN);
        } else if (values.length != this.actualNumberOfValues()) {
            throw new ContigException("Incorrect number of values for Contig (" + values.length + " != " + this.actualNumberOfValues() + ")");
        }
        this.values = values;
    }

    public Contig(String chr, int start, int stop) {
        this(chr, start, stop, (float[])null);
    }

    public Contig copy(Interval i) {
        if (!i.getChr().equals(this.getChr())) {
            return null;
        }
        return this.copy(i.getStart(), i.getStop());
    }

    public Contig copy(int start, int stop) {
        return new Contig(this.getChr(), start, stop, this.get(start, stop));
    }

    public int actualNumberOfValues() {
        return (int)Math.ceil((float)this.length() / (float)this.span);
    }

    public float[] getValues() {
        if (this.span == 1) {
            return this.values;
        }
        float[] expandedValues = new float[this.length()];
        for (int i = 0; i < this.length(); ++i) {
            expandedValues[i] = this.get(this.getStart() + i);
        }
        return expandedValues;
    }

    public float[] getCondensedValues() {
        return this.values;
    }

    public float[] get(Interval i) {
        if (!i.getChr().equals(this.getChr())) {
            return null;
        }
        return this.get(i.getStart(), i.getStop());
    }

    public float[] get(int start, int stop) {
        int length = Math.abs(stop - start) + 1;
        float[] result = new float[length];
        int dir = start <= stop ? 1 : -1;
        int bp = start;
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.get(bp + dir * i);
        }
        return result;
    }

    public float get(int bp) {
        if (!this.includes(bp)) {
            return Float.NaN;
        }
        int i = Math.abs(bp - this.getStart()) / this.span;
        return this.values[i];
    }

    public void set(ValuedInterval interval) throws ContigException {
        this.set(interval, interval.getValue().floatValue());
    }

    public void set(Interval interval, float value) throws ContigException {
        this.set(interval.getStart(), interval.getStop(), value);
    }

    public void set(int start, int stop, float value) throws ContigException {
        int low = Math.min(start, stop);
        int high = Math.max(start, stop);
        for (int bp = low; bp <= high; ++bp) {
            this.set(bp, value);
        }
    }

    public void set(int bp, float value) throws ContigException {
        if (!this.includes(bp)) {
            throw new ContigException(bp + " is outside the range of this Contig");
        }
        this.values[(bp - this.low()) / this.span] = value;
        if (this.stats != null) {
            this.stats = null;
        }
    }

    public SummaryStatistics getStats() {
        if (this.stats == null) {
            this.computeStats();
        }
        return this.stats;
    }

    private void computeStats() {
        this.stats = new SummaryStatistics();
        for (float v : this.values) {
            if (Float.isNaN(v) || Float.isInfinite(v)) continue;
            for (int i = 0; i < this.span; ++i) {
                this.stats.addValue((double)v);
            }
        }
    }

    public long coverage() {
        return this.numBases();
    }

    public long numBases() {
        return this.getStats().getN();
    }

    public float total() {
        return (float)this.getStats().getSum();
    }

    public float mean() {
        return (float)this.getStats().getMean();
    }

    public float stdev() {
        return (float)Math.sqrt(this.getStats().getPopulationVariance());
    }

    public float min() {
        return (float)this.getStats().getMin();
    }

    public float max() {
        return (float)this.getStats().getMax();
    }

    public String getFixedStepHeader() {
        int actualSpan = Math.min(this.getMinSpan(), this.getMinStep());
        return Type.FIXEDSTEP.getId() + " chrom=" + this.getChr() + " start=" + this.getFirstBaseWithData() + " span=" + actualSpan + " step=" + this.getMinStep();
    }

    public String getVariableStepHeader() {
        return Type.VARIABLESTEP.getId() + " chrom=" + this.getChr() + " span=" + this.getVariableStepSpan();
    }

    public int getFirstBaseWithData() {
        for (int bp = this.low(); bp <= this.high(); ++bp) {
            if (Float.isNaN(this.get(bp))) continue;
            return bp;
        }
        return this.high();
    }

    public int getMinSpan() {
        int minSpan = this.length();
        int span = this.span;
        int firstbp = this.getFirstBaseWithData();
        float prevValue = this.get(firstbp);
        for (int bp = firstbp + 1; bp <= this.high(); bp += this.span) {
            float value = this.get(bp);
            if (value == prevValue) {
                ++span;
                continue;
            }
            if (!Float.isNaN(prevValue) && span < minSpan) {
                minSpan = span;
            }
            if (minSpan <= this.span) break;
            prevValue = value;
            span = this.span;
        }
        return minSpan;
    }

    public int getVariableStepSpan() {
        int minSpan = this.getMinSpan();
        int span = this.span;
        int firstbp = this.getFirstBaseWithData();
        float prevValue = this.get(firstbp);
        for (int bp = firstbp + 1; bp <= this.high(); bp += this.span) {
            float value = this.get(bp);
            if (value == prevValue) {
                ++span;
                continue;
            }
            if (!Float.isNaN(prevValue) && span % minSpan > 0) {
                minSpan = ArithmeticUtils.gcd((int)span, (int)minSpan);
            }
            if (minSpan <= this.span) break;
            prevValue = value;
            span = this.span;
        }
        return minSpan;
    }

    public int getMinStep() {
        if (!this.isFixedStep()) {
            return this.span;
        }
        return this.getFirstStep();
    }

    private int getFirstStep() {
        int bp;
        int firstbp = this.getFirstBaseWithData();
        float firstValue = this.get(firstbp);
        boolean passedNaN = false;
        for (bp = firstbp + 1; bp <= this.high(); bp += this.span) {
            float nextValue = this.get(bp);
            if (Float.isNaN(nextValue)) {
                passedNaN = true;
                continue;
            }
            if (nextValue != firstValue || passedNaN) break;
        }
        return bp - firstbp;
    }

    public boolean isFixedStep() {
        int bp;
        int prevbp = bp = this.getFirstBaseWithData();
        float prevValue = this.get(prevbp);
        int firstStep = this.getFirstStep();
        while (bp < this.high()) {
            boolean passedNaN = false;
            for (bp = prevbp + 1; bp <= this.high(); ++bp) {
                float nextValue = this.get(bp);
                if (Float.isNaN(nextValue)) {
                    passedNaN = true;
                    continue;
                }
                if (nextValue != prevValue || passedNaN) break;
            }
            if (bp > this.high()) break;
            int step = bp - prevbp;
            if (step % firstStep > 0) {
                return false;
            }
            prevbp = bp;
            prevValue = this.get(bp);
        }
        return true;
    }

    public void setSpan(int span) {
        int n = (int)Math.ceil((float)this.length() / (float)span);
        float[] spanValues = new float[n];
        int i = 0;
        int stop = this.high();
        for (int bp = this.low(); bp <= stop; bp += span) {
            double total = 0.0;
            for (int j = 0; j < Math.min(span, stop - bp); ++j) {
                total += (double)this.get(bp + j);
            }
            spanValues[i] = (float)(total / (double)span);
            ++i;
        }
        this.values = spanValues;
        this.span = span;
    }

    public static enum Type {
        FIXEDSTEP("fixedStep"),
        VARIABLESTEP("variableStep");

        private final String id;

        private Type(String id) {
            this.id = id;
        }

        public static Type forId(String id) {
            for (Type c : Type.values()) {
                if (!c.getId().equals(id)) continue;
                return c;
            }
            return null;
        }

        public String getId() {
            return this.id;
        }

        public String toString() {
            return this.getId();
        }
    }
}

