/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.function;

import org.apache.commons.math3.analysis.DifferentiableUnivariateFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.util.FastMath;

public class Log10
implements DifferentiableUnivariateFunction {
    private static final double LN_10 = FastMath.log(10.0);

    public double value(double x) {
        return FastMath.log10(x);
    }

    public UnivariateFunction derivative() {
        return new UnivariateFunction(){

            public double value(double x) {
                return 1.0 / (x * LN_10);
            }
        };
    }
}

