/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.ngs;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.IntervalFileReader;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileReader;
import edu.unc.genomics.ngs.IntervalStats;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.log4j.Logger;

public class IntervalEntropy
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(IntervalStats.class);
    @Parameter(description="Input files", required=true)
    public List<String> inputFiles = new ArrayList<String>();
    @Parameter(names={"-l", "--loci"}, description="Loci file (Bed)", required=true, validateWith=ReadablePathValidator.class)
    public Path lociFile;
    @Parameter(names={"-w", "--window"}, description="Moving window size")
    public int window = 147;
    @Parameter(names={"-o", "--output"}, description="Output file", required=true)
    public Path outputFile;
    private List<WigFileReader> wigs = new ArrayList<WigFileReader>();

    @Override
    public void run() throws IOException {
        log.debug((Object)"Initializing input Wig file(s)");
        for (String inputFile : this.inputFiles) {
            this.wigs.add(WigFileReader.autodetect((Path)Paths.get(inputFile, new String[0])));
        }
        log.debug((Object)"Initializing output file");
        int count = 0;
        int skipped = 0;
        try (IntervalFileReader reader = IntervalFileReader.autodetect((Path)this.lociFile);
             BufferedWriter writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            writer.write("#Chr\tStart\tStop\tID\tAlignment\tStrand");
            for (String inputFile : this.inputFiles) {
                Path p = Paths.get(inputFile, new String[0]);
                writer.write("\t" + p.getFileName().toString());
            }
            writer.newLine();
            for (Interval interval : reader) {
                writer.write(interval.toBed());
                for (WigFileReader wig : this.wigs) {
                    try {
                        SummaryStatistics result = wig.queryStats(interval);
                        float value = Float.NaN;
                        writer.write("\t" + value);
                    }
                    catch (WigFileException e) {
                        writer.write("\tNaN");
                        ++skipped;
                    }
                }
                writer.newLine();
                ++count;
            }
        }
        for (WigFileReader wig : this.wigs) {
            wig.close();
        }
        log.info((Object)(count + " intervals processed"));
        log.info((Object)(skipped + " interval skipped"));
    }

    public static void main(String[] args) {
        new IntervalEntropy().instanceMain(args);
    }
}

