/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.visualization;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.BedEntry;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.BedFileReader;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class MatrixAligner
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(MatrixAligner.class);
    @Parameter(names={"-i", "--input"}, description="Input file (Wig)", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-l", "--loci"}, description="Loci file (Bed)", required=true, validateWith=ReadablePathValidator.class)
    public Path lociFile;
    @Parameter(names={"-m", "--max"}, description="Truncate width (base pairs)")
    public Integer maxWidth;
    @Parameter(names={"-o", "--output"}, description="Output file (matrix2png format)", required=true)
    public Path outputFile;
    private List<BedEntry> loci;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() throws IOException {
        MatrixAligner.log.debug((Object)"Loading alignment intervals");
        bed = new BedFileReader(this.lociFile);
        try {
            this.loci = bed.loadAll();
        }
        finally {
            bed.close();
        }
        leftMax = -2147483648;
        rightMax = -2147483648;
        for (BedEntry entry : this.loci) {
            if (entry.getValue() == null) {
                throw new CommandLineToolException("You must specify an alignment point for each interval in column 5");
            }
            left = Math.abs(entry.getValue().intValue() - entry.getStart());
            right = Math.abs(entry.getValue().intValue() - entry.getStop());
            if (left > leftMax) {
                leftMax = left;
            }
            if (right <= rightMax) continue;
            rightMax = right;
        }
        m = this.loci.size();
        n = leftMax + rightMax + 1;
        alignmentPoint = leftMax;
        MatrixAligner.log.info((Object)("Intervals aligned into: " + m + "x" + n + " matrix"));
        MatrixAligner.log.info((Object)("Alignment point: " + alignmentPoint));
        leftBound = 0;
        rightBound = n - 1;
        if (this.maxWidth != null && this.maxWidth < n) {
            MatrixAligner.log.info((Object)("Truncated to: " + m + "x" + this.maxWidth));
            leftAlignDistance = alignmentPoint;
            rightAlignDistance = n - alignmentPoint - 1;
            halfMax = this.maxWidth / 2;
            if (halfMax < leftAlignDistance && halfMax < rightAlignDistance) {
                leftBound = alignmentPoint - halfMax;
                rightBound = alignmentPoint + halfMax;
            } else if (leftAlignDistance <= rightAlignDistance) {
                rightBound = this.maxWidth;
            } else {
                leftBound = n - this.maxWidth;
            }
        }
        MatrixAligner.log.debug((Object)"Initializing output file");
        count = 0;
        skipped = 0;
        reader = WigFileReader.autodetect((Path)this.inputFile);
        try {
            writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);
            try {
                writer.write("ID");
                for (i = leftBound - alignmentPoint; i <= rightBound - alignmentPoint; ++i) {
                    writer.write("\t" + i);
                }
                writer.newLine();
                MatrixAligner.log.debug((Object)"Iterating over all intervals");
                row = new String[n];
                for (BedEntry entry : this.loci) {
                    ++count;
                    Arrays.fill(row, "-");
                    try {
                        data = reader.query((Interval)entry).getValues();
                        n1 = alignmentPoint - Math.abs(entry.getValue().intValue() - entry.getStart());
                        n2 = alignmentPoint + Math.abs(entry.getValue().intValue() - entry.getStop());
                        if (!MatrixAligner.$assertionsDisabled && data.length != n2 - n1 + 1) {
                            throw new AssertionError();
                        }
                        for (i = 0; i < data.length; ++i) {
                            if (Float.isNaN(data[i])) continue;
                            row[n1 + i] = String.valueOf(data[i]);
                        }
                        ** GOTO lbl86
                    }
                    catch (WigFileException e) {
                        try {
                            MatrixAligner.log.debug((Object)("Skipping interval " + entry + " which does not have data in the Wig file"));
                            ++skipped;
                        }
                        catch (Throwable var19_31) {
                            id = entry.getId() != null ? entry.getId() : "Row " + count;
                            writer.write(id);
                            i = leftBound;
                            while (true) {
                                if (i > rightBound) {
                                    writer.newLine();
                                    throw var19_31;
                                }
                                writer.write("\t" + (String)row[i]);
                                ++i;
                            }
                        }
lbl86:
                        // 1 sources

                        id = entry.getId() != null ? entry.getId() : "Row " + count;
                        writer.write(id);
                        for (i = leftBound; i <= rightBound; ++i) {
                            writer.write("\t" + (String)row[i]);
                        }
                        writer.newLine();
                        continue;
                        id = entry.getId() != null ? entry.getId() : "Row " + count;
                        writer.write(id);
                        for (i = leftBound; i <= rightBound; ++i) {
                            writer.write("\t" + (String)row[i]);
                        }
                        writer.newLine();
                    }
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        MatrixAligner.log.debug((Object)(count + " intervals processed"));
        MatrixAligner.log.debug((Object)(skipped + " intervals skipped"));
    }

    public static void main(String[] args) {
        new MatrixAligner().instanceMain(args);
    }
}

