/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.Interval;
import edu.unc.genomics.WigMathTool;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.log4j.Logger;

public class StandardDeviation
extends WigMathTool {
    private static final Logger log = Logger.getLogger(StandardDeviation.class);
    @Parameter(description="Input files", required=true)
    public List<String> inputFiles = new ArrayList<String>();

    @Override
    public void setup() {
        if (this.inputFiles.size() < 2) {
            throw new CommandLineToolException("Cannot compute variance with < 2 files.");
        }
        log.debug((Object)"Initializing input files");
        for (String inputFile : this.inputFiles) {
            try {
                this.addInputFile(WigFileReader.autodetect((Path)Paths.get(inputFile, new String[0])));
            }
            catch (IOException e) {
                log.error((Object)("IOError initializing input Wig file: " + inputFile));
                e.printStackTrace();
                throw new CommandLineToolException(e.getMessage());
            }
        }
        log.debug((Object)("Initialized " + this.inputs.size() + " input files"));
    }

    @Override
    public float[] compute(Interval chunk) throws IOException, WigFileException {
        SummaryStatistics[] stats = new SummaryStatistics[chunk.length()];
        for (int i = 0; i < stats.length; ++i) {
            stats[i] = new SummaryStatistics();
        }
        for (WigFileReader wig : this.inputs) {
            float[] data = wig.query(chunk).getValues();
            for (int i = 0; i < data.length; ++i) {
                if (Float.isNaN(data[i])) continue;
                stats[i].addValue((double)data[i]);
            }
        }
        float[] result = new float[chunk.length()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (float)stats[i].getStandardDeviation();
        }
        return result;
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new StandardDeviation().instanceMain(args);
    }
}

