import Image
import ImageFilter
import ImageChops
import os
import sys

def isodd(num):
	return num & 1 and True or False

def main():
	numArgs = len(sys.argv)

	if numArgs < 2:
		print "USAGE: provide input, output, functions, parameters"
		exit(1)

	listOfValues = sys.argv[1:]

	try:
		imageIn = Image.open(listOfValues[0])
	except IOError:
		print "cannot open: ", listOfValues[0]

	if listOfValues[2] == "median":
		size = int(listOfValues[3]);
		# prevent size to be even
		if size & 1 == False:
			size = size + 1
		imageMedian = imageIn.filter(ImageFilter.MedianFilter(size))
		imageOut = imageMedian.save(listOfValues[1], listOfValues[4])
		# imageMedian.show()
		print "Applied a median filter of the given size."
	elif listOfValues[2] == "emboss":
		imageEmboss = imageIn.filter(ImageFilter.EMBOSS)
		imageOut = imageEmboss.save(listOfValues[1], listOfValues[3])
		# imageEmboss.show()
		print "Applied an emboss filter on the image."
	elif listOfValues[2] == "blur":
		imageBlur = imageIn.filter(ImageFilter.BLUR)
		imageOut = imageBlur.save(listOfValues[1], listOfValues[3])
		# imageBlur.show()
		print "Applied a blur filter on the image."
	elif listOfValues[2] == "contour":
		imageContour = imageIn.filter(ImageFilter.CONTOUR)
		imageOut = imageContour.save(listOfValues[1], listOfValues[3])
		# imageContour.show()
		print "Applied a contour filter on the image."
	elif listOfValues[2] == "detail":
		imageDetail = imageIn.filter(ImageFilter.DETAIL)
		imageOut = imageDetail.save(listOfValues[1], listOfValues[3])
		# imageDetail.show()
		print "Applied a detial filter on the image."
	elif listOfValues[2] == "edge_enhance":
		imageEdgeEnhance = imageIn.filter(ImageFilter.EDGE_ENHANCE)
		imageOut = imageEdgeEnhance.save(listOfValues[1], listOfValues[3])
		# imageEdgeEnhance.show()
		print "Applied an edge enhance filter on the image."
	elif listOfValues[2] == "edge_enhance_more":
		imageEdgeEnhanceMore = imageIn.filter(ImageFilter.EDGE_ENHANCE_MORE)
		imageOut = imageEdgeEnhanceMore.save(listOfValues[1], listOfValues[3])
		# imageEdgeEnhanceMore.show()
		print "Applied an eddge enhance more filter on the image."
	elif listOfValues[2] == "find_edges":
		imageFindEdges = imageIn.filter(ImageFilter.FIND_EDGES)
		imageOut = imageFindEdges.save(listOfValues[1], listOfValues[3])
		# imageFindEdges.show()
		print "Applied a find_edges filter on the image."		
	elif listOfValues[2] == "sharpen":
		imageSharpen = imageIn.filter(ImageFilter.SHARPEN)
		imageOut = imageSharpen.save(listOfValues[1], listOfValues[3])
		# imageSharpen.show()
		print "Applied a sharpen filter on the image."
	elif listOfValues[2] == "smooth":
		imageSmooth = imageIn.filter(ImageFilter.SMOOTH)
		imageOut = imageSmooth.save(listOfValues[1], listOfValues[3])
		# imageSmooth.show()
		print "Applied a smooth filter on the image."
	elif listOfValues[2] == "smooth_more":
		imageSmoothMore = imageIn.filter(ImageFilter.SMOOTH_MORE)
		imageOut = imageSmoothMore.save(listOfValues[1], listOfValues[3])
		# imageSmoothMore.show()
		print "Applied a smooth_more filter on the image."
	elif listOfValues[2] == "min":
		size = int(listOfValues[3])
		# prevent size to be even
		if size & 1 == False:
			size = size + 1		
		imageMin = imageIn.filter(ImageFilter.MinFilter(size))
		imageOut = imageMin.save(listOfValues[1], listOfValues[4])
		# imageMin.show()
		print "Applied a min filter of the given size on the image"
	elif listOfValues[2] == "max":
		size = int(listOfValues[3])
		# prevent size to be even
		if size & 1 == False:
			size = size + 1		
		imageMax = imageIn.filter(ImageFilter.MaxFilter(size))
		imageOut = imageMax.save(listOfValues[1], listOfValues[4])
		# imageMax.show()
		print "Applied a max filter of the given size on the image"
	elif listOfValues[2] == "mode":
		size = int(listOfValues[3])
		# prevent size to be even
		if size & 1 == False:
			size = size + 1		
		imageMode = imageIn.filter(ImageFilter.ModeFilter(size))
		imageOut = imageMode.save(listOfValues[1], listOfValues[4])
		# imageMode.show()
		print "Applied a mode filter of the given size on the image"
	elif listOfValues[2] == "invert":
		imageInvert = ImageChops.invert(imageIn)
		imageOut = imageInvert.save(listOfValues[1], listOfValues[3])
		# imageInvert.show()
		print "Inverted the image."

if __name__ == "__main__": 
	main()