import os
import optparse

from PIL import Image
from PIL import ImageDraw
from image_transforms import tileify
from image_transforms import calculate_random_location
from image_transforms import filmify_image


def main():
	
	# Parse options
	parser = optparse.OptionParser()
	parser.add_option(
		"-i",
		dest="inputImage",
		help="Input Image",
		metavar="FILE"
	)
	parser.add_option(
		"-o",
		dest="outputImage",
		help="Output Image",
		metavar="FILE"
	)
	parser.add_option(
		"--command",
		"-c",
		dest="imageCommand",
		help="Command",
		metavar="string"
	)
	parser.add_option(
		"-s",
		dest='custom_string',
		help='String to be placed as decription'
	)
	parser.add_option(
		"-e",
		dest='image_ext',
		help='Image extension'
	)
	(opts, args) = parser.parse_args()

	mandatory_options = ['inputImage', 'outputImage', 'image_ext']
	for option in mandatory_options:
		if not opts.__dict__[option]:
			print "One or more options are missing\n"
			parser.print_help()
			exit(-1)

	inputImage_fn = opts.inputImage
	outputImage_fn =opts.outputImage
	input_extension = opts.image_ext
	if input_extension == "jpg":
		input_extension="jpeg"

	listOfValues = opts.imageCommand.split()

	try:
		imageIn = Image.open(inputImage_fn)
	except IOError:
		print "Cannot open file: " + inputImage_fn

	if listOfValues[0] == "filmify":
		"""
		Transform image into a signed movie frame.
		Use: 
		python image_do.py -i input.jpg -o output.jpg -c "filmify" -s "hello world" -e "jpg"
		"""
		print "command: " + listOfValues[0]
		new_image_data = filmify_image(imageIn)
		add_text_header(new_image_data, text=opts.custom_string)
		new_image_data.save(outputImage_fn, input_extension);
		# new_image_data.show();
	elif listOfValues[0] == "tileify":
		"""
		Breaks image up into rectangles and shifts them a random distance.
		Parameters: number of tiles, max shift
		Use: 
		python image_do.py -i input.jpg -o output.jpg -c "tileify num_tiles max_shift" -e "jpg"
		"""
		print "command: " + listOfValues[0]
		num_tiles = int(listOfValues[1])
		max_shift = int(listOfValues[2])
		new_image_data = tileify(imageIn, num_tiles, max_shift)
		new_image_data.save(outputImage_fn, input_extension);
		# new_image_data.show();
	elif listOfValues[0] == "rotate":
		"""
		Rotates an image the given number of degrees counter clockwise around its centre.
		Parameters: deg, 1 - expand the image or 0 - leave same size, filter
		Use:
		python image_do.py -i input.jpg -o output.jpg -c "rotate 45 1" -e "jpg"
		"""
		print "command: " + listOfValues[0]
		new_image_data = imageIn.rotate(int(listOfValues[1]), expand=int(listOfValues[2]))
		new_image_data.save(outputImage_fn, input_extension);
		# new_image_data.show(new_image_data)
	elif listOfValues[0] == "resize":
		"""
		Resizes the image.
		Parameters: width, height, filter: 0 = NEAREST, 1 = ANTIALIAS, 2 = BILINEAR, 3 = BICUBIC
		Use:
		python image_do.py -i sydney.jpg -o o.jpg -c "resize 140 140 0"
		"""
		print "command: " + listOfValues[0]
		size = int(listOfValues[1]), int(listOfValues[2]) 
		filterr = int(listOfValues[3])
		new_image_data = imageIn.resize(size, filterr)
		new_image_data.save(outputImage_fn, input_extension);
		# new_image_data.show()
		
	elif listOfValues[0] == "crop":
		# bbox 
		# returns a copy of a rectangular region from the current image. The box is a 4-tuple defining the left, upper, right, and lower pixel coordinate.
		# example: python image_do.py -i sydney.jpg -o sydney_out.jpg -c "crop 0 0 10 10"
		print "command: " + listOfValues[0]
		new_image_data = imageIn.crop((int(listOfValues[1]), int(listOfValues[2]), int(listOfValues[3]), int(listOfValues[4])))
		new_image_data.save(outputImage_fn);
		# new_image_data.show(new_image_data)


def add_text_header(image_data, text='cloudimaging.net.au'):
	"""
	Add text to the top of the document
	Inputs
		image_data - image to have text added
		text - string to add
	"""
	# TODO add string wrapping for long strings
	# TODO figure this out programatically
	text_location = (300, 1)
	# This is white
	fill_color = 255
	# This happens if -s wasn't set
	if text == None:
		text = 'cloudimaging.net.au'
	draw = ImageDraw.Draw(image_data)
	draw.text(text_location, text, fill=fill_color)


if __name__ == "__main__":
	main()

