/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.util.CollectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakeClassesMutuallyDisjoint
extends AbstractCompositeOntologyChange {
    private Set<? extends OWLClassExpression> classExpressions;
    private boolean usePairwiseDisjointAxioms;
    private OWLOntology targetOntology;
    private List<OWLOntologyChange> changes;

    public MakeClassesMutuallyDisjoint(OWLDataFactory dataFactory, Set<? extends OWLClassExpression> classExpressions, boolean usePairwiseDisjointAxioms, OWLOntology targetOntology) {
        super(dataFactory);
        this.classExpressions = classExpressions;
        this.usePairwiseDisjointAxioms = usePairwiseDisjointAxioms;
        this.targetOntology = targetOntology;
        this.generateChanges();
    }

    private void generateChanges() {
        this.changes = new ArrayList<OWLOntologyChange>();
        if (this.usePairwiseDisjointAxioms) {
            ArrayList<? extends OWLClassExpression> descList = new ArrayList<OWLClassExpression>(this.classExpressions);
            for (int i = 0; i < descList.size(); ++i) {
                for (int j = i + 1; j < descList.size(); ++j) {
                    this.changes.add(new AddAxiom(this.targetOntology, this.getDataFactory().getOWLDisjointClassesAxiom(CollectionFactory.createSet((OWLClassExpression)descList.get(i), (OWLClassExpression)descList.get(j)))));
                }
            }
        } else {
            this.changes.add(new AddAxiom(this.targetOntology, this.getDataFactory().getOWLDisjointClassesAxiom(this.classExpressions)));
        }
    }

    @Override
    public List<OWLOntologyChange> getChanges() {
        return this.changes;
    }
}

