'''
@author  Rui Wang
@see     LICENSE (MIT style license file).
'''

import sys, os, imp
#import buildin types
from types import *
import os
import sys 
import warnings

__author__="Rui Wang"

galaxyhome=os.environ.get('GALAXY_HOME')
sys.path.append(galaxyhome+'/tools/WebServiceToolWorkflow_REST_SOAP/clientGenerator/')
os.chdir(galaxyhome+'/tools/WebServiceToolWorkflow_REST_SOAP/clientGenerator/')
class Introspector:
    '''introspect module, 
    to import module,
    to find classes in the module,
    '''
    #os.chdir('/home/tuxdistro/galaxy_dist/webservice')
    def path2Module(self, modulePath):
        '''given modulePath=package.module, return module object'''
      
        #dynamic import module, e.g.'ebiDbfetch.WSDBFetchServerLegacyService_services'
        path=modulePath
        #print 'ModulePath:',path
        #path='/home/tuxdistro/galaxy_dist/webservice/'+modulePath
        #print os.getcwd()
        #print dir()
        print 'the path is : ',path    #added
        moduRoot=__import__(path)
        components = path.split('.')
        modu=getattr(moduRoot,components[-1])
        #list all object in the module file
#        allOB=dir(modu)
#        print "all objects in module: "
#        print allOB
#        print dir(moduRoot)
#        print moduRoot
        return modu

    
    def path2Class(self, modulePath):
        '''given module path, return dict of all class name:object'''
        modu=self.path2Module(modulePath)
#        print 'module====', modu
#        modu=self.loadModule(modulePath)
        #list all object in the service file
        allOB=dir(modu)
#        print allOB
        #find classes  type(obtemp)==ClassType 
        allclass={}
        for ob in allOB:
            obtemp=getattr(modu, ob)
            #print obtemp, "----", type(obtemp).__name__
            if type(obtemp) is ClassType:
                allclass[obtemp.__name__]=obtemp
    
        return allclass
        
    def loadModule(self, name):
        """
        Load a module given by name.
        name -- The fully qualified name of a module
        """
        modNames = name.split('.');
        module = None;
#        currDir = [self.baseDir];
        idx = sys.argv[0].rindex(os.path.sep);
        path = str(sys.argv[0])[0:idx]
        currDir = [path];
        
        name = None;
        for mod in modNames:
            if name :
                name += '.' + mod;
            else :
                name = mod;
            fp, path, desc = imp.find_module(mod, currDir);
            try :
                #define the module
                module = self.__lm(name, fp, path, desc);
                
                #If the attr doesn't exist this is the last module to load
                if hasattr(module, '__path__') :
                    currDir = module.__path__;
            finally :
                if fp:
                    fp.close();
        return module;

    def __lm(self, name, openfp, path, descTuple):
        if descTuple[2] == imp.PKG_DIRECTORY :
            #define package
            package = imp.load_module(name, openfp, path, descTuple);
            #load the __init__ module to make changes
            initfp, initpath, initdesc = imp.find_module('__init__', [path]);
            try :
                imp.load_module(name + ".__init__", initfp, initpath, initdesc);
            finally :
                if initfp :
                    initfp.close();
            #return the package
            return package;            
        else :
            return imp.load_module(name, openfp, path, descTuple);
        
        
        
#testing this module
if __name__=="__main__":
    test=Introspector()
    print test.path2Module('blast.WSWUBlast_server')
#    print test.loadModule('blast.WSWUBlast_client')
#    test.path2Module('wublastTest')
    
    
