'''
@author  Rui Wnag, Chaitanya Guttula
@see     LICENSE (MIT style license file).
'''

'''
converter galaxy parameter <-----> user input dictionary for web service
'|' is the seperator, if the real name contains it, it will cause wrong result in this converter
'''
from types import *
#from galaxy.tools.parameters.basic import *

__author__="Rui Wang"

def nested2flatDict(nestedDic):
    '''
    nestedDic is dictionary e.g.{a:{a1:None, a2:None}, b:None, c:[{c1:None, c2:None},{c1:None, c2:None}]}, 
    converter it into flatDict e.g.
    {a|a1:TextToolParameter(), a|a2:TextToolParameter(), b:TextToolParameter(), 
    c|1|c1:TextToolParameter(),c|1|c2:TextToolParameter(), c|2|c1:TextToolParameter(),c|2|c2:TextToolParameter()}
    seperator is |, not /
    '''
    if nestedDic is None or len(nestedDic) == 0:
        return {};
    flatDic={}
    
    for key, value in nestedDic.iteritems():
        if type(value) is DictType:
            dicRecur(key, value, flatDic);
        elif type(value) is ListType:
            listRecur(key, value, flatDic);
        elif value is None:
            flatDic[key]=None#TextToolParameter(None, XML( '<param name="' + str(key) + '" type="text" size="10" value="default" />' ) )
        else:
            flatDic[key]=str(value)
    return flatDic

def dicRecur(prefix, dic, flatDic):
    '''
    '''
    if dic is None or len(dic) == 0:
        raise ValueError, 'dic is empty'
    i=0;
    for key, value in dic.items():
        if type(value) is DictType:
            #print key
            dicRecur(prefix+"|"+key, value, flatDic);
        elif type(value) is ListType:
            listRecur(prefix+"|"+key, value, flatDic);
        elif value is None:
            #print 'key',key
            #if (key.find('$')>-1):
            #    vlist = key.split('$')
            #    key = ''.join(vlist)
            
                #print 'key',key
           #     flatDic[prefix+"|_"+str(i)+"|"+key]=None
            #    i=i+1
            #else:
            flatDic[prefix+"|"+key]=None#TextToolParameter(None, XML( '<param name="' + str(prefix) + '|' + str(key) + '" type="text" size="10" value="default" />' ) )
        else:
            #print prefix
            #if (key.find('$')>-1):
            #    vlist = key.split('$')
            #    key = ''.join(vlist)
            
            #    print 'key',key
            #    flatDic[prefix+"|_"+str(i)+"|"+key]=None
            #    i=i+1
            #else:
                flatDic[prefix+"|"+key]=str(value)
            
def listRecur(prefix, list, flatDic):
    ''''''
    
    #You are expecting this list to contain a complexType.
    #When it doesn't you raise a ValueError.
    #If the list contains a simpletype then we add |$|
    # when flatenning.
    if list is None or len(list)==0:
        flatDic[prefix+'|$|'] = [];
        return [];
    i=0
    for value in list:
        if type(value) is DictType:
            #print prefix
            dicRecur(prefix+"|"+str(i), value, flatDic);
        #else:#if type(value) is ListType:
         #   if prefix+'|0|' not in flatDic:
        #        flatDic[prefix+'|0|'] = []
        #    flatDic[prefix+'|0|'].append(value)
        #    return ;
            i += 1;

def flat2nestedDict(flatDic):
    '''the flatDic has value in it
    converter it to nested dictionary'''
    if flatDic is None or flatDic=={}: 
        raise ValueError, 'flatDic is empty'
    nestedDic = {};
    for key, value in flatDic.iteritems() :
        key_arr = key.split('|');
        print key_arr
        last_idx = len(key_arr) - 1;
        sub_dic = nestedDic;
        if last_idx != 0 :
            i = 0;
            # Iterates over the split values of a single key
            while i < last_idx :
                
                try :
                    key_int = int(key_arr[i]); # checking if the split value of key is number (true only if it )
                    if key_int >= len(sub_dic) :
                        for j in range(key_int - len(sub_dic) + 1) :
                            sub_dic.append({});
                    sub_dic = sub_dic[key_int];
                 
                except ValueError :
 
                    #If the split value is not present in thhe subdic
                    if key_arr[i] == '$':
                      print '$ is there'#,nestedDic  
                    else:
                      if key_arr[i] not in sub_dic :
                        try :
                            key_int = int(key_arr[i + 1]); # Ckecking of the next split value in key is number
                            
                            # Executed if the key is or array type key
                            sub_list = [];
                            sub_dic[key_arr[i]] = sub_list;                            
                            for j in range(key_int + 1) :
                                sub_list.append({});
                            sub_dic = sub_list[key_int];
                            i += 1;
                            
                        except ValueError : # 2 consicutive split values in key are not numerical value (i.e not array)
                            if key_arr[last_idx-1] == '$' :
                                if i == last_idx-2 :
                                    print 'Found the value',key_arr[i]
                                else:
                                    temp = {};
                                    sub_dic[key_arr[i]] = temp;
                                    sub_dic = temp;
                                    
                            else:   
                                temp = {};
                                sub_dic[key_arr[i]] = temp;
                                sub_dic = temp;
                                    
                    # If the split value is present in the subdir then create a new subdic with
                      else :  
                        sub_dic = nestedDic[key_arr[i]];
                        
                i += 1;
        if value == '' :
            value = None;
        if key_arr[last_idx-1] == '$':
            templist=[];
            if value != []: 
                if value.find(',')>-1:
                    vlist = value.split(',')
                    for l in vlist:
                        templist.append(l);
                else:
                    templist.append(value);
            sub_dic[key_arr[last_idx-2]] = templist;
        else:
            sub_dic[key_arr[last_idx]] = value;
            
        # If the leaf node is basic array type
        #if key_arr[last_idx] == '':
        #    sub_dic[key_arr[last_idx-2]].append(value);
        #else:
        #    sub_dic[key_arr[last_idx]] = value;            
        
    return nestedDic
            
#testing this module only, before run below test, please comment line 6,30,33,50,53, and uncomment line 29,32,49,52, since they will use other modules of galaxy
if __name__=="__main__":

#    nestedDic={'_params':{ '_program' : 'blastp', '_database' :'swissprot', '_email' :'riververy@yahoo.com', '_async': 1}, '_content':[{'_type':'sequence', '_content':'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa'},{'_type':'ss', '_content':'bbbbbbbbbbbbbbbb'}]}
    nestedDic={'_params':{ '_program' : 'blastp', '_database' :{'_string':[]}, '_email' :'riververy@yahoo.com', '_async': '', '_test':[{'_name':'chaithu'},{'_name':'srinivas'}]}, '_content':[{'_type':'sequence', '_content':'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa'},{'_type':'ss', '_content':'bbbbbbbbbbbbbbbb'}]}
    #flatdic = nested2flatDict(nestedDic)
    #print flatdic
    flatDic={'_parameters|_program': 'blastp', '_parameters|_stype': 'protein', '_parameters|_sequence': 'MKLSKRYRFWQKVIKALGVLALIATLVLVVYLYKLGILNDSNELKDLVHKYEFWGPMIFIVAQIVQIVFPVIPGGVTTVAGFLIFGPTLGFIYNYIGIIIGSVILFWLVKFYGRKFVLLF', '_email': 'chaitanya.g86@gmail.com', '_parameters|_database|_string|$|': 'uniprotkb,swissprot'}
#{'_params|_email': 'riververy@yahoo.com', '_params|_database': 'swissprot', '_params|_async': '1', '_content|0|_type': 'sequence', '_content|1|_type': 'ss','_params|_program|0|': 'hrllo', '_content|1|_content':'bbbbbbbbbbbbbbbb', '_content|0|_content': 'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa'}
    print flat2nestedDict(flatDic)
            
            
            
            
            
            
            
            
            
            
            
