'''
@author  Rui Wang
@see     LICENSE (MIT style license file).
'''

import os
import sys;
from ZSI.generate.commands import wsdl2py

__author__="Rui Wang"

class wsdlLoader:
    '''all methods to load wsdl from file/url'''
    
    def wsdlUrl2path(self, url, folderName):
        '''given wsdl url, folder name
        create a folder under current directory,
        invoke wsdl2py
        return the path of generated python file by wsdl2py'''
        
        path=os.path.join(os.getcwd(), folderName)
        if not os.path.isdir(path):
            os.mkdir(path)            
            
        fileOb=open(os.path.join(path,'__init__.py'), 'a')
        fileOb.close()
        wsdl2py([url, '-o', path])  #zsi 2.1
        #wsdl2py(['-u',url, '-o', path]) #zsi 2.0
        
        #get path required by creatorEngine.py, such as: blast.WSWUBlast_services, WSWUBlast_client
        pyFileList=os.listdir(path)
        for f in pyFileList:
            if f.endswith('_client.py'):  #zsi2.1
            #if f.endswith('_services.py'):  #zsi2.0
                importPath=folderName+'.'+f[:-3] 
                break
                
        return importPath
        
    def wsdlFile2path(self, filePath, folderName):
        '''given wsdl file path, folder name
        create a folder under current directory,
        invoke wsdl2py
        return the path of generated python file by wsdl2py'''
        path=os.path.join(os.getcwd(), folderName)
        if not os.path.isdir(path):
            os.mkdir(path)
        else:
            print 'Warning: writing files into an already existed path!!!!'
            
        fileOb=open(os.path.join(path,'__init__.py'), 'a')
        fileOb.close()
        wsdl2py([filePath, '-o', path])
#        wsdl2py(['-f',filePath, '-o', path])
        
        #get path required by creatorengine.py, such as: blast.WSWUBlast_services
        pyFileList=os.listdir(path)
        for f in pyFileList:
            #if f.endswith('_client.py'):  #zsi2.1
            if f.endswith('_services.py'):   #zsi 2.0
                importPath=folderName+'.'+f[:-3]   # f[:-3] will take off the .py extention
                break
                
        return importPath

#testing this module
if __name__=="__main__":
    test=wsdlLoader()
    test.wsdlUrl2path('http://www.ebi.ac.uk/Tools/webservices/wsdl/WSWUBlast.wsdl','blast')
    #print test.wsdlFile2path('..\\wsdl\\WSWUBlast.wsdl', 'blast')
#    print test.wsdlFile2path('..\\wsdl\\picr.wsdl', 'picr')

#    print test.wsdlFile2path('..\\wsdl\\WSDbfetch.wsdl', 'dbfetch')

#    print test.wsdlFile2path('..\\wsdl\\NewGeneByLocation.wsdl', 'gbLocation')

    
#'http://www.ebi.ac.uk/Tools/webservices/wsdl/WSWUBlast.wsdl'
#'-u http://www.ebi.ac.uk/Tools/webservices/wsdl/WSDbfetch.wsdl' 
#-o OUTPUT_DIR
#-b add convenience functions for complexTypes, including Getters, Setters, factory methods, and properties (via metaclass). *** DONT USE WITH --simple-naming
