package javax.wadls;

import java.util.List;

/**
 * This interface marks a WADL param being allowed to have a
 * <code>javax.wadls.ModelReference</code> for SAWADL.
 * 
 * @author Douglas Brewer
 */
public interface ModelReferenceExtensible {

	/**
	 * Add a single ModelReference to the Element.
	 * 
	 * @param modelReference The ModelReference.
	 */
	public void addModelReference(ModelReference modelReference);
	
	/**
	 * Get the first ModelReference in the list of ModelReferences.
	 * 
	 * @return The first ModelReference.
	 */
	public ModelReference getModelReference();
	
	/**
	 * Get all the ModelReferences of the Element.
	 * 
	 * @return A list of ModelReferences.
	 */
	public List<ModelReference> getModelReferences();
	
	/**
	 * Set the ModelReferences of this Element.
	 * 
	 * @param refs The ModelReferences for this Element.
	 */
	public void setModelReferences(List<ModelReference> refs);
}
