/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import org.coode.owlapi.rdfxml.parser.AbstractObjectRestrictionTranslator;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public abstract class AbstractObjectCardinalityTranslator
extends AbstractObjectRestrictionTranslator {
    public AbstractObjectCardinalityTranslator(OWLRDFConsumer consumer) {
        super(consumer);
    }

    protected abstract IRI getCardinalityTriplePredicate();

    protected abstract IRI getQualifiedCardinalityTriplePredicate();

    private int translateCardinality(IRI mainNode) {
        OWLLiteral con = this.getLiteralObject(mainNode, this.getCardinalityTriplePredicate(), true);
        if (con == null) {
            con = this.getLiteralObject(mainNode, this.getQualifiedCardinalityTriplePredicate(), true);
        }
        if (con == null) {
            return -1;
        }
        return Integer.parseInt(con.getLiteral().trim());
    }

    private OWLClassExpression translateFiller(IRI mainNode) {
        IRI onClassObject = this.getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_CLASS.getIRI(), true);
        if (onClassObject == null) {
            return this.getDataFactory().getOWLThing();
        }
        return this.translateToClassExpression(onClassObject);
    }

    protected OWLClassExpression translateRestriction(IRI mainNode) {
        OWLObjectPropertyExpression prop = this.translateOnProperty(mainNode);
        if (prop == null) {
            return this.getConsumer().getOWLClass(mainNode);
        }
        int cardi = this.translateCardinality(mainNode);
        OWLClassExpression filler = this.translateFiller(mainNode);
        return this.createRestriction(prop, cardi, filler);
    }

    protected abstract OWLClassExpression createRestriction(OWLObjectPropertyExpression var1, int var2, OWLClassExpression var3);
}

