/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import java.util.HashSet;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.coode.owlapi.rdfxml.parser.TriplePredicateHandler;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class TPEquivalentClassHandler
extends TriplePredicateHandler {
    public TPEquivalentClassHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.OWL_EQUIVALENT_CLASS.getIRI());
    }

    public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
        boolean named = this.getConsumer().isClass(subject) && !this.isSubjectOrObjectAnonymous(subject, object);
        return named || this.getConsumer().getClassExpressionIfTranslated(subject) != null && this.getConsumer().getClassExpressionIfTranslated(object) != null;
    }

    public void handleTriple(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
        if (this.getConsumer().isDataRange(object) || this.getConsumer().isDataRange(subject)) {
            OWLDatatype datatype = this.getDataFactory().getOWLDatatype(subject);
            OWLDataRange dataRange = this.getConsumer().translateDataRange(object);
            this.addAxiom(this.getDataFactory().getOWLDatatypeDefinitionAxiom(datatype, dataRange, this.getPendingAnnotations()));
        } else {
            HashSet<OWLClassExpression> operands = new HashSet<OWLClassExpression>();
            operands.add(this.translateClassExpression(subject));
            operands.add(this.translateClassExpression(object));
            this.addAxiom(this.getDataFactory().getOWLEquivalentClassesAxiom(operands, this.getPendingAnnotations()));
        }
        this.consumeTriple(subject, predicate, object);
    }
}

