'''
@author  Chaitanya Guttula, Sumedha Ganjoo
@see     LICENSE (MIT style license file).
'''

import warnings

with warnings.catch_warnings():
    warnings.simplefilter("ignore")
    import platform

    from jpype._jpackage import JPackage
    from jpype import *
    import os.path
    import sys
    import string
    from edit_tool_conf1 import *
    from clientGenerator.msHandler import *
    from clientGenerator.creatorEngineComplex import *
    from clientGenerator.wsdl2path import *
    from clientGenerator.paramConverter import *

__author__=""

#generates client for a web service to be used as standalone
class ClientGenerator1(object):
    
    def __init__(self,webservice,operation,outputfile,servicetype):#,url):
      with warnings.catch_warnings():
        warnings.simplefilter("ignore")
        self.webservice = webservice
        self.operation = operation
        self.inputs = outputfile
        self.outputfile = outputfile
        #self.url = url
        
        self.servicetype = servicetype
        self.galaxyhome=os.environ.get('GALAXY_HOME')
        self.clientfile = ''
        if self.servicetype == 'SOAP':
            wLoad=wsdlLoader()
            sys.path.append(self.galaxyhome+'/tools/WebServiceToolWorkflow_REST_SOAP/clientGenerator')
            os.chdir(self.galaxyhome+'/tools/WebServiceToolWorkflow_REST_SOAP/clientGenerator')
        
            a = str(self.webservice).split('/')
            wsdlnamelist = a[len(a)-1].split(".")
            if len(wsdlnamelist)==1:
        	    wsdlnamelist=a[len(a)-1].split('?')
        	    print wsdlnamelist

            foldername=wsdlnamelist[0]
        
            path =self.galaxyhome+'/tools/WebServiceToolWorkflow_REST_SOAP/clientGenerator/'+foldername
        
    #creates the client stubs
            self.clientfile = wLoad.wsdlUrl2path(str(self.webservice),foldername)
        
            print 'Client file : ',self.clientfile
            self.paramelement = None
        
        
        
    ''' Replaces space (' ') with '**' in the given string  '''
    def formatString(self,string):
        l = string.split(' ')
        return '**'.join(l)
        
    def isRequired(self,param):
        #j=0
        #for param in inputl:
        cc = ClientCreator()
        self.msinstance = cc.opname2inputClassOb(self.operation,self.clientfile)
        test = MessageHandler()
        required = False
        if (param.find('|$|')>-1):
            plist = param.split('|')
            #root = test.getParameter(self.msinstance(),plist[0])
            k = 0
            iparam = ''
            for p in plist:
                if(k<len(plist)-3):
                    if(k==0):
                        iparam = iparam+(p)
                    else:
                        iparam = iparam+'|'+p
                    k=k+1
            paramelement = test.getParameter(self.msinstance(),iparam)
        else:
            paramelement = test.getParameter(self.msinstance(),param)
        self.paramelement = paramelement
        if (param.find('|')>-1):   
            plist = param.split('|')   
            root = test.getParameter(self.msinstance(),plist[0])    
            if not getattr(root,'nillable') and not getattr(paramelement,'nillable'):
                required = True
                return True
            elif getattr(root,'nillable') or (not getattr(root,'nillable') and getattr(paramelement,'nillable')): 
                required = False
                return False
        else:     
            if not getattr(paramelement,'nillable'):     
                required = True
                return True
            elif getattr(paramelement,'nillable'):
                required = False
                return False
        return required
    
    
    #replace '**' with ' '
    def formatString(self,string):
        l = string.split(' ')
        return '**'.join(l)

    '''
    Checks if the tool(operation) is already addded to Galaxy. It opens the tool_conf.xml file and loops through the "Web Service Workflow Tools" sections
    Then opens each and every tool (xml file) and looks for the description tag for the "Web Service" and "Client for Method" values and then checks
    if it same as the opearation and web service. As the code is dependent on description of the toool xml fie, any change in the description
    of the tool xml file can impact this function.
    '''
    def isToolPresent(self):
        
        f = open(self.galaxyhome+'/tool_conf.xml','r')
        line = f.readline()
        linestripped = line.lstrip()
        linestripped = linestripped.rstrip()
        
        while linestripped != '<section name="Select Web Service Tool" id="WebServices">':
            line = f.readline()
            linestripped = line.lstrip()
            linestripped = linestripped.rstrip()
            
        line = f.readline()
        linestripped = line.lstrip()
        linestripped = linestripped.rstrip()
                
        while linestripped != '</section>':
            if linestripped.find('<') >-1:
                toolparts = linestripped.split('"')
                print '\ntoolparts are : ',toolparts
                f1 = open(self.galaxyhome+'/tools/'+toolparts[-2],'r')
                line1 = f1.readline()
                while not line1.find('<description>') >-1:
                    line1 = f1.readline() 
                
                linestripped1 = line1.lstrip()
                linestripped1 = linestripped1.rstrip()
                descriptionparts=linestripped1.split(' ')
                print '\nOperation : ',descriptionparts
                service = ''
                if(self.servicetype == 'SOAP'):
                    service = self.clientfile
                elif self.servicetype == 'REST':
                    service = self.webservice
                if(descriptionparts[5]==self.operation and descriptionparts[10] == service):
                    f.close()
                    f1.close()
                    return True
                f1.close()
            line = f.readline()
            linestripped = line.lstrip()
            linestripped = linestripped.rstrip()
            
        f.close()
        return False
    
        
    '''
    Creates a client file2 (xml file) for the given opertion in the SOAP web service 
    This operation is invokes standalone and is cannot be used in workflows
    Then invokes another operation which adds this client file (tool) to the toolconfig.xml
    under 'Web Service Tools'
    
    '''    
    
    def wsdlClient(self):
      with warnings.catch_warnings():
        warnings.simplefilter("ignore")
        wLoad=wsdlLoader()
        galaxyhome=os.environ.get('GALAXY_HOME')
        sys.path.append(galaxyhome+'/tools/WebServiceToolWorkflow_REST_SOAP/clientGenerator')
        os.chdir(galaxyhome+'/tools/WebServiceToolWorkflow_REST_SOAP/clientGenerator')
        
        a= str(self.webservice).split('/')
        wsdlnamelist = a[len(a)-1].split(".")
        if len(wsdlnamelist)==1:
    	    wsdlnamelist=a[len(a)-1].split('?')
    	    print wsdlnamelist

        foldername=wsdlnamelist[0]
        
        path =galaxyhome+'/tools/WebServiceToolWorkflow_REST_SOAP/clientGenerator/'+foldername
        
    #creates the client stubs
        clientfile=wLoad.wsdlUrl2path(str(self.webservice),foldername)
        
        webservice = clientfile#sys.argv[4]
        #operation = sys.argv[3]
        outputfile=open(self.outputfile,'w')
        test = ClientCreator()
        inputs= test.opname2inputs(self.operation,webservice)
        inputl = nested2flatDict(inputs)
        inputlist = inputl.keys()
        #noOfInputs=inputlist.count()
        count =0
        if (len(inputs)==0):
            inputs={' ':' '}
            #inputlist=inputs.keys()
        for i in inputlist:
            if count==0:
                outputfile.write(i+'\t'+webservice+'\t'+self.operation+'\n')
            else:
                outputfile.write(i+'\n')
            count=count+1


        cc = ClientCreator()
        self.msinstance = cc.opname2inputClassOb(self.operation,webservice)
        
        ##generate client's xml
        galaxyhome=os.environ.get('GALAXY_HOME')
        
        #./clients/ClientCount.xml keeps the count of the clients/tools currently registered in Galaxy for Web service invocation.
        #read the count and increment it. 
        
        clientCountFile=open(galaxyhome+'/tools/WebServiceToolWorkflow_REST_SOAP/clients/ClientCount.xml','r')
        clientCountFile.readline()
        clientCountStr = clientCountFile.readline()
        clientCount=string.atoi(clientCountStr)
        clientCount=clientCount+1
        clientCountFile.close()
        
        clientCountFile=open(galaxyhome+'/tools/WebServiceToolWorkflow_REST_SOAP/clients/ClientCount.xml','w')
        clientCountFile.write('<count> \n')
        clientCountFile.write(str(clientCount)+'\n')
        clientCountFile.write('</count> \n')
        clientCountFile.close() 
        
        clientName = 'WebServiceclient_'+ str(clientCount)
        
        clientXml=open(galaxyhome+'/tools/WebServiceToolWorkflow_REST_SOAP/clients/'+clientName+'.xml','w')
        clientXml.seek(0,0)
        
        clientXml.write('<tool id="' + clientName+'" name="'+foldername+'.' + self.operation +'">\n')
        clientXml.write('  <description> Client for operation : '+self.operation+' , Web service : '+webservice+' </description>\n')

        #Only Required parameters
        clientXml.write('  <command interpreter="python">\n #if $cond_source.optional_param_source=="no" #client_1.py'+' $output $servicetype ' +webservice+'  '+self.operation)
        
        #clientXml.write('  <command interpreter="python">\n  client_1.py \n' +'  $output \n  ' +self.webservice+' \n  '+self.operation+'\n')
        ##write such that the parameters passed to client1.py(change name to clientName.py) are dependent on a for loop
        test = MessageHandler()
        j=0
        for param in inputl:
            if self.isRequired(param):     
                    clientXml.write('	"'+param+'"')           
                    clientXml.write(' $param'+str(j))     
                    j=j+1        
             
                
        #Both Required and optional paramters        
        clientXml.write(' #else #client_1.py'+' $output $servicetype ' +webservice+'    '+self.operation+'\n')
        
        ''' 
         Required parameters - If the parameter is complex type (tree structure) then the the parameter is required
         only if both the root node and the leaf node are required (i.e. both root and leaf have attribute nillable as false) 
        '''      
        
        j=0
        for param in inputl:
            if self.isRequired(param):     
                    clientXml.write('	"'+param+'"')           
                    clientXml.write(' $param'+str(j))     
                    j=j+1        
            
        
        ''' 
         Optional parameters - If the parameter is complex type (tree structure) then the the paramter is optional
         if its root element is optional (i.e. root has attribute nillable as true) even if the leaf node (element) 
         is required (i.e. leaf element has attribute nillable as false)
        '''      
        for param in inputl:
            if not self.isRequired(param):     
                    clientXml.write('	"'+param+'"')            
                    clientXml.write(' $param'+str(j))    
                    j=j+1        
                
        
#params for array type 
#        for param in self.inputs:
 #           paramelement = test.getParameter(self.msinstance(),param)
  #          if getattr(paramelement,'nillable')==True:
   #             if string.find(param,"|0|")>-1:
    #                ele = string(param,"|0|")
     #               for param in self.inputs:
                        
                
      #          clientXml.write(' "'+param+'"')
       #         clientXml.write(' $cond_source.param' + str(j))            
        #        j=j+1
        
        clientXml.write(' #end if \n</command>\n')
        
        
#        for param in self.inputs:
 #           paramelement = test.getParameter(self.msinstance(),param)
  #          if getattr(paramelement,'nillable')==False or getattr(paramelement,'minOccurs')==1:
   #             clientXml.write('  "'+param+'"\n')            
    #            clientXml.write('  $param'+str(j)+'\n')            
     #           j=j+1
                
     
        #clientXml.write('</command>\n')
        
        #start writing inputs
	    ##write inputs depending on required or not. if not required den dont display 
        ##if required- den check default value, and if options exist.Depending on that
        ##decide the type of parameter and options
        ##The input servicetype tells what type of webservice it is wether SOAP or REST - Useful during invocation of the web servcie   
        clientXml.write('  <inputs>\n') 
        clientXml.write('    <param name="servicetype" type="hidden" value="SOAP" />\n')
        
                
        j=0
        for param in inputl:
            if self.isRequired(param):     
                    pName = getattr(self.paramelement,'pname')
                    clientXml.write('<param format="text" size = "150" name = "param'+str(j)+'"  ')      
                    clientXml.write('type="text" label="Enter '+pName+'" help="see tip below" />\n')   
                    j=j+1
                            
        clientXml.write('\n <conditional name="cond_source"> \n <param name="optional_param_source" type="select" label="Show Optional Parameters">\n <option value="no" selected="true">no</option> \n <option value="yes">yes</option> \n </param>\n')
        clientXml.write('<when value="no"> \n </when>')
        clientXml.write('<when value="yes"> \n')
        
        for param in inputl:
            if not self.isRequired(param):     
                    pName = getattr(self.paramelement,'pname')
                    clientXml.write('<param format="text" size = "150" name = "param'+str(j)+'"  ')    
                    clientXml.write('type="text" label="Enter '+pName+'" help="see tip below" />\n')   
                    j=j+1        
            
           
        clientXml.write('</when>\n</conditional>')
       
#        j=0
 #       for param in self.inputs:                       
  #          paramelement = test.getParameter(self.msinstance(),param)
   #         if not getattr(paramelement,'nillable'):
    #            pName = getattr(paramelement,'pname')#param.getName()
     #           clientXml.write('<param format="text" size = "150" name = "param'+str(j)+'"  ')
      #          clientXml.write('type="text" label="'+pName+'" help="see tip below" />\n')
       #         j=j+1
       
        clientXml.write('</inputs>\n  <outputs>\n    <data format="tabular" name="output" />\n  </outputs>\n')
        
        clientXml.write('  <help>\n')
        paramtype = None
        for param in inputl:
            if self.isRequired(param):     
                    if isinstance(self.paramelement,ZSI.TC.String):
                        paramtype = 'String'
                    elif isinstance(self.paramelement,ZSI.TCnumbers.FPfloat):
                        paramtype = 'Floating point'
                    elif isinstance(self.paramelement,ZSI.TC.Boolean):
                            paramtype = 'Boolean'
                    elif isinstance(self.paramelement,ZSI.TCnumbers.Iint):
                            paramtype = 'Integer'
                    clientXml.write('\n.. class:: infomark\n\n**TIP:** About '+ getattr(self.paramelement,'pname') +': type is ' + paramtype + '\n')       

            
            
                
        clientXml.write('  </help>\n</tool>')
                
#        clientXml.write('  <help>\n')
        
 #       j=0
  #      for param in params:
   #         clientXml.write('\n.. class:: infomark\n\n**TIP:** '+ param +' type is ' + paramTypes[j] +'\n')       
        
    #    clientXml.write('  </help>\n</tool>')
       # clientXml.write('</tool>')
        clientXml.close()
        editor = editToolConfig1()
        editor.addTool(clientName)
        
        ##later add help feature
            
        
    def wadlClient(self):
        ##parse wadl 
        pkg=JPackage('lsdis')
        urlToPass=java.net.URL(self.webservice)
        wadlUrl = self.webservice
    
        webserviceId = ''#self.operation
        resUrl = self.operation
    
        urls = []
        methods = []
        params = []
        docs = []

        WADLParserDriver=pkg.WADLParserDriver
        wPD=WADLParserDriver()
        wPD.parse(urlToPass)
        urls = wPD.getUrl()
        methods = wPD.getCompleteMethodList()

        #write into the output file information about the method and Web service to be invoked.        
        f=open(self.outputfile,'w')
        f.write(self.webservice)
        f.write('\n'+ resUrl)
        
        a= str(self.webservice).split('/')
        wadlnamelist = a[len(a)-1].split(".")
        if len(wadlnamelist)==1:
    	    wadlnamelist=a[len(a)-1].split('?')
    	    print wadlnamelist

        wadlname=wadlnamelist[0]
        

        #get parameters for the selected method of the Web service
        i=0
        for method in methods:
            x = str(method.getId())
            y = str(urls.get(i))
            webserviceId = x
            #if x==webserviceId:
            if y == resUrl : 
                params = method.getRequest().getParams()
                break
            i=i+1    
     
        f.write('\n'+webserviceId)
        galaxyhome=os.environ.get('GALAXY_HOME')
        
        methodname = resUrl.split('/')
        
        #./clients/ClientCount.xml keeps the count of the clients/tools currently registered in Galaxy for Web service invocation.
        #read the count and increment it. 
        clientCountFile=open(galaxyhome+'/tools/WebServiceToolWorkflow_REST_SOAP/clients/ClientCount.xml','r')
        clientCountFile.readline()
        clientCountStr = clientCountFile.readline()
        clientCount=string.atoi(clientCountStr)
        clientCount=clientCount+1
        clientCountFile.close()
        
        clientCountFile=open(galaxyhome+'/tools/WebServiceToolWorkflow_REST_SOAP/clients/ClientCount.xml','w')

        clientCountFile.write('<count> \n')
        clientCountFile.write(str(clientCount)+'\n')
        clientCountFile.write('</count> \n')
	
        #include the count in the tool's name and id to uniquely identify it.         
        clientName = 'WebServiceclient_'+ str(clientCount)

        #create a new xml file under ./clients/        
        clientXml=open(galaxyhome+'/tools/WebServiceToolWorkflow_REST_SOAP/clients/'+clientName+'.xml','w')
        clientXml.seek(0,0)

        #write the tool id, name and description        
        clientXml.write('<tool id="' + clientName+'1" name="'+wadlname+'.' + methodname[-1] +'      ">\n')
        clientXml.write('  <description> Client for method : '+self.operation+' , Web service : '+self.webservice+' </description>\n')

        #the one-time invocation tool/client for a REST Web service invokes ./clients/client_1.py to invoke the Web service
        #write the command tag to specify the arguments passed to this client_1.py
        clientXml.write('  <command interpreter="python">\n #if $cond_source.optional_param_source=="no" #client_1.py'+' $output $servicetype ' +resUrl)
               
        j=0
        
        for param in params:
            if param.isRequired():
                clientXml.write(' '+self.formatString(param.getName()))
                clientXml.write(' $param' + str(j))            
                j=j+1
        clientXml.write(' #else #client_1.py'+' $output $servicetype ' +resUrl)
        j=0
        for param in params:
            if param.isRequired():
                clientXml.write(' '+self.formatString(param.getName()))
                clientXml.write(' $param' + str(j))            
                j=j+1
                
        for param in params:
            if not param.isRequired():
                clientXml.write(' '+self.formatString(param.getName()))
                clientXml.write(' $cond_source.param' + str(j))            
                j=j+1
        clientXml.write(' #end if \n</command>\n')
        
	#start writing inputs
	##write inputs depending on required or not. if not required den dont display 
    ##if required- den check default value, and if options exist.Depending on that
    ##decide the type of parameter and options
    ##The input servicetype tells what type of webservice it is wether SOAP or REST - Useful during invocation of the web servcie   
        clientXml.write('  <inputs>\n') 
        clientXml.write('    <param name="servicetype" type="hidden" value="REST" />')
        
        #create a param for each required parameter described in the WADL. Check if defaults and options are specified in the WADL
        j=0
        for param in params:
            if param.isRequired():
                pName = param.getName()
                for doc in param.getDocs():
                    if doc.getTitle()=="prompt" or doc.getTitle()=="Prompt" or doc.getTitle()=="PROMPT": 
		        pName = doc.getInnerText()
                if param.getOptions().size()==0:
                    clientXml.write('<param format="text" size = "150" name = "param'+str(j)+'"  ')
                    if not param.getDefault1() == None:
                        clientXml.write('value="'+param.getDefault1()+'"  ')
                    clientXml.write('type="text" label="Enter '+pName+'" help="see tip below" />\n')
                    j=j+1
                else:
                    clientXml.write('<param name="param'+str(j)+'" type="select" label="Select '+pName+'" help="see tip below">\n' )    
                    for option in param.getOptions():
                        clientXml.write(' <option value="'+self.formatString(option.getName())+'" ')
                        if option.getName() == param.getDefault1():
                            clientXml.write('selected="true"')
                        clientXml.write('>'+option.getName()+'</option>\n ')    
                    clientXml.write('    </param> \n')
                    j=j+1

        #create a conditional param for each optional parameter described in the WADL.                     
        clientXml.write('\n <conditional name="cond_source"> \n <param name="optional_param_source" type="select" label="Show Optional Parameters">\n <option value="no" selected="true">no</option> \n <option value="yes">yes</option> \n </param>\n')
        clientXml.write('<when value="no"> \n </when>')
        clientXml.write('<when value="yes"> \n')
        for param in params:
            if not param.isRequired():
                pName = param.getName()
                for doc in param.getDocs():
                    if doc.getTitle()=="prompt" or doc.getTitle()=="Prompt" or doc.getTitle()=="PROMPT":
		        pName = doc.getInnerText()              
                if param.getOptions().size()==0:
                    clientXml.write('<param format="text" size = "150" name = "param'+str(j)+'"  ')
                    if not param.getDefault1() == None:
                        clientXml.write('value="'+param.getDefault1()+'"  ')
                    clientXml.write('type="text" label="Enter '+pName+'" help="see tip below" />\n')
                    j=j+1
                else:
                    clientXml.write('<param name="param'+str(j)+'" type="select" label="Select '+pName+'" help="see tip below">\n' )    
                    for option in param.getOptions():
                        clientXml.write(' <option value="'+self.formatString(option.getName())+'" ')
                        if option.getName() == param.getDefault1():
                            clientXml.write('selected="true"')
                        clientXml.write('>'+option.getName()+'</option>\n ')    
                    clientXml.write('    </param> \n')
                    j=j+1
        
                
        clientXml.write('</when>\n</conditional>')
        clientXml.write('</inputs>\n  <outputs>\n    <data format="tabular" name="output" />\n  </outputs>\n')

        #write information about each parameter in the help section        
        clientXml.write('  <help>\n')
        
        clientXml.write('Replace white space with ** in all parameter values\n')
                
        for param in params:
            if param.isRequired():
                pName = param.getName()
                for doc in param.getDocs():
                    if doc.getTitle()=="prompt" or doc.getTitle()=="Prompt" or doc.getTitle()=="PROMPT":
		        pName = doc.getInnerText()            
                clientXml.write('\n.. class:: infomark\n\n**TIP:** '+ pName +' type is ' + param.getType()+'\n')       
        
        clientXml.write('  </help>\n</tool>')
        
        
        #adds the newly created tool to tool_conf.xml in Galaxy under the 'Web Service Tools' section.        
        editor = editToolConfig1()
        editor.addTool(clientName)
        
        ##later add help feature
        
        
    def sawadlClient(self):
        ##parse sawadl 
        javahome = os.environ.get('JAVA_HOME')
        galaxyhome=os.environ.get('GALAXY_HOME')
        classpath= galaxyhome + '/tools/WebServiceToolWorkflow_REST_SOAP/lib/SAWADLParser/bin'
        jarpath = galaxyhome + '/tools/WebServiceToolWorkflow_REST_SOAP/lib/'
        machine = platform.machine()
    
        #if machine == 'x86_64' :
        #    print 'a'
        #    startJVM("%s/jre/lib/amd64/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        #elif machine == 'i686' :
        #    print 'b'
        #    startJVM("%s/jre/lib/i386/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        #elif machine == 'sun4u' :
        #    startJVM("%s/jre/lib/sparc/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        #else :
        #    print 'c'
        #    System.exit("Could not identify machine, please specify path to libjvm.so")

        
        pkg=JPackage('edu.uga.cs.lsdis.meteors.wadls')
        pkgModel =JPackage('org.semanticweb.owlapi.model')
        pkgApiBinding =JPackage('org.semanticweb.owlapi.apibinding')
        pkgVocab = JPackage('org.semanticweb.owlapi.vocab')
    
        DOCUMENT_IRI = "http://cs.uga.edu/~ganjoo/galaxy/EDAM.owl"
    
        sawadlUrl = self.webservice
    
        webserviceId = ''#self.methodName
        resUrl = self.operation
    
        urls = []
        methods = []
        params = []
        annotationSet = []

        SAWADLParserDriver=pkg.SAWADLParserDriver
        sawPD=SAWADLParserDriver()
        sawPD.parse(sawadlUrl)
        urls = sawPD.getUrl()
        methods = sawPD.getCompleteMethodList()

        IRI = pkgModel.IRI
        OWLRDFVocabulary = pkgVocab.OWLRDFVocabulary
        OWLManager = pkgApiBinding.OWLManager
        OWLLiteral = pkgModel.OWLLiteral
        owlOntManager = OWLManager.createOWLOntologyManager()
        ontology = owlOntManager.loadOntologyFromOntologyDocument(IRI.create(DOCUMENT_IRI))
        dataFactory = owlOntManager.getOWLDataFactory()
        propertyComment = dataFactory.getOWLAnnotationProperty(OWLRDFVocabulary.RDFS_COMMENT.getIRI())
        
        f=open(self.outputfile,'w')
        f.write(sawadlUrl)
        f.write(resUrl+'\t')
        

        i=0
        for method in methods:
            x = str(method.getName())
            y = str(urls.get(i))
            #if x == webserviceId :
            webserviceId = x
            if y == resUrl : 
                params = method.getRequest().getParamList()
                break
            i=i+1    
        
        f.write(webserviceId)
        
        
        ##generate client's xml
        galaxyhome=os.environ.get('GALAXY_HOME')
        
        #./clients/ClientCount.xml keeps the count of the clients/tools currently registered in Galaxy for Web service invocation.
        #read the count and increment it. 
        
        clientCountFile=open(galaxyhome+'/tools/WebServiceToolWorkflow_REST_SOAP/clients/ClientCount.xml','r')
        clientCountFile.readline()
        clientCountStr = clientCountFile.readline()
        clientCount=string.atoi(clientCountStr)
        clientCount=clientCount+1
        clientCountFile.close()
        
        clientCountFile=open(galaxyhome+'/tools/WebServiceToolWorkflow_REST_SOAP/clients/ClientCount.xml','w')
        clientCountFile.write('<count> \n')
        clientCountFile.write(str(clientCount)+'\n')
        clientCountFile.write('</count> \n')
	
        clientName = 'WebServiceclient_'+ str(clientCount)
        
        clientXml=open(galaxyhome+'/tools/WebServiceToolWorkflow_REST_SOAP/clients/'+clientName+'.xml','w')
        clientXml.seek(0,0)
        
        clientXml.write('<tool id="' + clientName+'1" name="' + webserviceId +'">\n')
        clientXml.write('  <description> Client for method: '+webserviceId+' , Web service: '+self.webservice+' </description>\n')

  
        clientXml.write('  <command interpreter="python">\n  #if $cond_source.optional_param_source=="no" #client_1.py'+' $output $servicetype ' +resUrl)
        ##write such that the parameters passed to client1.py(change name to clientName.py) are dependent on a for loop
               
        
        j=0
        for param in params:
            if param.getRequired()=='true' or param.getRequired()=='True' or param.getRequired()=='TRUE':
                clientXml.write('  '+self.formatString(param.getName())+'\n')
                clientXml.write('  $param' + str(j)+'\n')            
                j=j+1
        
        clientXml.write(' #else #client_1.py'+' $output $servicetype ' +resUrl)
        j=0
        for param in params:
            if param.getRequired()=='true' or param.getRequired()=='True' or param.getRequired()=='TRUE':
                clientXml.write(' '+self.formatString(param.getName()))
                clientXml.write(' $param' + str(j))            
                j=j+1
                
        for param in params:
            if not param.getRequired()=='true' and not param.getRequired()=='True' and not param.getRequired()=='TRUE':
                clientXml.write(' '+self.formatString(param.getName()))
                clientXml.write(' $cond_source.param' + str(j))            
                j=j+1               
                 
        clientXml.write('#end if \n </command>\n')
        
        #start writing inputs
	    ##write inputs depending on required or not. if not required den dont display 
        ##if required- den check default value, and if options exist.Depending on that
        ##decide the type of parameter and options
        ##The input param servicetype tells what type of webservice it is wether SOAP or REST - Useful during invocation of the web servcie   
        clientXml.write('  <inputs>\n') 
        cleintXml.write('    <param name="servicetype" type="hidden" value="REST"/>')
        
        j=0
        for param in params:
            if param.getRequired()=='true' or param.getRequired()=='True' or param.getRequired()=='TRUE':
                f.write('\n '+ param.getName() + ' options: '+str(param.getOptionvalue().size()))
                if param.getOptionvalue().size()==0:
                    clientXml.write('<param format="text" size = "150" name = "param'+str(j)+'"  ')
                    if not param.getDefault1() == None:
                        clientXml.write('value="'+param.getDefault1()+'"  ')
                    clientXml.write('type="text" label="Enter '+param.getName()+'" help="see tip below" />\n')
                    j=j+1
                else:
                    clientXml.write('<param name="param'+str(j)+'" type="select" label="Select '+param.getName()+'" help="see tip below">\n' )    
                    for option in param.getOptionvalue():
                        clientXml.write(' <option value="'+self.formatString(option)+'" ')
                        if option == param.getDefault1():
                            clientXml.write('selected="true"')
                        clientXml.write('>'+option+'</option>\n ')    
                    clientXml.write('    </param> \n')
                    j=j+1

                    
        clientXml.write('\n <conditional name="cond_source"> \n <param name="optional_param_source" type="select" label="Display Optional Parameters">\n <option value="no" selected="true">no</option> \n <option value="yes">yes</option> \n </param>\n')
        clientXml.write('<when value="no"> \n </when>')
        clientXml.write('<when value="yes"> \n')
        
        for param in params:
            if not param.getRequired()=='true' and not param.getRequired()=='True' and not param.getRequired()=='TRUE':
                f.write('\n '+ param.getName() + ' options: '+str(param.getOptionvalue().size()))
                if param.getOptionvalue().size()==0:
                    clientXml.write('<param format="text" size = "150" name = "param'+str(j)+'"  ')
                    if not param.getDefault1() == None:
                        clientXml.write('value="'+param.getDefault1()+'"  ')
                    clientXml.write('type="text" label="Enter '+param.getName()+'" help="see tip below" />\n')
                    j=j+1
                else:
                    clientXml.write('<param name="param'+str(j)+'" type="select" label="Select '+param.getName()+'" help="see tip below">\n' )    
                    for option in param.getOptionvalue():
                        clientXml.write(' <option value="'+self.formatString(option)+'" ')
                        if option == param.getDefault1():
                            clientXml.write('selected="true"')
                        clientXml.write('>'+option+'</option>\n ')    
                    clientXml.write('    </param> \n')
                    j=j+1
        
        clientXml.write('</when>\n</conditional>\n')        

        clientXml.write('</inputs>\n  <outputs>\n    <data format="tabular" name="output" />\n  </outputs>\n')
        
        clientXml.write('  <help>\n')
        for param in params:
            if param.getRequired()=='true' or param.getRequired()=='True' or param.getRequired()=='TRUE':
                clientXml.write('\n.. class:: infomark\n\n**TIP:** About '+ param.getName() +': type is ' + param.getType())       
                
                modelRef = sawPD.getCompleteModelReference(param)
                if not modelRef is None:
                    paramClass = dataFactory.getOWLClass(IRI.create(modelRef));
                    annotationSet = paramClass.getAnnotations(ontology,propertyComment)
                    for annotation in annotationSet:
     		        if isinstance(annotation.getValue(),OWLLiteral):
     		            val = annotation.getValue()
     		            if val.isOWLStringLiteral() and not val.isOWLTypedLiteral():
     		                print 'val.getLiteral()=' + val.getLiteral()
                                clientXml.write(', description from ontology is "' + val.getLiteral()+'"')  
                                break
                    clientXml.write('\n')            
        clientXml.write('  </help>\n</tool>')
        editor = editToolConfig1()
        editor.addTool(clientName)
        
        ##later add help feature 
    
    def wsdlRESTClient(self):
        ##parse wadl 
        javahome = os.environ.get('JAVA_HOME')
        galaxyhome=os.environ.get('GALAXY_HOME')
        classpath= galaxyhome + '/tools/WebServiceToolWorkflow_REST_SOAP/WodenWSDLParser/bin'
        jarpath = galaxyhome + '/tools/WebServiceToolWorkflow_REST_SOAP/WodenWSDLParser/lib/'
        machine = platform.machine()
    
        if machine == 'x86_64' :
            print 'a'
            startJVM("%s/jre/lib/amd64/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        elif machine == 'i686' :
            print 'b'
            startJVM("%s/jre/lib/i386/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        elif machine == 'sun4u' :
            startJVM("%s/jre/lib/sparc/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        else :
            print 'c'
            System.exit("Could not identify machine, please specify path to libjvm.so")

        
        pkg=JPackage('lsdis')
        wsdlUrl = self.webserviceId
    
        webserviceId = ''#self.methodName
        resUrl = self.resourceName
    
        urls = []
        methods = []
        params = []
        paramTypes = []
        
        WSDLParserDriver =pkg.WSDLParserDriver
        wPD=WSDLParserDriver()
        wPD.parse(wsdlUrl)
        methods = wPD.getCompleteMethodList()
        urls = wPD.getUrl()
                
        f=open(self.Ofile,'w')
        f.write(wsdlUrl)
        f.write('\n'+ resUrl)
        f.write('\n'+webserviceId)
        

        i=0
        for method in methods:
            x = str(method.getName().getLocalPart())
            y = str(url.get(i))
            webserviceId = x
            if y == resUrl :
                wPD.getParameters(x)
                f.write('method matched')
                paramTypes = wPD.getParamTypeList()
                params = wPD.getParamList()
                break
            i=i+1    
        

        
        
        ##generate client's xml
        galaxyhome=os.environ.get('GALAXY_HOME')
        
        clientCountFile=open(galaxyhome+'/tools/WebServiceTool/clients/ClientCount.xml','r')
	clientCountFile.readline()
        clientCountStr = clientCountFile.readline()
        clientCount=string.atoi(clientCountStr)
        clientCount=clientCount+1
        clientCountFile.close()
        
        clientCountFile=open(galaxyhome+'/tools/WebServiceTool/clients/ClientCount.xml','w')
	clientCountFile.write('<count> \n')
	clientCountFile.write(str(clientCount)+'\n')
	clientCountFile.write('</count> \n')
	
        
        
        
        clientName = 'WebServiceclient_'+ str(clientCount)
        
        clientXml=open(galaxyhome+'/tools/WebServiceTool/clients/'+clientName+'.xml','w')
        clientXml.seek(0,0)
        
        clientXml.write('<tool id="' + clientName+'" name="' + webserviceId +'">\n')
        clientXml.write('  <description> Client for method: '+webserviceId+' , Web service: '+self.webservice+' </description>\n')

  
        clientXml.write('  <command interpreter="python">\n  client_1.py \n'+'  $output \n  $servicetype\n ' +resUrl+'\n')
        ##write such that the parameters passed to client1.py(change name to clientName.py) are dependent on a for loop
        
        j=0
        for param in params:
            clientXml.write('  '+self.formatString(param)+'\n')
            clientXml.write('  $param' + str(j)+'\n')            
            j=j+1
        clientXml.write('</command>\n')
        
        ##write inputs depending on required or not. if not required den dont display 
        ##if required- den check default value, and if options exist.Depending on that
        ##decide the type of parameter and options
        clientXml.write('  <inputs>\n') 
        cleintXml.write('    <param name="servicetype" type="hidden" value="REST"/>')
        
        j=0
        for param in params:
            clientXml.write('<param format="text" size = "150" name = "param'+str(j)+'"  ')
            clientXml.write('type="text" label="'+param+'" help="see tip below" />\n')
            j=j+1
            
                    
                    
        clientXml.write('</inputs>\n  <outputs>\n    <data format="tabular" name="output" />\n  </outputs>\n')
        
        clientXml.write('  <help>\n')
        
        clientXml.write('** Replace white with ** in all parameter values **\n')
        
        j=0
        for param in params:
            clientXml.write('\n.. class:: infomark\n\n**TIP:** '+ param +' type is ' + paramTypes[j] +'\n')       
        
        clientXml.write('  </help>\n</tool>')
        editor = editToolConfig()
        editor.addTool(clientName)
        
        ##later add help feature


# Addedfor testing purpose
        
if __name__ == "__main__":
    
    test = ClientGenerator1('http://www.cs.uga.edu/~guttula/wublast.wsdl','run',None,'SOAP')
    present = test.isToolPresent()
    required = test.isRequired('_parameters|_sequence')
    print 'required : ',required
