'''
@author  Chaitanya Guttula, Sumedha Ganjoo
@see     LICENSE (MIT style license file).
'''

import warnings

with warnings.catch_warnings():
    warnings.simplefilter("ignore")
    import platform

    from jpype._jpackage import JPackage
    from jpype import *
    import os.path
    import sys
    import string
    from edit_tool_conf import *
    from clientGenerator.msHandler import *
    from clientGenerator.creatorEngineComplex import *
    from clientGenerator.wsdl2path import *
    from clientGenerator.paramConverter import *

    
class ClientGenerator(object):
    
    #instantiate a client for invocation of the selected method of a Web service in workflows
    def __init__(self,webservice,operation,outputfile,servicetype):
      with warnings.catch_warnings():
        warnings.simplefilter("ignore")
        self.operation = operation
        self.webservice = webservice
        #self.inputs = outputfile
        self.outputfile = outputfile
        self.galaxyhome=os.environ.get('GALAXY_HOME')
        self.clientfile = ''
        self.servicetype = servicetype
        if self.servicetype == 'SOAP':
            wLoad=wsdlLoader()
            sys.path.append(self.galaxyhome+'/tools/WebServiceToolWorkflow_REST_SOAP/clientGenerator')
            os.chdir(self.galaxyhome+'/tools/WebServiceToolWorkflow_REST_SOAP/clientGenerator')
        
            a = str(self.webservice).split('/')
            wsdlnamelist = a[len(a)-1].split(".")
            if len(wsdlnamelist)==1:
        	    wsdlnamelist=a[len(a)-1].split('?')
        	    print wsdlnamelist

            foldername=wsdlnamelist[0]
        
            path =self.galaxyhome+'/tools/WebServiceToolWorkflow_REST_SOAP/clientGenerator/'+foldername
        
    #creates the client stubs
            self.clientfile = wLoad.wsdlUrl2path(str(self.webservice),foldername)
        
            print 'Client file : ',self.clientfile
            self.paramelement = None
        
	    #replace '__tilda__' with '~'
        #if(url.find('__tilda__')>-1):
        #    ulist = url.split('__tilda__')
	    #url = '~'.join(ulist)
        #self.url = url        
        
    '''
    Checks if a particular paramter is reuired or not. This is used only for soap web services.
    ''' 
    def isRequired(self,param):
        #j=0
        #for param in inputl:
        cc = ClientCreator()
        self.msinstance = cc.opname2inputClassOb(self.operation,self.clientfile)
        test = MessageHandler()
        required = False
        if (param.find('|$|')>-1):
            plist = param.split('|')
            #root = test.getParameter(self.msinstance(),plist[0])
            k = 0
            iparam = ''
            for p in plist:
                if(k<len(plist)-3):
                    if(k==0):
                        iparam = iparam+(p)
                    else:
                        iparam = iparam+'|'+p
                    k=k+1
            paramelement = test.getParameter(self.msinstance(),iparam)
        else:
            paramelement = test.getParameter(self.msinstance(),param)
        self.paramelement = paramelement
        if (param.find('|')>-1):   
            plist = param.split('|')   
            root = test.getParameter(self.msinstance(),plist[0])    
            if not getattr(root,'nillable') and not getattr(paramelement,'nillable'):
                required = True
                return True
            elif getattr(root,'nillable') or (not getattr(root,'nillable') and getattr(paramelement,'nillable')): 
                required = False
                return False
        else:     
            if not getattr(paramelement,'nillable'):     
                required = True
                return True
            elif getattr(paramelement,'nillable'):
                required = False
                return False
        return required
    
    
    #replace '**' with ' '
    def formatString(self,string):
        l = string.split(' ')
        return '**'.join(l)

    '''
    Checks if the tool(operation) is already addded to Galaxy. It opens the tool_conf.xml file and loops through the "Web Service Workflow Tools" sections
    Then opens each and every tool (xml file) and looks for the description tag for the "Web Service" and "Client for Method" values and then checks
    if it same as the opearation and web service. As the code is dependent on description of the toool xml file, any change in the description tag 
    of the tool xml file can impact this function.
    '''
    def isToolPresent(self):
        
        f = open(self.galaxyhome+'/tool_conf.xml','r')
        line = f.readline()
        linestripped = line.lstrip()
        linestripped = linestripped.rstrip()
        
        while linestripped != '<section name="Select Web Service Workflow Tool" id="WebServiceWorkflow">':
            line = f.readline()
            linestripped = line.lstrip()
            linestripped = linestripped.rstrip()
            
        line = f.readline()
        linestripped = line.lstrip()
        linestripped = linestripped.rstrip()
                
        while linestripped != '</section>':
            if linestripped.find('<') >-1:
                toolparts = linestripped.split('"')
                print '\ntoolparts are : ',toolparts
                f1 = open(self.galaxyhome+'/tools/'+toolparts[-2],'r')
                line1 = f1.readline()
                while not line1.find('<description>') >-1:
                    line1 = f1.readline() 
                
                linestripped1 = line1.lstrip()
                linestripped1 = linestripped1.rstrip()
                descriptionparts=linestripped1.split(' ')
                print '\nOperation : ',descriptionparts
                service = ''
                if(self.servicetype == 'SOAP'):
                    service = self.clientfile
                elif self.servicetype == 'REST':
                    service = self.webservice
                print 'Service : ',service
                print 'operation : ',self.operation
                if(descriptionparts[5]==self.operation and descriptionparts[10] == service):
                    f.close()
                    f1.close()
                    return True
                f1.close()
            line = f.readline()
            linestripped = line.lstrip()
            linestripped = linestripped.rstrip()
            
        f.close()
        return False
    
    
       
    def wsdlClient(self):
      with warnings.catch_warnings():
        warnings.simplefilter("ignore")
       
        wLoad=wsdlLoader()
        galaxyhome=os.environ.get('GALAXY_HOME')
        sys.path.append(galaxyhome+'/tools/WebServiceToolWorkflow_REST_SOAP/clientGenerator')
        os.chdir(galaxyhome+'/tools/WebServiceToolWorkflow_REST_SOAP/clientGenerator')
        
        a = str(self.webservice).split('/')
        wsdlnamelist = a[len(a)-1].split(".")
        if len(wsdlnamelist)==1:
    	    wsdlnamelist=a[len(a)-1].split('?')
    	    print wsdlnamelist

        foldername=wsdlnamelist[0]
        
        path =galaxyhome+'/tools/WebServiceToolWorkflow_REST_SOAP/clientGenerator/'+foldername
        
    #creates the client stubs
        clientfile=wLoad.wsdlUrl2path(str(self.webservice),foldername)
        
        webservice = clientfile
        outputfile=open(self.outputfile,'w')
        test = ClientCreator()
        print 'inputs of '+self.operation+':\n'
        inputs= test.opname2inputs(self.operation,webservice)
        inputl = nested2flatDict(inputs)
        inputlist = inputl.keys()
        #noOfInputs=inputlist.count()
        print '*',inputs,'\n'
        count =0
        if (len(inputs)==0):
            inputs={' ':' '}
            #inputlist=inputs.keys()
        for i in inputlist:
            if count==0:
                outputfile.write(i+'\t'+webservice+'\t'+self.operation+'\n')
            else:
                outputfile.write(i+'\n')
            count=count+1

        cc = ClientCreator()
        self.msinstance = cc.opname2inputClassOb(self.operation,webservice)
        galaxyhome=os.environ.get('GALAXY_HOME')
        
        clientCountFile=open(galaxyhome+'/tools/WebServiceToolWorkflow_REST_SOAP/workflowclients/ClientCount.xml','r')
        clientCountFile.readline()
        clientCountStr = clientCountFile.readline()
        
        clientCount=string.atoi(clientCountStr)
        clientCount=clientCount+1
        clientCountFile.close()
        
        clientCountFile=open(galaxyhome+'/tools/WebServiceToolWorkflow_REST_SOAP/workflowclients/ClientCount.xml','w')
        clientCountFile.write('<count> \n')
        clientCountFile.write(str(clientCount)+'\n')
        clientCountFile.write('</count> \n')
        clientCountFile.close()
        
        
        
        
        clientName = 'workflowclient_'+ str(clientCount)
        
        clientXml=open(galaxyhome+'/tools/WebServiceToolWorkflow_REST_SOAP/workflowclients/'+clientName+'.xml','w')
        clientXml.seek(0,0)
        
        clientXml.write('<tool id="' + clientName+'" name="'+foldername+'.' + self.operation +'">\n')
        clientXml.write('  <description> Client for operation : '+self.operation+' , Web service : '+webservice+' </description>\n')

  
        #clientXml.write('  <command interpreter="python">\n  client_1.py \n' +'  $output \n  ' +self.webservice+' \n  '+self.operation+'\n')
        
        test = MessageHandler()
        
        #the workflow tool/client for a REST Web service invokes ./workflowclients/client_1.py to invoke the Web service
        #write the command tag to specify the arguments passed to this client_1.py
        
        clientXml.write('  <command interpreter="python">\n  	client_1.py\n'+'	#if $cond_source.optional_param_source=="no":\n  	$output\n	$servicetype\n      $url\n      $method\n' +webservice+ '         '+self.operation+'\n')
        ##write such that the parameters passed to client_1.py(change name to clientName.py) are dependent on a for loop
        
     # The paramter having |$| means that it has an elemnet with maxoccurs='unbounded' (i.e. array of strings)
     	
        j=0
        for param in inputl:
            if self.isRequired(param):
                clientXml.write('	"'+param+'"\n	 #if $source'+str(j)+'.source'+str(j)+'_source=="user":\n	 $source'+str(j)+'.user_param'+str(j)+'\n	 #else:\n	 fileInput\n	 $source' + str(j) + '.cached_param' + str(j)+'\n	 #end if\n')           
                j=j+1
            
        clientXml.write('   	#else:\n  	$output\n	$servicetype\n      $url\n      $method\n' +webservice+'            '+self.operation+'\n')
	        
	j=0
        for param in inputl:
            if self.isRequired(param):
                clientXml.write('	"'+param+'"\n	 #if $source'+str(j)+'.source'+str(j)+'_source=="user":\n	 $source'+str(j)+'.user_param'+str(j)+'\n	 #else:\n	 fileInput\n	 $source' + str(j) + '.cached_param' + str(j)+'\n	 #end if\n')            
                j=j+1
                                    
        for param in inputl:
            if not self.isRequired(param):     
                clientXml.write('	"'+param+'"\n	 #if $cond_source.source'+str(j)+'.source'+str(j)+'_source=="user":\n	 $cond_source.source'+str(j)+'.user_param'+str(j)+'\n	 #else:\n	 fileInput\n	 $cond_source.source' + str(j) + '.cached_param' + str(j)+'\n	 #end if\n')            
                j=j+1        
                        

        clientXml.write('   	#end if\n')
        
        clientXml.write('</command>\n')
        
        #start writing inputs
	    ##write inputs depending on required or not. if not required den dont display 
        ##if required- den check default value, and if options exist.Depending on that
        ##decide the type of parameter and options
        ##The input servicetype tells what type of webservice it is wether SOAP or REST - Useful during invocation of the web servcie   
        clientXml.write('  <inputs>\n')
        clientXml.write('     <param name="servicetype" type="hidden" value="SOAP" />\n')
        clientXml.write('     <param name="url" type="hidden" value="'+self.webservice+'" />\n')
        clientXml.write('     <param name="method" type="hidden" value="'+self.operation+'" />\n')
        
        j=0
        for param in inputl:                       
            if self.isRequired(param):     
                    pName = getattr(self.paramelement,'pname')
            
                    clientXml.write('<conditional name="source'+str(j)+'">\n    <param name="source' + str(j)+'_source" type="select" label="'+pName+' Source"> \n      <option value="cached" selected="true">Param value will be taken from previous step</option> \n      <option value="user">User will enter the param value</option> \n    </param>\n    <when value="user">\n')
                    clientXml.write('      <param format="text" size = "150" name = "user_param'+str(j)+'"  ')
                    clientXml.write('type="text" label="Enter '+pName+'" help="see tip below" />\n')
                  #  clientXml.write('    </param> \n')
                    clientXml.write(' </when>\n')    
                    clientXml.write(' <when value="cached">\n    <param name = "cached_param'+ str(j)+'" type="data" label="' + pName + '"/> \n </when>\n   </conditional>')            
                    j=j+1        
            
            
        clientXml.write('  <conditional name="cond_source">\n  <param name="optional_param_source" type="select" label="Display Optional Parameters"> \n <option value="no" selected="true">no</option> \n <option value="yes">yes</option> \n </param> \n    <when value="no"> \n     </when>\n    <when value="yes"> \n')

        for param in inputl:
            if not self.isRequired(param):     
                    pName = getattr(self.paramelement,'pname')
                      
                    clientXml.write('\n<conditional name="source'+str(j)+'">\n  <param name="source' + str(j)+'_source" type="select" label="'+pName+' Source"> \n    <option value="cached" selected="true">Param value will be taken from previous step</option> \n <option value="user">User will enter the param value</option> \n</param>\n         <when value="user">')
                    clientXml.write('<param format="text" size = "150" name = "user_param'+str(j)+'"  ')
                    clientXml.write('type="text" label="Enter '+pName+'" help="see tip below" />\n')
                    clientXml.write(' </when>\n')    
                    clientXml.write('<when value="cached">\n <param name = "cached_param'+ str(j)+'" type="data" label="' + pName + '"/> \n  </when>\n   </conditional>\n')
                    j=j+1       
            
                                    
        clientXml.write(' </when>\n </conditional>\n')
                    
        clientXml.write('</inputs>\n  <outputs>\n    <data format="tabular" name="output" />\n  </outputs>\n')
        clientXml.write('  <help>\n')
        paramtype = None
        for param in inputl:
            if self.isRequired(param):     
                    if isinstance(self.paramelement,ZSI.TC.String):
                        paramtype = 'String'
                    elif isinstance(self.paramelement,ZSI.TCnumbers.FPfloat):
                        paramtype = 'Floating point'
                    elif isinstance(self.paramelement,ZSI.TC.Boolean):
                        paramtype = 'Boolean'
                    elif isinstance(self.paramelement,ZSI.TCnumbers.Iint):
                        paramtype = 'Integer'
                    clientXml.write('\n.. class:: infomark\n\n**TIP:** About '+ getattr(self.paramelement,'pname') +': type is ' + paramtype + '\n')       
                                 
            
        clientXml.write('  </help>\n</tool>')
                
#        clientXml.write('  <help>\n')
        
 #       j=0
  #      for param in params:
   #         clientXml.write('\n.. class:: infomark\n\n**TIP:** '+ param +' type is ' + paramTypes[j] +'\n')       
        
    #    clientXml.write('  </help>\n</tool>')
       # clientXml.write('</tool>')
	clientXml.close()
        editor = editToolConfig()
        editor.addTool(clientName)
        
        ##later add help feature
    

        
    def wadlClient(self):
      
        ##parse wadl         
        pkg=JPackage('lsdis')
        urlToPass=java.net.URL(self.webservice)
        wadlUrl = self.webservice
    
        webserviceId = ''#self.operation
        resUrl = self.operation
        
        urls = []
        methods = []
        params = []
        
        #invoke the WADL parser packaged with this tool.
        WADLParserDriver=pkg.WADLParserDriver
        wPD=WADLParserDriver()
        wPD.parse(urlToPass)
        urls = wPD.getUrl()
        methods = wPD.getCompleteMethodList()
        
        a= str(self.webservice).split('/')
        wadlnamelist = a[len(a)-1].split(".")
        if len(wadlnamelist)==1:
    	    wadlnamelist=a[len(a)-1].split('?')
    	    print wadlnamelist

        wadlname=wadlnamelist[0]
        
        #write into the output file information about the method and Web service to be invoked.        
        f=open(self.outputfile,'w')
        f.write(self.webservice+'\t')
        f.write(resUrl+'\t')
        
        #get parameters for the selected method of the Web service
        i=0
        for method in methods:
            x = str(method.getId())
            y = str(urls.get(i))
            webserviceId = x
            if y == resUrl : 
                params = method.getRequest().getParams()
                break
            i=i+1    
        
        f.write(webserviceId)
        
        galaxyhome=os.environ.get('GALAXY_HOME')

        methodname = resUrl.split('/')

        #./workflowclients/ClientCount.xml keeps the count of the clients/tools currently registered in Galaxy for Web service invocation.
        #read the count and increment it. 
        clientCountFile=open(galaxyhome+'/tools/WebServiceToolWorkflow_REST_SOAP/workflowclients/ClientCount.xml','r')
        clientCountFile.readline()
        clientCountStr = clientCountFile.readline()
        clientCount=string.atoi(clientCountStr)
        clientCount=clientCount+1
        clientCountFile.close()
        
        clientCountFile=open(galaxyhome+'/tools/WebServiceToolWorkflow_REST_SOAP/workflowclients/ClientCount.xml','w')
        clientCountFile.write('<count> \n')
        clientCountFile.write(str(clientCount)+'\n')
        clientCountFile.write('</count> \n') 
        
        #include the count in the tool's name and id to uniquely identify it. 
        clientName = 'workflowclient_'+ str(clientCount)
        
        #create a new xml file under ./workflowclients/
        clientXml=open(galaxyhome+'/tools/WebServiceToolWorkflow_REST_SOAP/workflowclients/'+clientName+'.xml','w')
        clientXml.seek(0,0)
        
        #write the tool id, name and description
        clientXml.write('<tool id="' + clientName+'" name="' + wadlname + '.' + methodname[-1] +'">\n')
        clientXml.write('  <description> Client for method : '+self.operation+' , Web service : '+self.webservice+' </description>\n')

        #the workflow tool/client for a REST Web service invokes ./workflowclients/client_1.py to invoke the Web service
        #write the command tag to specify the arguments passed to this client_1.py
        clientXml.write('  <command interpreter="python">\n  	client_1.py\n'+'	#if $cond_source.optional_param_source=="no":\n  	$output\n	$servicetype\n      $url\n        $method\n     ' +resUrl+'\n')

        
        j=0
        for param in params:
            if param.isRequired():
                clientXml.write('	'+self.formatString(param.getName())+'\n	 #if $source'+str(j)+'.source'+str(j)+'_source=="user":\n	 $source'+str(j)+'.user_param'+str(j)+'\n	 #else:\n	 fileInput\n	 $source' + str(j) + '.cached_param' + str(j)+'\n	 #end if\n')            
                j=j+1
                
        clientXml.write('   	#else:\n  	$output\n	$servicetype\n    $url\n    $method\n' +resUrl+'\n')
        j=0
        for param in params:
            if param.isRequired():
                clientXml.write('	'+self.formatString(param.getName())+'\n	 #if $source'+str(j)+'.source'+str(j)+'_source=="user":\n	 $source'+str(j)+'.user_param'+str(j)+'\n	 #else:\n	 fileInput\n	 $source' + str(j) + '.cached_param' + str(j)+'\n	 #end if\n')            
                j=j+1
        
        for param in params:
            if not param.isRequired():
                clientXml.write('	'+self.formatString(param.getName())+'\n	 #if $cond_source.source'+str(j)+'.source'+str(j)+'_source=="user":\n	 $cond_source.source'+str(j)+'.user_param'+str(j)+'\n	 #else:\n	 fileInput\n	 $cond_source.source' + str(j) + '.cached_param' + str(j)+'\n	 #end if\n')            
                j=j+1

        clientXml.write('   	#end if\n')
        clientXml.write('</command>\n')
        
        #start writing inputs
	    ##write inputs depending on required or not. if not required den dont display 
        ##if required- den check default value, and if options exist.Depending on that
        ##decide the type of parameter and options
        ##The input servicetype tells what type of webservice it is wether SOAP or REST - Useful during invocation of the web servcie   
        
        clientXml.write('  <inputs>\n')
        clientXml.write('     <param name="servicetype" type="hidden" value="REST"/>\n')
        clientXml.write('     <param name="url" type="hidden" value="'+self.webservice+'" />\n')
        clientXml.write('     <param name="method" type="hidden" value="'+self.operation+'" />\n')
  
        
        #create a param for each required parameter described in the WADL. Check if defaults are specified. Create param such that
        #it can either be given a value manually or the value can be taken from a previous step.
        j=0
        for param in params:                       
            if param.isRequired():
                pName = param.getName()
                for doc in param.getDocs():
                    if doc.getTitle()=="prompt" or doc.getTitle()=="Prompt" or doc.getTitle()=="PROMPT":
		        pName = doc.getInnerText()          
            
                clientXml.write('<conditional name="source'+str(j)+'">\n    <param name="source' + str(j)+'_source" type="select" label="'+pName+' Source"> \n      <option value="cached" selected="true">Param value will be taken from previous step</option> \n      <option value="user">User will enter the param value</option> \n    </param>\n    <when value="user">\n')
                if param.getOptions().size()==0:
                    clientXml.write('      <param format="text" size = "150" name = "user_param'+str(j)+'"  ')
                    if not param.getDefault1() == None:
                        clientXml.write('value="'+param.getDefault1()+'"  ')
                    clientXml.write('type="text" label="Enter '+pName+'" help="see tip below" />\n')
                else:
                    clientXml.write('    <param name="user_param'+str(j)+'" type="select" label="Select '+pName+'" help="see tip below">\n' )    
                    for option in param.getOptions():
                        clientXml.write('      <option value="'+self.formatString(option.getName())+'" ')
                        if option.getName() == param.getDefault1():
                            clientXml.write('selected="true"')
                        clientXml.write('>'+option.getName()+'</option>\n ')    
                    clientXml.write('    </param> \n')
                clientXml.write(' </when>\n')    
                clientXml.write(' <when value="cached">\n    <param name = "cached_param'+ str(j)+'" type="data" label="' + pName + '"/> \n </when></conditional>')
                j=j+1

        #create a conditional param for each optional parameter described in the WADL. Again the param can be given a value manually or the value can be taken from
        #a previous step.
        clientXml.write('  <conditional name="cond_source">\n  <param name="optional_param_source" type="select" label="Display Optional Parameters"> \n <option value="no" selected="true">no</option> \n <option value="yes">yes</option> \n </param> \n    <when value="no"> \n     </when>\n    <when value="yes"> \n')

        for param in params:
            if not param.isRequired():
                pName = param.getName()
                for doc in param.getDocs():
                    if doc.getTitle()=="prompt" or doc.getTitle()=="Prompt" or doc.getTitle()=="PROMPT":
		        pName = doc.getInnerText()   
		                    
                clientXml.write('\n<conditional name="source'+str(j)+'">\n  <param name="source' + str(j)+'_source" type="select" label="'+pName+' Source"> \n    <option value="cached" selected="true">Param value will be taken from previous step</option> \n <option value="user">User will enter the param value</option> \n</param>\n         <when value="user">')
                if param.getOptions().size()==0:
                    clientXml.write('<param format="text" size = "150" name = "user_param'+str(j)+'"  ')
                    if not param.getDefault1() == None:
                        clientXml.write('value="'+param.getDefault1()+'"  ')
                    clientXml.write('type="text" label="Enter '+pName+'" help="see tip below" />\n')
                else:
                    clientXml.write('<param name="user_param'+str(j)+'" type="select" label="Select '+pName+'" help="see tip below">\n' )    
                    for option in param.getOptions():
                        clientXml.write(' <option value="'+self.formatString(option.getName())+'" ')
                        if option.getName() == param.getDefault1():
                            clientXml.write('selected="true"')
                        clientXml.write('>'+option.getName()+'</option>\n ')    
                    clientXml.write('    </param> \n')
                clientXml.write(' </when>\n')    
                clientXml.write('<when value="cached">\n <param name = "cached_param'+ str(j)+'" type="data" label="' + pName + '"/> \n  </when></conditional>\n')
                j=j+1
                            
                            
                            
        clientXml.write(' </when>\n </conditional>\n</inputs>\n  <outputs>\n    <data format="tabular" name="output" />\n  </outputs>\n')

        #write information about each parameter in the help section        
        clientXml.write('  <help>\n')
        clientXml.write('Replace white space with ** in all parameter values\n')

        for param in params:
            if param.isRequired():
                pName = param.getName()
                for doc in param.getDocs():
                    if doc.getTitle()=="prompt" or doc.getTitle()=="Prompt" or doc.getTitle()=="PROMPT":
		        pName = doc.getInnerText()           
                clientXml.write('\n.. class:: infomark\n\n**TIP:** '+ pName +' type is ' + param.getType()+'\n')       
        
        clientXml.write('  </help>\n</tool>')
        
        #adds the newly created tool to tool_conf.xml in Galaxy under the 'Web Service Workflow Tools' section.
        editor = editToolConfig()
        editor.addTool(clientName)
        
        
        
        
    def sawadlClient(self):
        ##parse sawadl 
        
        pkg=JPackage('edu.uga.cs.lsdis.meteors.wadls')
        pkgModel =JPackage('org.semanticweb.owlapi.model')
        pkgApiBinding =JPackage('org.semanticweb.owlapi.apibinding')
        pkgVocab = JPackage('org.semanticweb.owlapi.vocab')
    
        DOCUMENT_IRI = "http://cs.uga.edu/~ganjoo/galaxy/EDAM.owl"
    
        sawadlUrl = self.webservice
    
        webserviceId = ''#self.inputs
        resUrl = self.operation
    
        urls = []
        methods = []
        params = []
        annotationSet = []

        SAWADLParserDriver=pkg.SAWADLParserDriver
        sawPD=SAWADLParserDriver()
        sawPD.parse(sawadlUrl)
        urls = sawPD.getUrl()
        methods = sawPD.getCompleteMethodList()

        IRI = pkgModel.IRI
        OWLRDFVocabulary = pkgVocab.OWLRDFVocabulary
        OWLManager = pkgApiBinding.OWLManager
        OWLLiteral = pkgModel.OWLLiteral
        owlOntManager = OWLManager.createOWLOntologyManager()
        ontology = owlOntManager.loadOntologyFromOntologyDocument(IRI.create(DOCUMENT_IRI))
        dataFactory = owlOntManager.getOWLDataFactory()
        propertyComment = dataFactory.getOWLAnnotationProperty(OWLRDFVocabulary.RDFS_COMMENT.getIRI())

        #write into the output file information about the method and Web service to be invoked.        
        f=open(self.outputfile,'w')
        f.write(self.webservice+'\t')
        f.write(resUrl+'\t')
        
        i=0
        for method in methods:
            x = str(method.getName())
            y = str(urls.get(i))
            webserviceId = x
            #if x == webserviceId :
            if y == resUrl : 
                params = method.getRequest().getParamList()
                break
            i=i+1    
        

        f.write(webserviceId)
        
        ##generate client's xml
        galaxyhome=os.environ.get('GALAXY_HOME')
        
        clientCountFile=open(galaxyhome+'/tools/WebServiceToolWorkflow_REST_SOAP/workflowclients/ClientCount.xml','r')
        clientCountFile.readline()
        clientCountStr = clientCountFile.readline()
        clientCount=string.atoi(clientCountStr)
        clientCount=clientCount+1
        clientCountFile.close()
        
        clientCountFile=open(galaxyhome+'/tools/WebServiceToolWorkflow_REST_SOAP/workflowclients/ClientCount.xml','w')
        clientCountFile.write('<count> \n')
        clientCountFile.write(str(clientCount)+'\n')
        clientCountFile.write('</count> \n')
	
        
        
        
        clientName = 'workflowclient_'+ str(clientCount)
        
        clientXml=open(galaxyhome+'/tools/WebServiceToolWorkflow/workflowclients/'+clientName+'.xml','w')
        clientXml.seek(0,0)
        
        clientXml.write('<tool id="' + clientName+'" name="' + webserviceId +'">\n')
        clientXml.write('  <description> Client for method: '+webserviceId+' , Web service: '+self.webservice+' </description>\n')

  
        clientXml.write('  <command interpreter="python">\n  #client_1.py \n'+'  $output \n  $servicetype\n  $url\n  $method\n  ' +resUrl+'\n')
        ##write such that the parameters passed to client1.py(change name to clientName.py) are dependent on a for loop
        
               
        j=0
        for param in params:
            if param.getRequired()=='true' or param.getRequired()=='True' or param.getRequired()=='TRUE':
                clientXml.write('  '+self.formatString(param.getName())+'\n#if $source'+str(j)+'.source'+str(j)+'_source=="user" $source'+str(j)+'.user_param'+str(j)+' #else $source' + str(j) + '.cached_param' + str(j)+' #end if\n')            
                j=j+1
        clientXml.write('#if $cond_source.optional_param_source=="yes"')
        
        for param in params:
            if not param.getRequired()=='true' and not param.getRequired()=='True' and not param.getRequired()=='TRUE':
                clientXml.write('  '+self.formatString(param.getName())+'\n#if $cond_source.source'+str(j)+'.source'+str(j)+'_source=="user" $cond_source.source'+str(j)+'.user_param'+str(j)+' #else $cond_source.source' + str(j) + '.cached_param' + str(j)+' #end if\n')            
                j=j+1

        clientXml.write('#else \n#end if\n')
        clientXml.write('</command>\n')                
        
        ##write inputs depending on required or not. if not required den dont display 
        ##if required- den check default value, and if options exist.Depending on that
        ##decide the type of parameter and options
        ##The input servicetype tells what type of webservice it is wether SOAP or REST - Useful during invocation of the web servcie   
        
        clientXml.write('  <inputs>\n') 
        clientXml.write('      <param name="servicetype" type="hidden" value="REST" />')
        clientXml.write('      <param name="url" type="hidden" value="'+self.webservice+'" />\n')
        clientXml.write('      <param name="method" type="hidden" value="'+self.operation+'" />\n')
       
        
        j=0
        for param in params:
            if param.getRequired()=='true' or param.getRequired()=='True' or param.getRequired()=='TRUE':
                clientXml.write('<conditional name="source'+str(j)+'">\n    <param name="source' + str(j)+'_source" type="select" label="'+param.getName()+' Source"> \n      <option value="cached" selected="true">Param value will be taken from previous step</option> \n      <option value="user">User will enter the param value</option> \n    </param>\n    <when value="user">\n')
                if param.getOptionvalue().size()==0:
                    clientXml.write('    <param format="text" size = "150" name = "user_param'+str(j)+'"  ')
                    if not param.getDefault1() == None:
                        clientXml.write('value="'+param.getDefault1()+'"  ')
                    clientXml.write('type="text" label="Enter '+param.getName()+'" help="see tip below" />\n')
                    j=j+1
                else:
                    clientXml.write('    <param name="user_param'+str(j)+'" type="select" label="Select '+param.getName()+'" help="see tip below">\n' )    
                    for option in param.getOptionvalue():
                        clientXml.write('   <option value="'+self.formatString(option)+'" ')
                        if option == param.getDefault1():
                            clientXml.write('selected="true"')
                        clientXml.write('>'+option+'</option>\n ')    
                    clientXml.write('    </param> \n')
                    j=j+1
                clientXml.write(' </when>\n')    
                clientXml.write(' <when value="cached">\n    <param name = "cached_param'+ str(j)+'" type="data" label="' + param.getName() + '"/> \n </when></conditional>')

        clientXml.write('  <conditional name="cond_source">\n  <param name="optional_param_source" type="select" label="Display Additional Parameters"> \n <option value="no" selected="true">no</option> \n <option value="yes">yes</option> \n </param> \n    <when value="no"> \n     </when>\n    <when value="yes"> \n')        

        for param in params:
            if not param.getRequired()=='true' and not param.getRequired()=='True' and not param.getRequired()=='TRUE':
                clientXml.write('<conditional name="source'+str(j)+'">\n    <param name="source' + str(j)+'_source" type="select" label="'+param.getName()+' Source"> \n      <option value="cached" selected="true">Param value will be taken from previous step</option> \n      <option value="user">User will enter the param value</option> \n    </param>\n    <when value="user">\n')
                if param.getOptionvalue().size()==0:
                    clientXml.write('    <param format="text" size = "150" name = "user_param'+str(j)+'"  ')
                    if not param.getDefault1() == None:
                        clientXml.write('value="'+param.getDefault1()+'"  ')
                    clientXml.write('type="text" label="Enter '+param.getName()+'" help="see tip below" />\n')
                    j=j+1
                else:
                    clientXml.write('    <param name="user_param'+str(j)+'" type="select" label="Select'+param.getName()+'" help="see tip below">\n' )    
                    for option in param.getOptionvalue():
                        clientXml.write('   <option value="'+self.formatString(option)+'" ')
                        if option == param.getDefault1():
                            clientXml.write('selected="true"')
                        clientXml.write('>'+option+'</option>\n ')    
                    clientXml.write('    </param> \n')
                    j=j+1
                clientXml.write(' </when>\n')    
                clientXml.write(' <when value="cached">\n    <param name = "cached_param'+ str(j)+'" type="data" label="' + param.getName() + '"/> \n </when></conditional>')

        clientXml.write(' </when>\n </conditional>\n')                 
                    
        clientXml.write('</inputs>\n  <outputs>\n    <data format="tabular" name="output" />\n  </outputs>\n')
        
        clientXml.write('  <help>\n')
        for param in params:
            if param.getRequired()=='true' or param.getRequired()=='True' or param.getRequired()=='TRUE':
                clientXml.write('\n.. class:: infomark\n\n**TIP:** About '+ param.getName() +': type is ' + param.getType())       
                
                modelRef = sawPD.getCompleteModelReference(param)
                if not modelRef is None:
                    paramClass = dataFactory.getOWLClass(IRI.create(modelRef));
                    annotationSet = paramClass.getAnnotations(ontology,propertyComment)
                    for annotation in annotationSet:
     		        if isinstance(annotation.getValue(),OWLLiteral):
     		            val = annotation.getValue()
     		            if val.isOWLStringLiteral() and not val.isOWLTypedLiteral():
     		                print 'val.getLiteral()=' + val.getLiteral()
                                clientXml.write(', description from ontology is "' + val.getLiteral()+'"')  
                                break
                    clientXml.write('\n')            
        clientXml.write('  </help>\n</tool>')
        editor = editToolConfig()
        editor.addTool(clientName)
    
    
    def wsdlRestClient(self):
        ##parse wadl 
        javahome = os.environ.get('JAVA_HOME')
        galaxyhome=os.environ.get('GALAXY_HOME')
        classpath= galaxyhome + '/tools/WebServiceToolWorkflow_REST_SOAP/WodenWSDLParser/bin'
        jarpath = galaxyhome + '/tools/WebServiceToolWorkflow_REST_SOAP/WodenWSDLParser/lib/'
        machine = platform.machine()
    
        if machine == 'x86_64' :
            print 'a'
            startJVM("%s/jre/lib/amd64/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        elif machine == 'i686' :
            print 'b'
            startJVM("%s/jre/lib/i386/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        elif machine == 'sun4u' :
            startJVM("%s/jre/lib/sparc/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        else :
            print 'c'
            System.exit("Could not identify machine, please specify path to libjvm.so")

        
        pkg=JPackage('lsdis')
        wsdlUrl = self.webservice
    
        webserviceId = ''#self.methodName
        resUrl = self.operation
    
        urls = []
        methods = []
        params = []
        paramTypes = []
        
        WSDLParserDriver =pkg.WSDLParserDriver
        wPD=WSDLParserDriver()
        wPD.parse(wsdlUrl)
        methods = wPD.getCompleteMethodList()
        urls = wPD.getUrl()
                
        f=open(self.outputfile,'w')
        f.write(wsdlUrl+'\t')
        f.write(resUrl+'\t')
        

        i=0
        for method in methods:
            x = str(method.getName().getLocalPart())
            y = str(url.get(i))
            webserviceId = x
            if y == resUrl :
                wPD.getParameters(x)
                f.write('method matched')
                paramTypes = wPD.getParamTypeList()
                params = wPD.getParamList()
                break
            i=i+1    
        
        f.write(webserviceId)

        
        
        ##generate client's xml
        galaxyhome=os.environ.get('GALAXY_HOME')
        
        clientCountFile=open(galaxyhome+'/tools/WebServiceToolWorkflow_REST_SOAP/workflowclients/ClientCount.xml','r')
        clientCountFile.readline()
        clientCountStr = clientCountFile.readline()
        clientCount=string.atoi(clientCountStr)
        clientCount=clientCount+1
        clientCountFile.close()
        
        clientCountFile=open(galaxyhome+'/tools/WebServiceToolWorkflow_REST_SOAP/workflowclients/ClientCount.xml','w')
        clientCountFile.write('<count> \n')
        clientCountFile.write(str(clientCount)+'\n')
        clientCountFile.write('</count> \n')
	
        
        
        
        clientName = 'workflowclient_'+ str(clientCount)
        
        clientXml=open(galaxyhome+'/tools/WebServiceToolWorkflow_RESTSOAP/workflowclients/'+clientName+'.xml','w')
        clientXml.seek(0,0)
        
        clientXml.write('<tool id="' + clientName+'" name="' + webserviceId +'">\n')
        clientXml.write('  <description> Client for method: '+webserviceId+' , Web service: '+self.webservice+' </description>\n')

  
        clientXml.write('  <command interpreter="python">\n  client_1.py \n'+'  $output \n  $servicetype\n $url \n $method' +resUrl+'\n')
        ##write such that the parameters passed to client1.py(change name to clientName.py) are dependent on a for loop
        
        j=0
        for param in params:
            clientXml.write('  '+self.formatString(param)+'\n')
            clientXml.write('  $param' + str(j)+'\n')            
            j=j+1
        clientXml.write('</command>\n')
        
        ##write inputs depending on required or not. if not required den dont display 
        ##if required- den check default value, and if options exist.Depending on that
        ##decide the type of parameter and options
        clientXml.write('  <inputs>\n') 
        clientXml.write('      <param name="servicetype" type="hidden" value="REST" />')
        clientXml.write('      <param name="url" type="hidden" value="'+self.webservice+'" />\n')
        clientXml.write('      <param name="method" type="hidden" value="'+self.operation+'" />\n')
       
        
        j=0
        for param in params:
            clientXml.write('<param format="text" size = "150" name = "param'+str(j)+'"  ')
            clientXml.write('type="text" label="'+param+'" help="see tip below" />\n')
            j=j+1
            
                    
                    
        clientXml.write('</inputs>\n  <outputs>\n    <data format="tabular" name="output" />\n  </outputs>\n')
        
        clientXml.write('  <help>\n')
        
        j=0
        for param in params:
            clientXml.write('\n.. class:: infomark\n\n**TIP:** '+ param +' type is ' + paramTypes[j] +'\n')       
        
        clientXml.write('  </help>\n</tool>')
        editor = editToolConfig()
        editor.addTool(clientName)
        
        ##later add help feature
        
if __name__ == "__main__":
    
    test = ClientGenerator('http://eupathdb.org/eupathdb/webservices/GeneQuestions/GenesByGeneType.wadl','genesbygenetype',None,'REST')
    present = test.isToolPresent()
#    required = test.isRequired('_parameters|_sequence')
    print 'Tool is present : ',present
    
