/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.RemoveAxiom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmalgamateSubClassAxioms
extends AbstractCompositeOntologyChange {
    private List<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();

    public AmalgamateSubClassAxioms(Set<OWLOntology> ontologies, OWLDataFactory dataFactory) {
        super(dataFactory);
        for (OWLOntology ont : ontologies) {
            for (OWLClass cls : ont.getClassesInSignature()) {
                Set<OWLSubClassOfAxiom> axioms = ont.getSubClassAxiomsForSubClass(cls);
                if (axioms.size() <= 1) continue;
                HashSet<OWLClassExpression> superClasses = new HashSet<OWLClassExpression>();
                for (OWLSubClassOfAxiom ax : axioms) {
                    this.changes.add(new RemoveAxiom(ont, ax));
                    superClasses.add(ax.getSuperClass());
                }
                OWLObjectIntersectionOf combinedSuperClass = this.getDataFactory().getOWLObjectIntersectionOf(superClasses);
                this.changes.add(new AddAxiom(ont, this.getDataFactory().getOWLSubClassOfAxiom(cls, combinedSuperClass)));
            }
        }
    }

    @Override
    public List<OWLOntologyChange> getChanges() {
        return this.changes;
    }
}

