'''
@author  Chaitanya Guttula
@see     LICENSE (MIT style license file).
'''

import warnings
with warnings.catch_warnings():
    warnings.simplefilter("ignore")
    import warnings
    import urllib2
    import platform
    import os,sys
    from clientGenerator.creatorEngineComplex import *
    from clientGenerator.wsdl2path import *
    from clientGenerator.paramConverter import *
    from generateClient import *
    from generateClient1 import *

'''input : wadl/wsdl/sawadl-url, method name
purpose: 
1. Calls methods from generateClient1.py to generate client description for one-time invocation
of the Web service. This client description is added as a xml file under ./clients/
2. Calls methods from generateClient.py to generate client description for invocation of Web service
in a workflow. This client description is added as a xml file under ./workflowclients/
3. Adds the path to the above xml files to Galaxy tool-conf.xml file using call edit_tool_conf.py
'''

servicetype=''

#read the url passed as an argument
url = sys.argv[2]
while(url.find('__tilda__')>-1):
    ulist = url.split('__tilda__')
    url = '~'.join(ulist)

#split url passed on '.' character
urllist = url.split('/')
wsdlname = urllist[len(urllist)-1].split(".")
if len(wsdlname)==1:
    wsdlname =urllist[len(urllist)-1].split('?')

'''#checks the description document (WSDL/WADL) is for SOAP 1.1 or SOAP 2.0 or REST
   If the extesnion is wsdl then servicetype is SOAP else If the extension is wadl then servicetype is REST
   in other conditions(i.e. the file has no extension)
'''
#u = None
#try:
#    u = urllib2.urlopen(url)
#except urllib2.HTTPError, e:
#    print e.code
#    print e.msg
#    print e.headers
#    print e.fp.read()
print 'the url is : ',sys.argv[2]
u = urllib2.urlopen(url)
descfile = open('temp','w')
descfile.write(u.read())
descfile.close()
readwsdl = open('temp','r')
tempstring = 'start'
    
#checks the description document (WSDL/WADL) is for SOAP 1.1 or SOAP 2.0 or REST    
while (tempstring != ''):
    tempstring = readwsdl.readline()
    if tempstring.find('<definitions') != -1 or tempstring.find('<wsdl:definitions') != -1:
       print 'WSDL 1.1 or 1.0'
       servicetype = 'SOAP'
       break
    elif tempstring.find('description') != -1:
         while tempstring != '':
            if tempstring.find('<bindings ') != -1:
                bind = tempstring.split('type')
                bindLength = len(bind)
                bindingtype = bind[bindLength-1]
                print bindingtype
                break
            tempstring = readwsdl.readline()
            if bindingtype.find('http://www.w3.org/ns/wsdl/soap') != -1:    
                servicetype='WSDL2SOAP'
                print 'SOAP'
            else:
                servicetype='WSDL2REST'
            break
    elif tempstring.find('<application') != -1:
        servicetype='REST'
        break
        
readwsdl.close()        
operations = sys.argv[3].split(',')              
    
# The webservice is a soap webservice
if servicetype == 'SOAP':
    
    #Create client tool for using web services in workflow
        for operation in operations:
            if operation != '':
                clientGenerator = ClientGenerator(url,operation,sys.argv[4],'SOAP')#webservice,operation,inputl)
                if clientGenerator.isToolPresent():
                    f = open(sys.argv[4],'a')
                    f.write('The web service workflow tool for service '+url+' and operation '+operation+' was already added to galaxy\n')    
                else:
                    clientGenerator.wsdlClient()

        
    #Create cleint tool for invoking web service stand alone
                clientGenerator1 = ClientGenerator1(url,operation,sys.argv[4],'SOAP')#webservice,operation,inputl)
                if clientGenerator1.isToolPresent():
                    f = open(sys.argv[4],'a')
                    f.write('The web service tool for service '+url+' and operation '+operation+' was already added to galaxy\n')    
                else:
                    clientGenerator1.wsdlClient()
    
    
   
#Web service is a REST Webservice
elif servicetype == 'REST':
    
    javahome = os.environ.get('JAVA_HOME')
    galaxyhome=os.environ.get('GALAXY_HOME')
    classpath= galaxyhome + '/tools/WebServiceToolWorkflow_REST_SOAP/ParserForWADL/bin'
    jarpath = galaxyhome + '/tools/WebServiceToolWorkflow_REST_SOAP/ParserForWADL/lib/'
    machine = platform.machine()
    
    if machine == 'x86_64' :
        print 'a'
        startJVM("%s/jre/lib/amd64/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
    elif machine == 'i686' :
        startJVM("%s/jre/lib/i386/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        print 'b'
    elif machine == 'sun4u' :
        startJVM("%s/jre/lib/sparc/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
    else :
        print 'c'
        System.exit("Could not identify machine, please specify path to libjvm.so")    
    
    
    
    for operation in operations:
        if(operation != ''):
            clientGenerator = ClientGenerator(url,operation,sys.argv[4],'REST')
            clientGenerator1 = ClientGenerator1(url,operation,sys.argv[4],'REST')
            if clientGenerator.isToolPresent():
                f = open(sys.argv[4],'a')
                f.write('\nThe web service workflow tool for service '+url+' and operation '+operation+' was already added to galaxy\n')    
            else:
                clientGenerator.wadlClient()
            if clientGenerator1.isToolPresent():
                f = open(sys.argv[4],'a')
                f.write('\nThe web service tool for service '+url+' and operation '+operation+' was already added to galaxy\n')    
            else:
                clientGenerator1.wadlClient()
    
    
    #shutdownJVM()

