'''
@author  Chaitanya Guttula
@see     LICENSE (MIT style license file).
'''

import warnings
with warnings.catch_warnings():
    warnings.simplefilter("ignore")
    import platform
    import os
    import sys
    import ZSI
    import commands
    from clientGenerator.creatorEngineComplex import *
    from clientGenerator.wsdl2path import *
    import urllib2
    from getMethods_m import *
    
    '''
    Takes the description document as input and parses the document and 
    gets all the operations available in the web service and provides it 
    Galaxy
    
    '''

    url = sys.argv[1]
    while(url.find('__tilda__')>-1):
        ulist = url.split('__tilda__')
        url = '~'.join(ulist)            
    urllist = url.split('/')
    wsdlname = urllist[len(urllist)-1].split(".")
    if len(wsdlname)==1:
        wsdlname =urllist[len(urllist)-1].split('?')
    
    servicetype = ''
    
#instantiate a Document   
    descriptionDocument = Document()
    
    #if wsdlname[-1] == 'wsdl' or wsdlname[-1] == 'WSDL': 
    #    servicetype='SOAP'
    #elif wsdlname[-1] == 'wadl' or wsdlname[-1] == 'WADL':
    #    servicetype='REST'
    #else:

    try:
        u = urllib2.urlopen(url)
    except urllib2.HTTPError, e:
        print e.code
        print e.msg
        print e.headers
        print e.fp.read()

    descfile = open('temp','w')
    descfile.write(u.read())
    descfile.close()
    readwsdl = open('temp','r')
    tempstring = 'start'
    
    #checks the description document (WSDL/WADL) is for SOAP 1.1 or SOAP 2.0 or REST and gets the operations in the web service accordingly   
    while (tempstring != ''):
        tempstring = readwsdl.readline()
         #If its WSDL 1.0/1.1
        if tempstring.find('<definitions') != -1 or tempstring.find('<wsdl:definitions') != -1:
            servicetype = 'SOAP'
            descriptionDocument.getWSDLMethods(url,sys.argv[2])
            break
         #if it is WSDL 2.0
        elif tempstring.find('<description') != -1 or tempstring.find('<wsdl:description') != -1:
            #servicetype = 'WSDL2.0'
            #break
            while tempstring != '':
                if tempstring.find('<bindings ') != -1 or tempstring.find('<wsdl:bindings') != -1:
                    bind = tempstring.split('type')
                    bindLength = len(bind)
                    bindingtype = bind[bindLength-1]
                    break
                tempstring = readwsdl.readline()
               #IF the WSDL describes SOAP web services
                if bindingtype.find('http://www.w3.org/ns/wsdl/soap') != -1:    
                    #descriptionDocument.getWSDL2Methods(url,sys.argv[2])
                    print 'WSDL 1.1'
               #If the WSDL describes REST web services
                else:
                    descriptionDocument.getWSDLRESTMethods(url,sys.argv[2])
                break
        elif tempstring.find('<application') != -1 or tempstring.find('<APPLICATION') != -1:
        	#servicetype = 'REST'
        	descriptionDocument.getWADLMethods(url,sys.argv[2])
        	break
                  
    readwsdl.close()
   
    #if(servicetype == 'REST'):
    #    descriptionDocument.getWADLMethods(url,sys.argv[2])
    #elif (servicetype == 'SOAP'):
    #    descriptionDocument.getWSDLMethods(url,sys.argv[2])    
    #else:
    #    descriptionDocument.getWSDL2Methods(url,sys.argv[2])
