################################################## 
# KEGG_v6_2_services.py 
# generated by ZSI.generate.wsdl2python
##################################################


from KEGG_v6_2_services_types import *
import urlparse, types
from ZSI.TCcompound import ComplexType, Struct
from ZSI import client
import ZSI

# Locator
class KEGGLocator:
    KEGGPortType_address = "http://soap.genome.jp/keggapi/request_v6.2.cgi"
    def getKEGGPortTypeAddress(self):
        return KEGGLocator.KEGGPortType_address
    def getKEGGPortType(self, url=None, **kw):
        return KEGGBindingSOAP(url or KEGGLocator.KEGGPortType_address, **kw)

# Methods
class KEGGBindingSOAP:
    def __init__(self, url, **kw):
        kw.setdefault("readerclass", None)
        kw.setdefault("writerclass", None)
        # no resource properties
        self.binding = client.Binding(url=url, **kw)
        # no ws-addressing

    # op: list_databases
    def list_databases(self, request):
        if isinstance(request, list_databasesRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#list_databases", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=list_databasesResponse.typecode.ofwhat, pyclass=list_databasesResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: list_organisms
    def list_organisms(self, request):
        if isinstance(request, list_organismsRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#list_organisms", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=list_organismsResponse.typecode.ofwhat, pyclass=list_organismsResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: list_pathways
    def list_pathways(self, request):
        if isinstance(request, list_pathwaysRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#list_pathways", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=list_pathwaysResponse.typecode.ofwhat, pyclass=list_pathwaysResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: list_ko_classes
    def list_ko_classes(self, request):
        if isinstance(request, list_ko_classesRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#list_ko_classes", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=list_ko_classesResponse.typecode.ofwhat, pyclass=list_ko_classesResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: binfo
    def binfo(self, request):
        if isinstance(request, binfoRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#binfo", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=binfoResponse.typecode.ofwhat, pyclass=binfoResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: bget
    def bget(self, request):
        if isinstance(request, bgetRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#bget", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=bgetResponse.typecode.ofwhat, pyclass=bgetResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: bfind
    def bfind(self, request):
        if isinstance(request, bfindRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#bfind", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=bfindResponse.typecode.ofwhat, pyclass=bfindResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: btit
    def btit(self, request):
        if isinstance(request, btitRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#btit", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=btitResponse.typecode.ofwhat, pyclass=btitResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: bconv
    def bconv(self, request):
        if isinstance(request, bconvRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#bconv", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=bconvResponse.typecode.ofwhat, pyclass=bconvResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_linkdb_by_entry
    def get_linkdb_by_entry(self, request):
        if isinstance(request, get_linkdb_by_entryRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_linkdb_by_entry", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_linkdb_by_entryResponse.typecode.ofwhat, pyclass=get_linkdb_by_entryResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_best_neighbors_by_gene
    def get_best_neighbors_by_gene(self, request):
        if isinstance(request, get_best_neighbors_by_geneRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_best_neighbors_by_gene", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_best_neighbors_by_geneResponse.typecode.ofwhat, pyclass=get_best_neighbors_by_geneResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_best_best_neighbors_by_gene
    def get_best_best_neighbors_by_gene(self, request):
        if isinstance(request, get_best_best_neighbors_by_geneRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_best_best_neighbors_by_gene", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_best_best_neighbors_by_geneResponse.typecode.ofwhat, pyclass=get_best_best_neighbors_by_geneResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_reverse_best_neighbors_by_gene
    def get_reverse_best_neighbors_by_gene(self, request):
        if isinstance(request, get_reverse_best_neighbors_by_geneRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_reverse_best_neighbors_by_gene", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_reverse_best_neighbors_by_geneResponse.typecode.ofwhat, pyclass=get_reverse_best_neighbors_by_geneResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_paralogs_by_gene
    def get_paralogs_by_gene(self, request):
        if isinstance(request, get_paralogs_by_geneRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_paralogs_by_gene", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_paralogs_by_geneResponse.typecode.ofwhat, pyclass=get_paralogs_by_geneResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_motifs_by_gene
    def get_motifs_by_gene(self, request):
        if isinstance(request, get_motifs_by_geneRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_motifs_by_gene", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_motifs_by_geneResponse.typecode.ofwhat, pyclass=get_motifs_by_geneResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_genes_by_motifs
    def get_genes_by_motifs(self, request):
        if isinstance(request, get_genes_by_motifsRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_genes_by_motifs", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_genes_by_motifsResponse.typecode.ofwhat, pyclass=get_genes_by_motifsResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_ko_by_gene
    def get_ko_by_gene(self, request):
        if isinstance(request, get_ko_by_geneRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_ko_by_gene", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_ko_by_geneResponse.typecode.ofwhat, pyclass=get_ko_by_geneResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_ko_by_ko_class
    def get_ko_by_ko_class(self, request):
        if isinstance(request, get_ko_by_ko_classRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_ko_by_ko_class", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_ko_by_ko_classResponse.typecode.ofwhat, pyclass=get_ko_by_ko_classResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_genes_by_ko
    def get_genes_by_ko(self, request):
        if isinstance(request, get_genes_by_koRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_genes_by_ko", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_genes_by_koResponse.typecode.ofwhat, pyclass=get_genes_by_koResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_genes_by_ko_class
    def get_genes_by_ko_class(self, request):
        if isinstance(request, get_genes_by_ko_classRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_genes_by_ko_class", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_genes_by_ko_classResponse.typecode.ofwhat, pyclass=get_genes_by_ko_classResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_elements_by_pathway
    def get_elements_by_pathway(self, request):
        if isinstance(request, get_elements_by_pathwayRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_elements_by_pathway", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_elements_by_pathwayResponse.typecode.ofwhat, pyclass=get_elements_by_pathwayResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_element_relations_by_pathway
    def get_element_relations_by_pathway(self, request):
        if isinstance(request, get_element_relations_by_pathwayRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_element_relations_by_pathway", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_element_relations_by_pathwayResponse.typecode.ofwhat, pyclass=get_element_relations_by_pathwayResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: color_pathway_by_elements
    def color_pathway_by_elements(self, request):
        if isinstance(request, color_pathway_by_elementsRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#color_pathway_by_elements", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=color_pathway_by_elementsResponse.typecode.ofwhat, pyclass=color_pathway_by_elementsResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_html_of_colored_pathway_by_elements
    def get_html_of_colored_pathway_by_elements(self, request):
        if isinstance(request, get_html_of_colored_pathway_by_elementsRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_html_of_colored_pathway_by_elements", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_html_of_colored_pathway_by_elementsResponse.typecode.ofwhat, pyclass=get_html_of_colored_pathway_by_elementsResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: mark_pathway_by_objects
    def mark_pathway_by_objects(self, request):
        if isinstance(request, mark_pathway_by_objectsRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#mark_pathway_by_objects", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=mark_pathway_by_objectsResponse.typecode.ofwhat, pyclass=mark_pathway_by_objectsResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: color_pathway_by_objects
    def color_pathway_by_objects(self, request):
        if isinstance(request, color_pathway_by_objectsRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#color_pathway_by_objects", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=color_pathway_by_objectsResponse.typecode.ofwhat, pyclass=color_pathway_by_objectsResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_html_of_marked_pathway_by_objects
    def get_html_of_marked_pathway_by_objects(self, request):
        if isinstance(request, get_html_of_marked_pathway_by_objectsRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_html_of_marked_pathway_by_objects", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_html_of_marked_pathway_by_objectsResponse.typecode.ofwhat, pyclass=get_html_of_marked_pathway_by_objectsResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_html_of_colored_pathway_by_objects
    def get_html_of_colored_pathway_by_objects(self, request):
        if isinstance(request, get_html_of_colored_pathway_by_objectsRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_html_of_colored_pathway_by_objects", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_html_of_colored_pathway_by_objectsResponse.typecode.ofwhat, pyclass=get_html_of_colored_pathway_by_objectsResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_genes_by_pathway
    def get_genes_by_pathway(self, request):
        if isinstance(request, get_genes_by_pathwayRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_genes_by_pathway", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_genes_by_pathwayResponse.typecode.ofwhat, pyclass=get_genes_by_pathwayResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_enzymes_by_pathway
    def get_enzymes_by_pathway(self, request):
        if isinstance(request, get_enzymes_by_pathwayRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_enzymes_by_pathway", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_enzymes_by_pathwayResponse.typecode.ofwhat, pyclass=get_enzymes_by_pathwayResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_reactions_by_pathway
    def get_reactions_by_pathway(self, request):
        if isinstance(request, get_reactions_by_pathwayRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_reactions_by_pathway", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_reactions_by_pathwayResponse.typecode.ofwhat, pyclass=get_reactions_by_pathwayResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_pathways_by_genes
    def get_pathways_by_genes(self, request):
        if isinstance(request, get_pathways_by_genesRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_pathways_by_genes", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_pathways_by_genesResponse.typecode.ofwhat, pyclass=get_pathways_by_genesResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_pathways_by_enzymes
    def get_pathways_by_enzymes(self, request):
        if isinstance(request, get_pathways_by_enzymesRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_pathways_by_enzymes", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_pathways_by_enzymesResponse.typecode.ofwhat, pyclass=get_pathways_by_enzymesResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_pathways_by_reactions
    def get_pathways_by_reactions(self, request):
        if isinstance(request, get_pathways_by_reactionsRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_pathways_by_reactions", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_pathways_by_reactionsResponse.typecode.ofwhat, pyclass=get_pathways_by_reactionsResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_linked_pathways
    def get_linked_pathways(self, request):
        if isinstance(request, get_linked_pathwaysRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_linked_pathways", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_linked_pathwaysResponse.typecode.ofwhat, pyclass=get_linked_pathwaysResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_genes_by_enzyme
    def get_genes_by_enzyme(self, request):
        if isinstance(request, get_genes_by_enzymeRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_genes_by_enzyme", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_genes_by_enzymeResponse.typecode.ofwhat, pyclass=get_genes_by_enzymeResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_enzymes_by_gene
    def get_enzymes_by_gene(self, request):
        if isinstance(request, get_enzymes_by_geneRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_enzymes_by_gene", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_enzymes_by_geneResponse.typecode.ofwhat, pyclass=get_enzymes_by_geneResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_enzymes_by_reaction
    def get_enzymes_by_reaction(self, request):
        if isinstance(request, get_enzymes_by_reactionRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_enzymes_by_reaction", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_enzymes_by_reactionResponse.typecode.ofwhat, pyclass=get_enzymes_by_reactionResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_reactions_by_enzyme
    def get_reactions_by_enzyme(self, request):
        if isinstance(request, get_reactions_by_enzymeRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_reactions_by_enzyme", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_reactions_by_enzymeResponse.typecode.ofwhat, pyclass=get_reactions_by_enzymeResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_genes_by_organism
    def get_genes_by_organism(self, request):
        if isinstance(request, get_genes_by_organismRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_genes_by_organism", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_genes_by_organismResponse.typecode.ofwhat, pyclass=get_genes_by_organismResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_number_of_genes_by_organism
    def get_number_of_genes_by_organism(self, request):
        if isinstance(request, get_number_of_genes_by_organismRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_number_of_genes_by_organism", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_number_of_genes_by_organismResponse.typecode.ofwhat, pyclass=get_number_of_genes_by_organismResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_reactions_by_glycan
    def get_reactions_by_glycan(self, request):
        if isinstance(request, get_reactions_by_glycanRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_reactions_by_glycan", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_reactions_by_glycanResponse.typecode.ofwhat, pyclass=get_reactions_by_glycanResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_reactions_by_compound
    def get_reactions_by_compound(self, request):
        if isinstance(request, get_reactions_by_compoundRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_reactions_by_compound", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_reactions_by_compoundResponse.typecode.ofwhat, pyclass=get_reactions_by_compoundResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_enzymes_by_glycan
    def get_enzymes_by_glycan(self, request):
        if isinstance(request, get_enzymes_by_glycanRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_enzymes_by_glycan", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_enzymes_by_glycanResponse.typecode.ofwhat, pyclass=get_enzymes_by_glycanResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_enzymes_by_compound
    def get_enzymes_by_compound(self, request):
        if isinstance(request, get_enzymes_by_compoundRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_enzymes_by_compound", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_enzymes_by_compoundResponse.typecode.ofwhat, pyclass=get_enzymes_by_compoundResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_pathways_by_compounds
    def get_pathways_by_compounds(self, request):
        if isinstance(request, get_pathways_by_compoundsRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_pathways_by_compounds", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_pathways_by_compoundsResponse.typecode.ofwhat, pyclass=get_pathways_by_compoundsResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_pathways_by_glycans
    def get_pathways_by_glycans(self, request):
        if isinstance(request, get_pathways_by_glycansRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_pathways_by_glycans", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_pathways_by_glycansResponse.typecode.ofwhat, pyclass=get_pathways_by_glycansResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_compounds_by_pathway
    def get_compounds_by_pathway(self, request):
        if isinstance(request, get_compounds_by_pathwayRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_compounds_by_pathway", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_compounds_by_pathwayResponse.typecode.ofwhat, pyclass=get_compounds_by_pathwayResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_glycans_by_pathway
    def get_glycans_by_pathway(self, request):
        if isinstance(request, get_glycans_by_pathwayRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_glycans_by_pathway", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_glycans_by_pathwayResponse.typecode.ofwhat, pyclass=get_glycans_by_pathwayResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_compounds_by_reaction
    def get_compounds_by_reaction(self, request):
        if isinstance(request, get_compounds_by_reactionRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_compounds_by_reaction", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_compounds_by_reactionResponse.typecode.ofwhat, pyclass=get_compounds_by_reactionResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_glycans_by_reaction
    def get_glycans_by_reaction(self, request):
        if isinstance(request, get_glycans_by_reactionRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_glycans_by_reaction", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_glycans_by_reactionResponse.typecode.ofwhat, pyclass=get_glycans_by_reactionResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_compounds_by_enzyme
    def get_compounds_by_enzyme(self, request):
        if isinstance(request, get_compounds_by_enzymeRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_compounds_by_enzyme", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_compounds_by_enzymeResponse.typecode.ofwhat, pyclass=get_compounds_by_enzymeResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_glycans_by_enzyme
    def get_glycans_by_enzyme(self, request):
        if isinstance(request, get_glycans_by_enzymeRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_glycans_by_enzyme", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_glycans_by_enzymeResponse.typecode.ofwhat, pyclass=get_glycans_by_enzymeResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: convert_mol_to_kcf
    def convert_mol_to_kcf(self, request):
        if isinstance(request, convert_mol_to_kcfRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#convert_mol_to_kcf", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=convert_mol_to_kcfResponse.typecode.ofwhat, pyclass=convert_mol_to_kcfResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_kos_by_pathway
    def get_kos_by_pathway(self, request):
        if isinstance(request, get_kos_by_pathwayRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_kos_by_pathway", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_kos_by_pathwayResponse.typecode.ofwhat, pyclass=get_kos_by_pathwayResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_pathways_by_kos
    def get_pathways_by_kos(self, request):
        if isinstance(request, get_pathways_by_kosRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_pathways_by_kos", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_pathways_by_kosResponse.typecode.ofwhat, pyclass=get_pathways_by_kosResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: search_compounds_by_name
    def search_compounds_by_name(self, request):
        if isinstance(request, search_compounds_by_nameRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#search_compounds_by_name", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=search_compounds_by_nameResponse.typecode.ofwhat, pyclass=search_compounds_by_nameResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: search_glycans_by_name
    def search_glycans_by_name(self, request):
        if isinstance(request, search_glycans_by_nameRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#search_glycans_by_name", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=search_glycans_by_nameResponse.typecode.ofwhat, pyclass=search_glycans_by_nameResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: search_compounds_by_composition
    def search_compounds_by_composition(self, request):
        if isinstance(request, search_compounds_by_compositionRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#search_compounds_by_composition", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=search_compounds_by_compositionResponse.typecode.ofwhat, pyclass=search_compounds_by_compositionResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: search_compounds_by_mass
    def search_compounds_by_mass(self, request):
        if isinstance(request, search_compounds_by_massRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#search_compounds_by_mass", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=search_compounds_by_massResponse.typecode.ofwhat, pyclass=search_compounds_by_massResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: search_glycans_by_mass
    def search_glycans_by_mass(self, request):
        if isinstance(request, search_glycans_by_massRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#search_glycans_by_mass", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=search_glycans_by_massResponse.typecode.ofwhat, pyclass=search_glycans_by_massResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: search_glycans_by_composition
    def search_glycans_by_composition(self, request):
        if isinstance(request, search_glycans_by_compositionRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#search_glycans_by_composition", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=search_glycans_by_compositionResponse.typecode.ofwhat, pyclass=search_glycans_by_compositionResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: search_compounds_by_subcomp
    def search_compounds_by_subcomp(self, request):
        if isinstance(request, search_compounds_by_subcompRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#search_compounds_by_subcomp", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=search_compounds_by_subcompResponse.typecode.ofwhat, pyclass=search_compounds_by_subcompResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: search_glycans_by_kcam
    def search_glycans_by_kcam(self, request):
        if isinstance(request, search_glycans_by_kcamRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#search_glycans_by_kcam", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=search_glycans_by_kcamResponse.typecode.ofwhat, pyclass=search_glycans_by_kcamResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_linkdb_between_databases
    def get_linkdb_between_databases(self, request):
        if isinstance(request, get_linkdb_between_databasesRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_linkdb_between_databases", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_linkdb_between_databasesResponse.typecode.ofwhat, pyclass=get_linkdb_between_databasesResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: search_drugs_by_name
    def search_drugs_by_name(self, request):
        if isinstance(request, search_drugs_by_nameRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#search_drugs_by_name", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=search_drugs_by_nameResponse.typecode.ofwhat, pyclass=search_drugs_by_nameResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: search_drugs_by_composition
    def search_drugs_by_composition(self, request):
        if isinstance(request, search_drugs_by_compositionRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#search_drugs_by_composition", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=search_drugs_by_compositionResponse.typecode.ofwhat, pyclass=search_drugs_by_compositionResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: search_drugs_by_mass
    def search_drugs_by_mass(self, request):
        if isinstance(request, search_drugs_by_massRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#search_drugs_by_mass", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=search_drugs_by_massResponse.typecode.ofwhat, pyclass=search_drugs_by_massResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: search_drugs_by_subcomp
    def search_drugs_by_subcomp(self, request):
        if isinstance(request, search_drugs_by_subcompRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#search_drugs_by_subcomp", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=search_drugs_by_subcompResponse.typecode.ofwhat, pyclass=search_drugs_by_subcompResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_references_by_pathway
    def get_references_by_pathway(self, request):
        if isinstance(request, get_references_by_pathwayRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_references_by_pathway", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_references_by_pathwayResponse.typecode.ofwhat, pyclass=get_references_by_pathwayResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_drugs_by_pathway
    def get_drugs_by_pathway(self, request):
        if isinstance(request, get_drugs_by_pathwayRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_drugs_by_pathway", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_drugs_by_pathwayResponse.typecode.ofwhat, pyclass=get_drugs_by_pathwayResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: get_pathways_by_drugs
    def get_pathways_by_drugs(self, request):
        if isinstance(request, get_pathways_by_drugsRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="SOAP/KEGG#get_pathways_by_drugs", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=get_pathways_by_drugsResponse.typecode.ofwhat, pyclass=get_pathways_by_drugsResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

class list_databasesRequest:
    def __init__(self):
        return
list_databasesRequest.typecode = Struct(pname=("SOAP/KEGG","list_databases"), ofwhat=[], pyclass=list_databasesRequest, encoded="SOAP/KEGG")

class list_databasesResponse:
    def __init__(self):
        self._return = None
        return
list_databasesResponse.typecode = Struct(pname=("SOAP/KEGG","list_databasesResponse"), ofwhat=[ns0.ArrayOfDefinition_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=list_databasesResponse, encoded="SOAP/KEGG")

class list_organismsRequest:
    def __init__(self):
        return
list_organismsRequest.typecode = Struct(pname=("SOAP/KEGG","list_organisms"), ofwhat=[], pyclass=list_organismsRequest, encoded="SOAP/KEGG")

class list_organismsResponse:
    def __init__(self):
        self._return = None
        return
list_organismsResponse.typecode = Struct(pname=("SOAP/KEGG","list_organismsResponse"), ofwhat=[ns0.ArrayOfDefinition_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=list_organismsResponse, encoded="SOAP/KEGG")

class list_pathwaysRequest:
    def __init__(self):
        self._org = None
        return
list_pathwaysRequest.typecode = Struct(pname=("SOAP/KEGG","list_pathways"), ofwhat=[ZSI.TC.String(pname="org", aname="_org", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=list_pathwaysRequest, encoded="SOAP/KEGG")

class list_pathwaysResponse:
    def __init__(self):
        self._return = None
        return
list_pathwaysResponse.typecode = Struct(pname=("SOAP/KEGG","list_pathwaysResponse"), ofwhat=[ns0.ArrayOfDefinition_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=list_pathwaysResponse, encoded="SOAP/KEGG")

class list_ko_classesRequest:
    def __init__(self):
        self._class_id = None
        return
list_ko_classesRequest.typecode = Struct(pname=("SOAP/KEGG","list_ko_classes"), ofwhat=[ZSI.TC.String(pname="class_id", aname="_class_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=list_ko_classesRequest, encoded="SOAP/KEGG")

class list_ko_classesResponse:
    def __init__(self):
        self._return = None
        return
list_ko_classesResponse.typecode = Struct(pname=("SOAP/KEGG","list_ko_classesResponse"), ofwhat=[ns0.ArrayOfDefinition_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=list_ko_classesResponse, encoded="SOAP/KEGG")

class binfoRequest:
    def __init__(self):
        self._db = None
        return
binfoRequest.typecode = Struct(pname=("SOAP/KEGG","binfo"), ofwhat=[ZSI.TC.String(pname="db", aname="_db", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=binfoRequest, encoded="SOAP/KEGG")

class binfoResponse:
    def __init__(self):
        self._return = None
        return
binfoResponse.typecode = Struct(pname=("SOAP/KEGG","binfoResponse"), ofwhat=[ZSI.TC.String(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=binfoResponse, encoded="SOAP/KEGG")

class bgetRequest:
    def __init__(self):
        self._string = None
        return
bgetRequest.typecode = Struct(pname=("SOAP/KEGG","bget"), ofwhat=[ZSI.TC.String(pname="string", aname="_string", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=bgetRequest, encoded="SOAP/KEGG")

class bgetResponse:
    def __init__(self):
        self._return = None
        return
bgetResponse.typecode = Struct(pname=("SOAP/KEGG","bgetResponse"), ofwhat=[ZSI.TC.String(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=bgetResponse, encoded="SOAP/KEGG")

class bfindRequest:
    def __init__(self):
        self._string = None
        return
bfindRequest.typecode = Struct(pname=("SOAP/KEGG","bfind"), ofwhat=[ZSI.TC.String(pname="string", aname="_string", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=bfindRequest, encoded="SOAP/KEGG")

class bfindResponse:
    def __init__(self):
        self._return = None
        return
bfindResponse.typecode = Struct(pname=("SOAP/KEGG","bfindResponse"), ofwhat=[ZSI.TC.String(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=bfindResponse, encoded="SOAP/KEGG")

class btitRequest:
    def __init__(self):
        self._string = None
        return
btitRequest.typecode = Struct(pname=("SOAP/KEGG","btit"), ofwhat=[ZSI.TC.String(pname="string", aname="_string", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=btitRequest, encoded="SOAP/KEGG")

class btitResponse:
    def __init__(self):
        self._return = None
        return
btitResponse.typecode = Struct(pname=("SOAP/KEGG","btitResponse"), ofwhat=[ZSI.TC.String(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=btitResponse, encoded="SOAP/KEGG")

class bconvRequest:
    def __init__(self):
        self._string = None
        return
bconvRequest.typecode = Struct(pname=("SOAP/KEGG","bconv"), ofwhat=[ZSI.TC.String(pname="string", aname="_string", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=bconvRequest, encoded="SOAP/KEGG")

class bconvResponse:
    def __init__(self):
        self._return = None
        return
bconvResponse.typecode = Struct(pname=("SOAP/KEGG","bconvResponse"), ofwhat=[ZSI.TC.String(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=bconvResponse, encoded="SOAP/KEGG")

class get_linkdb_by_entryRequest:
    def __init__(self):
        self._entry_id = None
        self._db = None
        self._offset = None
        self._limit = None
        return
get_linkdb_by_entryRequest.typecode = Struct(pname=("SOAP/KEGG","get_linkdb_by_entry"), ofwhat=[ZSI.TC.String(pname="entry_id", aname="_entry_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.String(pname="db", aname="_db", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TCnumbers.Iint(pname="offset", aname="_offset", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TCnumbers.Iint(pname="limit", aname="_limit", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_linkdb_by_entryRequest, encoded="SOAP/KEGG")

class get_linkdb_by_entryResponse:
    def __init__(self):
        self._return = None
        return
get_linkdb_by_entryResponse.typecode = Struct(pname=("SOAP/KEGG","get_linkdb_by_entryResponse"), ofwhat=[ns0.ArrayOfLinkDBRelation_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_linkdb_by_entryResponse, encoded="SOAP/KEGG")

class get_best_neighbors_by_geneRequest:
    def __init__(self):
        self._genes_id = None
        self._offset = None
        self._limit = None
        return
get_best_neighbors_by_geneRequest.typecode = Struct(pname=("SOAP/KEGG","get_best_neighbors_by_gene"), ofwhat=[ZSI.TC.String(pname="genes_id", aname="_genes_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TCnumbers.Iint(pname="offset", aname="_offset", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TCnumbers.Iint(pname="limit", aname="_limit", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_best_neighbors_by_geneRequest, encoded="SOAP/KEGG")

class get_best_neighbors_by_geneResponse:
    def __init__(self):
        self._return = None
        return
get_best_neighbors_by_geneResponse.typecode = Struct(pname=("SOAP/KEGG","get_best_neighbors_by_geneResponse"), ofwhat=[ns0.ArrayOfSSDBRelation_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_best_neighbors_by_geneResponse, encoded="SOAP/KEGG")

class get_best_best_neighbors_by_geneRequest:
    def __init__(self):
        self._genes_id = None
        self._offset = None
        self._limit = None
        return
get_best_best_neighbors_by_geneRequest.typecode = Struct(pname=("SOAP/KEGG","get_best_best_neighbors_by_gene"), ofwhat=[ZSI.TC.String(pname="genes_id", aname="_genes_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TCnumbers.Iint(pname="offset", aname="_offset", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TCnumbers.Iint(pname="limit", aname="_limit", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_best_best_neighbors_by_geneRequest, encoded="SOAP/KEGG")

class get_best_best_neighbors_by_geneResponse:
    def __init__(self):
        self._return = None
        return
get_best_best_neighbors_by_geneResponse.typecode = Struct(pname=("SOAP/KEGG","get_best_best_neighbors_by_geneResponse"), ofwhat=[ns0.ArrayOfSSDBRelation_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_best_best_neighbors_by_geneResponse, encoded="SOAP/KEGG")

class get_reverse_best_neighbors_by_geneRequest:
    def __init__(self):
        self._genes_id = None
        self._offset = None
        self._limit = None
        return
get_reverse_best_neighbors_by_geneRequest.typecode = Struct(pname=("SOAP/KEGG","get_reverse_best_neighbors_by_gene"), ofwhat=[ZSI.TC.String(pname="genes_id", aname="_genes_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TCnumbers.Iint(pname="offset", aname="_offset", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TCnumbers.Iint(pname="limit", aname="_limit", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_reverse_best_neighbors_by_geneRequest, encoded="SOAP/KEGG")

class get_reverse_best_neighbors_by_geneResponse:
    def __init__(self):
        self._return = None
        return
get_reverse_best_neighbors_by_geneResponse.typecode = Struct(pname=("SOAP/KEGG","get_reverse_best_neighbors_by_geneResponse"), ofwhat=[ns0.ArrayOfSSDBRelation_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_reverse_best_neighbors_by_geneResponse, encoded="SOAP/KEGG")

class get_paralogs_by_geneRequest:
    def __init__(self):
        self._genes_id = None
        self._offset = None
        self._limit = None
        return
get_paralogs_by_geneRequest.typecode = Struct(pname=("SOAP/KEGG","get_paralogs_by_gene"), ofwhat=[ZSI.TC.String(pname="genes_id", aname="_genes_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TCnumbers.Iint(pname="offset", aname="_offset", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TCnumbers.Iint(pname="limit", aname="_limit", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_paralogs_by_geneRequest, encoded="SOAP/KEGG")

class get_paralogs_by_geneResponse:
    def __init__(self):
        self._return = None
        return
get_paralogs_by_geneResponse.typecode = Struct(pname=("SOAP/KEGG","get_paralogs_by_geneResponse"), ofwhat=[ns0.ArrayOfSSDBRelation_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_paralogs_by_geneResponse, encoded="SOAP/KEGG")

class get_motifs_by_geneRequest:
    def __init__(self):
        self._genes_id = None
        self._db = None
        return
get_motifs_by_geneRequest.typecode = Struct(pname=("SOAP/KEGG","get_motifs_by_gene"), ofwhat=[ZSI.TC.String(pname="genes_id", aname="_genes_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.String(pname="db", aname="_db", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_motifs_by_geneRequest, encoded="SOAP/KEGG")

class get_motifs_by_geneResponse:
    def __init__(self):
        self._return = None
        return
get_motifs_by_geneResponse.typecode = Struct(pname=("SOAP/KEGG","get_motifs_by_geneResponse"), ofwhat=[ns0.ArrayOfMotifResult_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_motifs_by_geneResponse, encoded="SOAP/KEGG")

class get_genes_by_motifsRequest:
    def __init__(self):
        self._motif_id_list = None
        self._offset = None
        self._limit = None
        return
get_genes_by_motifsRequest.typecode = Struct(pname=("SOAP/KEGG","get_genes_by_motifs"), ofwhat=[ns0.ArrayOfstring_Def(pname="motif_id_list", aname="_motif_id_list", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TCnumbers.Iint(pname="offset", aname="_offset", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TCnumbers.Iint(pname="limit", aname="_limit", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_genes_by_motifsRequest, encoded="SOAP/KEGG")

class get_genes_by_motifsResponse:
    def __init__(self):
        self._return = None
        return
get_genes_by_motifsResponse.typecode = Struct(pname=("SOAP/KEGG","get_genes_by_motifsResponse"), ofwhat=[ns0.ArrayOfDefinition_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_genes_by_motifsResponse, encoded="SOAP/KEGG")

class get_ko_by_geneRequest:
    def __init__(self):
        self._genes_id = None
        return
get_ko_by_geneRequest.typecode = Struct(pname=("SOAP/KEGG","get_ko_by_gene"), ofwhat=[ZSI.TC.String(pname="genes_id", aname="_genes_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_ko_by_geneRequest, encoded="SOAP/KEGG")

class get_ko_by_geneResponse:
    def __init__(self):
        self._return = None
        return
get_ko_by_geneResponse.typecode = Struct(pname=("SOAP/KEGG","get_ko_by_geneResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_ko_by_geneResponse, encoded="SOAP/KEGG")

class get_ko_by_ko_classRequest:
    def __init__(self):
        self._class_id = None
        return
get_ko_by_ko_classRequest.typecode = Struct(pname=("SOAP/KEGG","get_ko_by_ko_class"), ofwhat=[ZSI.TC.String(pname="class_id", aname="_class_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_ko_by_ko_classRequest, encoded="SOAP/KEGG")

class get_ko_by_ko_classResponse:
    def __init__(self):
        self._return = None
        return
get_ko_by_ko_classResponse.typecode = Struct(pname=("SOAP/KEGG","get_ko_by_ko_classResponse"), ofwhat=[ns0.ArrayOfDefinition_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_ko_by_ko_classResponse, encoded="SOAP/KEGG")

class get_genes_by_koRequest:
    def __init__(self):
        self._ko_id = None
        self._org = None
        return
get_genes_by_koRequest.typecode = Struct(pname=("SOAP/KEGG","get_genes_by_ko"), ofwhat=[ZSI.TC.String(pname="ko_id", aname="_ko_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.String(pname="org", aname="_org", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_genes_by_koRequest, encoded="SOAP/KEGG")

class get_genes_by_koResponse:
    def __init__(self):
        self._return = None
        return
get_genes_by_koResponse.typecode = Struct(pname=("SOAP/KEGG","get_genes_by_koResponse"), ofwhat=[ns0.ArrayOfDefinition_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_genes_by_koResponse, encoded="SOAP/KEGG")

class get_genes_by_ko_classRequest:
    def __init__(self):
        self._class_id = None
        self._org = None
        self._offset = None
        self._limit = None
        return
get_genes_by_ko_classRequest.typecode = Struct(pname=("SOAP/KEGG","get_genes_by_ko_class"), ofwhat=[ZSI.TC.String(pname="class_id", aname="_class_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.String(pname="org", aname="_org", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TCnumbers.Iint(pname="offset", aname="_offset", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TCnumbers.Iint(pname="limit", aname="_limit", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_genes_by_ko_classRequest, encoded="SOAP/KEGG")

class get_genes_by_ko_classResponse:
    def __init__(self):
        self._return = None
        return
get_genes_by_ko_classResponse.typecode = Struct(pname=("SOAP/KEGG","get_genes_by_ko_classResponse"), ofwhat=[ns0.ArrayOfDefinition_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_genes_by_ko_classResponse, encoded="SOAP/KEGG")

class get_elements_by_pathwayRequest:
    def __init__(self):
        self._pathway_id = None
        return
get_elements_by_pathwayRequest.typecode = Struct(pname=("SOAP/KEGG","get_elements_by_pathway"), ofwhat=[ZSI.TC.String(pname="pathway_id", aname="_pathway_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_elements_by_pathwayRequest, encoded="SOAP/KEGG")

class get_elements_by_pathwayResponse:
    def __init__(self):
        self._return = None
        return
get_elements_by_pathwayResponse.typecode = Struct(pname=("SOAP/KEGG","get_elements_by_pathwayResponse"), ofwhat=[ns0.ArrayOfPathwayElement_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_elements_by_pathwayResponse, encoded="SOAP/KEGG")

class get_element_relations_by_pathwayRequest:
    def __init__(self):
        self._pathway_id = None
        return
get_element_relations_by_pathwayRequest.typecode = Struct(pname=("SOAP/KEGG","get_element_relations_by_pathway"), ofwhat=[ZSI.TC.String(pname="pathway_id", aname="_pathway_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_element_relations_by_pathwayRequest, encoded="SOAP/KEGG")

class get_element_relations_by_pathwayResponse:
    def __init__(self):
        self._return = None
        return
get_element_relations_by_pathwayResponse.typecode = Struct(pname=("SOAP/KEGG","get_element_relations_by_pathwayResponse"), ofwhat=[ns0.ArrayOfPathwayElementRelation_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_element_relations_by_pathwayResponse, encoded="SOAP/KEGG")

class color_pathway_by_elementsRequest:
    def __init__(self):
        self._pathway_id = None
        self._element_list = None
        self._fg_color_list = None
        self._bg_color_list = None
        return
color_pathway_by_elementsRequest.typecode = Struct(pname=("SOAP/KEGG","color_pathway_by_elements"), ofwhat=[ZSI.TC.String(pname="pathway_id", aname="_pathway_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ns0.ArrayOfint_Def(pname="element_list", aname="_element_list", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ns0.ArrayOfstring_Def(pname="fg_color_list", aname="_fg_color_list", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ns0.ArrayOfstring_Def(pname="bg_color_list", aname="_bg_color_list", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=color_pathway_by_elementsRequest, encoded="SOAP/KEGG")

class color_pathway_by_elementsResponse:
    def __init__(self):
        self._return = None
        return
color_pathway_by_elementsResponse.typecode = Struct(pname=("SOAP/KEGG","color_pathway_by_elementsResponse"), ofwhat=[ZSI.TC.String(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=color_pathway_by_elementsResponse, encoded="SOAP/KEGG")

class get_html_of_colored_pathway_by_elementsRequest:
    def __init__(self):
        self._pathway_id = None
        self._element_list = None
        self._fg_color_list = None
        self._bg_color_list = None
        return
get_html_of_colored_pathway_by_elementsRequest.typecode = Struct(pname=("SOAP/KEGG","get_html_of_colored_pathway_by_elements"), ofwhat=[ZSI.TC.String(pname="pathway_id", aname="_pathway_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ns0.ArrayOfint_Def(pname="element_list", aname="_element_list", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ns0.ArrayOfstring_Def(pname="fg_color_list", aname="_fg_color_list", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ns0.ArrayOfstring_Def(pname="bg_color_list", aname="_bg_color_list", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_html_of_colored_pathway_by_elementsRequest, encoded="SOAP/KEGG")

class get_html_of_colored_pathway_by_elementsResponse:
    def __init__(self):
        self._return = None
        return
get_html_of_colored_pathway_by_elementsResponse.typecode = Struct(pname=("SOAP/KEGG","get_html_of_colored_pathway_by_elementsResponse"), ofwhat=[ZSI.TC.String(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_html_of_colored_pathway_by_elementsResponse, encoded="SOAP/KEGG")

class mark_pathway_by_objectsRequest:
    def __init__(self):
        self._pathway_id = None
        self._object_id_list = None
        return
mark_pathway_by_objectsRequest.typecode = Struct(pname=("SOAP/KEGG","mark_pathway_by_objects"), ofwhat=[ZSI.TC.String(pname="pathway_id", aname="_pathway_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ns0.ArrayOfstring_Def(pname="object_id_list", aname="_object_id_list", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=mark_pathway_by_objectsRequest, encoded="SOAP/KEGG")

class mark_pathway_by_objectsResponse:
    def __init__(self):
        self._return = None
        return
mark_pathway_by_objectsResponse.typecode = Struct(pname=("SOAP/KEGG","mark_pathway_by_objectsResponse"), ofwhat=[ZSI.TC.String(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=mark_pathway_by_objectsResponse, encoded="SOAP/KEGG")

class color_pathway_by_objectsRequest:
    def __init__(self):
        self._pathway_id = None
        self._object_id_list = None
        self._fg_color_list = None
        self._bg_color_list = None
        return
color_pathway_by_objectsRequest.typecode = Struct(pname=("SOAP/KEGG","color_pathway_by_objects"), ofwhat=[ZSI.TC.String(pname="pathway_id", aname="_pathway_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ns0.ArrayOfstring_Def(pname="object_id_list", aname="_object_id_list", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ns0.ArrayOfstring_Def(pname="fg_color_list", aname="_fg_color_list", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ns0.ArrayOfstring_Def(pname="bg_color_list", aname="_bg_color_list", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=color_pathway_by_objectsRequest, encoded="SOAP/KEGG")

class color_pathway_by_objectsResponse:
    def __init__(self):
        self._return = None
        return
color_pathway_by_objectsResponse.typecode = Struct(pname=("SOAP/KEGG","color_pathway_by_objectsResponse"), ofwhat=[ZSI.TC.String(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=color_pathway_by_objectsResponse, encoded="SOAP/KEGG")

class get_html_of_marked_pathway_by_objectsRequest:
    def __init__(self):
        self._pathway_id = None
        self._object_id_list = None
        return
get_html_of_marked_pathway_by_objectsRequest.typecode = Struct(pname=("SOAP/KEGG","get_html_of_marked_pathway_by_objects"), ofwhat=[ZSI.TC.String(pname="pathway_id", aname="_pathway_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ns0.ArrayOfstring_Def(pname="object_id_list", aname="_object_id_list", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_html_of_marked_pathway_by_objectsRequest, encoded="SOAP/KEGG")

class get_html_of_marked_pathway_by_objectsResponse:
    def __init__(self):
        self._return = None
        return
get_html_of_marked_pathway_by_objectsResponse.typecode = Struct(pname=("SOAP/KEGG","get_html_of_marked_pathway_by_objectsResponse"), ofwhat=[ZSI.TC.String(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_html_of_marked_pathway_by_objectsResponse, encoded="SOAP/KEGG")

class get_html_of_colored_pathway_by_objectsRequest:
    def __init__(self):
        self._pathway_id = None
        self._object_id_list = None
        self._fg_color_list = None
        self._bg_color_list = None
        return
get_html_of_colored_pathway_by_objectsRequest.typecode = Struct(pname=("SOAP/KEGG","get_html_of_colored_pathway_by_objects"), ofwhat=[ZSI.TC.String(pname="pathway_id", aname="_pathway_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ns0.ArrayOfstring_Def(pname="object_id_list", aname="_object_id_list", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ns0.ArrayOfstring_Def(pname="fg_color_list", aname="_fg_color_list", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ns0.ArrayOfstring_Def(pname="bg_color_list", aname="_bg_color_list", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_html_of_colored_pathway_by_objectsRequest, encoded="SOAP/KEGG")

class get_html_of_colored_pathway_by_objectsResponse:
    def __init__(self):
        self._return = None
        return
get_html_of_colored_pathway_by_objectsResponse.typecode = Struct(pname=("SOAP/KEGG","get_html_of_colored_pathway_by_objectsResponse"), ofwhat=[ZSI.TC.String(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_html_of_colored_pathway_by_objectsResponse, encoded="SOAP/KEGG")

class get_genes_by_pathwayRequest:
    def __init__(self):
        self._pathway_id = None
        return
get_genes_by_pathwayRequest.typecode = Struct(pname=("SOAP/KEGG","get_genes_by_pathway"), ofwhat=[ZSI.TC.String(pname="pathway_id", aname="_pathway_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_genes_by_pathwayRequest, encoded="SOAP/KEGG")

class get_genes_by_pathwayResponse:
    def __init__(self):
        self._return = None
        return
get_genes_by_pathwayResponse.typecode = Struct(pname=("SOAP/KEGG","get_genes_by_pathwayResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_genes_by_pathwayResponse, encoded="SOAP/KEGG")

class get_enzymes_by_pathwayRequest:
    def __init__(self):
        self._pathway_id = None
        return
get_enzymes_by_pathwayRequest.typecode = Struct(pname=("SOAP/KEGG","get_enzymes_by_pathway"), ofwhat=[ZSI.TC.String(pname="pathway_id", aname="_pathway_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_enzymes_by_pathwayRequest, encoded="SOAP/KEGG")

class get_enzymes_by_pathwayResponse:
    def __init__(self):
        self._return = None
        return
get_enzymes_by_pathwayResponse.typecode = Struct(pname=("SOAP/KEGG","get_enzymes_by_pathwayResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_enzymes_by_pathwayResponse, encoded="SOAP/KEGG")

class get_reactions_by_pathwayRequest:
    def __init__(self):
        self._pathway_id = None
        return
get_reactions_by_pathwayRequest.typecode = Struct(pname=("SOAP/KEGG","get_reactions_by_pathway"), ofwhat=[ZSI.TC.String(pname="pathway_id", aname="_pathway_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_reactions_by_pathwayRequest, encoded="SOAP/KEGG")

class get_reactions_by_pathwayResponse:
    def __init__(self):
        self._return = None
        return
get_reactions_by_pathwayResponse.typecode = Struct(pname=("SOAP/KEGG","get_reactions_by_pathwayResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_reactions_by_pathwayResponse, encoded="SOAP/KEGG")

class get_pathways_by_genesRequest:
    def __init__(self):
        self._genes_id_list = None
        return
get_pathways_by_genesRequest.typecode = Struct(pname=("SOAP/KEGG","get_pathways_by_genes"), ofwhat=[ns0.ArrayOfstring_Def(pname="genes_id_list", aname="_genes_id_list", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_pathways_by_genesRequest, encoded="SOAP/KEGG")

class get_pathways_by_genesResponse:
    def __init__(self):
        self._return = None
        return
get_pathways_by_genesResponse.typecode = Struct(pname=("SOAP/KEGG","get_pathways_by_genesResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_pathways_by_genesResponse, encoded="SOAP/KEGG")

class get_pathways_by_enzymesRequest:
    def __init__(self):
        self._enzyme_id_list = None
        return
get_pathways_by_enzymesRequest.typecode = Struct(pname=("SOAP/KEGG","get_pathways_by_enzymes"), ofwhat=[ns0.ArrayOfstring_Def(pname="enzyme_id_list", aname="_enzyme_id_list", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_pathways_by_enzymesRequest, encoded="SOAP/KEGG")

class get_pathways_by_enzymesResponse:
    def __init__(self):
        self._return = None
        return
get_pathways_by_enzymesResponse.typecode = Struct(pname=("SOAP/KEGG","get_pathways_by_enzymesResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_pathways_by_enzymesResponse, encoded="SOAP/KEGG")

class get_pathways_by_reactionsRequest:
    def __init__(self):
        self._reaction_id_list = None
        return
get_pathways_by_reactionsRequest.typecode = Struct(pname=("SOAP/KEGG","get_pathways_by_reactions"), ofwhat=[ns0.ArrayOfstring_Def(pname="reaction_id_list", aname="_reaction_id_list", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_pathways_by_reactionsRequest, encoded="SOAP/KEGG")

class get_pathways_by_reactionsResponse:
    def __init__(self):
        self._return = None
        return
get_pathways_by_reactionsResponse.typecode = Struct(pname=("SOAP/KEGG","get_pathways_by_reactionsResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_pathways_by_reactionsResponse, encoded="SOAP/KEGG")

class get_linked_pathwaysRequest:
    def __init__(self):
        self._pathway_id = None
        return
get_linked_pathwaysRequest.typecode = Struct(pname=("SOAP/KEGG","get_linked_pathways"), ofwhat=[ZSI.TC.String(pname="pathway_id", aname="_pathway_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_linked_pathwaysRequest, encoded="SOAP/KEGG")

class get_linked_pathwaysResponse:
    def __init__(self):
        self._return = None
        return
get_linked_pathwaysResponse.typecode = Struct(pname=("SOAP/KEGG","get_linked_pathwaysResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_linked_pathwaysResponse, encoded="SOAP/KEGG")

class get_genes_by_enzymeRequest:
    def __init__(self):
        self._enzyme_id = None
        self._org = None
        return
get_genes_by_enzymeRequest.typecode = Struct(pname=("SOAP/KEGG","get_genes_by_enzyme"), ofwhat=[ZSI.TC.String(pname="enzyme_id", aname="_enzyme_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.String(pname="org", aname="_org", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_genes_by_enzymeRequest, encoded="SOAP/KEGG")

class get_genes_by_enzymeResponse:
    def __init__(self):
        self._return = None
        return
get_genes_by_enzymeResponse.typecode = Struct(pname=("SOAP/KEGG","get_genes_by_enzymeResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_genes_by_enzymeResponse, encoded="SOAP/KEGG")

class get_enzymes_by_geneRequest:
    def __init__(self):
        self._genes_id = None
        return
get_enzymes_by_geneRequest.typecode = Struct(pname=("SOAP/KEGG","get_enzymes_by_gene"), ofwhat=[ZSI.TC.String(pname="genes_id", aname="_genes_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_enzymes_by_geneRequest, encoded="SOAP/KEGG")

class get_enzymes_by_geneResponse:
    def __init__(self):
        self._return = None
        return
get_enzymes_by_geneResponse.typecode = Struct(pname=("SOAP/KEGG","get_enzymes_by_geneResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_enzymes_by_geneResponse, encoded="SOAP/KEGG")

class get_enzymes_by_reactionRequest:
    def __init__(self):
        self._reaction_id = None
        return
get_enzymes_by_reactionRequest.typecode = Struct(pname=("SOAP/KEGG","get_enzymes_by_reaction"), ofwhat=[ZSI.TC.String(pname="reaction_id", aname="_reaction_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_enzymes_by_reactionRequest, encoded="SOAP/KEGG")

class get_enzymes_by_reactionResponse:
    def __init__(self):
        self._return = None
        return
get_enzymes_by_reactionResponse.typecode = Struct(pname=("SOAP/KEGG","get_enzymes_by_reactionResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_enzymes_by_reactionResponse, encoded="SOAP/KEGG")

class get_reactions_by_enzymeRequest:
    def __init__(self):
        self._enzyme_id = None
        return
get_reactions_by_enzymeRequest.typecode = Struct(pname=("SOAP/KEGG","get_reactions_by_enzyme"), ofwhat=[ZSI.TC.String(pname="enzyme_id", aname="_enzyme_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_reactions_by_enzymeRequest, encoded="SOAP/KEGG")

class get_reactions_by_enzymeResponse:
    def __init__(self):
        self._return = None
        return
get_reactions_by_enzymeResponse.typecode = Struct(pname=("SOAP/KEGG","get_reactions_by_enzymeResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_reactions_by_enzymeResponse, encoded="SOAP/KEGG")

class get_genes_by_organismRequest:
    def __init__(self):
        self._org = None
        self._offset = None
        self._limit = None
        return
get_genes_by_organismRequest.typecode = Struct(pname=("SOAP/KEGG","get_genes_by_organism"), ofwhat=[ZSI.TC.String(pname="org", aname="_org", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TCnumbers.Iint(pname="offset", aname="_offset", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TCnumbers.Iint(pname="limit", aname="_limit", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_genes_by_organismRequest, encoded="SOAP/KEGG")

class get_genes_by_organismResponse:
    def __init__(self):
        self._return = None
        return
get_genes_by_organismResponse.typecode = Struct(pname=("SOAP/KEGG","get_genes_by_organismResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_genes_by_organismResponse, encoded="SOAP/KEGG")

class get_number_of_genes_by_organismRequest:
    def __init__(self):
        self._abbr = None
        return
get_number_of_genes_by_organismRequest.typecode = Struct(pname=("SOAP/KEGG","get_number_of_genes_by_organism"), ofwhat=[ZSI.TC.String(pname="abbr", aname="_abbr", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_number_of_genes_by_organismRequest, encoded="SOAP/KEGG")

class get_number_of_genes_by_organismResponse:
    def __init__(self):
        self._return = None
        return
get_number_of_genes_by_organismResponse.typecode = Struct(pname=("SOAP/KEGG","get_number_of_genes_by_organismResponse"), ofwhat=[ZSI.TCnumbers.Iint(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_number_of_genes_by_organismResponse, encoded="SOAP/KEGG")

class get_reactions_by_glycanRequest:
    def __init__(self):
        self._glycan_id = None
        return
get_reactions_by_glycanRequest.typecode = Struct(pname=("SOAP/KEGG","get_reactions_by_glycan"), ofwhat=[ZSI.TC.String(pname="glycan_id", aname="_glycan_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_reactions_by_glycanRequest, encoded="SOAP/KEGG")

class get_reactions_by_glycanResponse:
    def __init__(self):
        self._return = None
        return
get_reactions_by_glycanResponse.typecode = Struct(pname=("SOAP/KEGG","get_reactions_by_glycanResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_reactions_by_glycanResponse, encoded="SOAP/KEGG")

class get_reactions_by_compoundRequest:
    def __init__(self):
        self._compound_id = None
        return
get_reactions_by_compoundRequest.typecode = Struct(pname=("SOAP/KEGG","get_reactions_by_compound"), ofwhat=[ZSI.TC.String(pname="compound_id", aname="_compound_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_reactions_by_compoundRequest, encoded="SOAP/KEGG")

class get_reactions_by_compoundResponse:
    def __init__(self):
        self._return = None
        return
get_reactions_by_compoundResponse.typecode = Struct(pname=("SOAP/KEGG","get_reactions_by_compoundResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_reactions_by_compoundResponse, encoded="SOAP/KEGG")

class get_enzymes_by_glycanRequest:
    def __init__(self):
        self._glycan_id = None
        return
get_enzymes_by_glycanRequest.typecode = Struct(pname=("SOAP/KEGG","get_enzymes_by_glycan"), ofwhat=[ZSI.TC.String(pname="glycan_id", aname="_glycan_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_enzymes_by_glycanRequest, encoded="SOAP/KEGG")

class get_enzymes_by_glycanResponse:
    def __init__(self):
        self._return = None
        return
get_enzymes_by_glycanResponse.typecode = Struct(pname=("SOAP/KEGG","get_enzymes_by_glycanResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_enzymes_by_glycanResponse, encoded="SOAP/KEGG")

class get_enzymes_by_compoundRequest:
    def __init__(self):
        self._compound_id = None
        return
get_enzymes_by_compoundRequest.typecode = Struct(pname=("SOAP/KEGG","get_enzymes_by_compound"), ofwhat=[ZSI.TC.String(pname="compound_id", aname="_compound_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_enzymes_by_compoundRequest, encoded="SOAP/KEGG")

class get_enzymes_by_compoundResponse:
    def __init__(self):
        self._return = None
        return
get_enzymes_by_compoundResponse.typecode = Struct(pname=("SOAP/KEGG","get_enzymes_by_compoundResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_enzymes_by_compoundResponse, encoded="SOAP/KEGG")

class get_pathways_by_compoundsRequest:
    def __init__(self):
        self._compound_id_list = None
        return
get_pathways_by_compoundsRequest.typecode = Struct(pname=("SOAP/KEGG","get_pathways_by_compounds"), ofwhat=[ns0.ArrayOfstring_Def(pname="compound_id_list", aname="_compound_id_list", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_pathways_by_compoundsRequest, encoded="SOAP/KEGG")

class get_pathways_by_compoundsResponse:
    def __init__(self):
        self._return = None
        return
get_pathways_by_compoundsResponse.typecode = Struct(pname=("SOAP/KEGG","get_pathways_by_compoundsResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_pathways_by_compoundsResponse, encoded="SOAP/KEGG")

class get_pathways_by_glycansRequest:
    def __init__(self):
        self._glycan_id_list = None
        return
get_pathways_by_glycansRequest.typecode = Struct(pname=("SOAP/KEGG","get_pathways_by_glycans"), ofwhat=[ns0.ArrayOfstring_Def(pname="glycan_id_list", aname="_glycan_id_list", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_pathways_by_glycansRequest, encoded="SOAP/KEGG")

class get_pathways_by_glycansResponse:
    def __init__(self):
        self._return = None
        return
get_pathways_by_glycansResponse.typecode = Struct(pname=("SOAP/KEGG","get_pathways_by_glycansResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_pathways_by_glycansResponse, encoded="SOAP/KEGG")

class get_compounds_by_pathwayRequest:
    def __init__(self):
        self._pathway_id = None
        return
get_compounds_by_pathwayRequest.typecode = Struct(pname=("SOAP/KEGG","get_compounds_by_pathway"), ofwhat=[ZSI.TC.String(pname="pathway_id", aname="_pathway_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_compounds_by_pathwayRequest, encoded="SOAP/KEGG")

class get_compounds_by_pathwayResponse:
    def __init__(self):
        self._return = None
        return
get_compounds_by_pathwayResponse.typecode = Struct(pname=("SOAP/KEGG","get_compounds_by_pathwayResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_compounds_by_pathwayResponse, encoded="SOAP/KEGG")

class get_glycans_by_pathwayRequest:
    def __init__(self):
        self._pathway_id = None
        return
get_glycans_by_pathwayRequest.typecode = Struct(pname=("SOAP/KEGG","get_glycans_by_pathway"), ofwhat=[ZSI.TC.String(pname="pathway_id", aname="_pathway_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_glycans_by_pathwayRequest, encoded="SOAP/KEGG")

class get_glycans_by_pathwayResponse:
    def __init__(self):
        self._return = None
        return
get_glycans_by_pathwayResponse.typecode = Struct(pname=("SOAP/KEGG","get_glycans_by_pathwayResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_glycans_by_pathwayResponse, encoded="SOAP/KEGG")

class get_compounds_by_reactionRequest:
    def __init__(self):
        self._reaction_id = None
        return
get_compounds_by_reactionRequest.typecode = Struct(pname=("SOAP/KEGG","get_compounds_by_reaction"), ofwhat=[ZSI.TC.String(pname="reaction_id", aname="_reaction_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_compounds_by_reactionRequest, encoded="SOAP/KEGG")

class get_compounds_by_reactionResponse:
    def __init__(self):
        self._return = None
        return
get_compounds_by_reactionResponse.typecode = Struct(pname=("SOAP/KEGG","get_compounds_by_reactionResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_compounds_by_reactionResponse, encoded="SOAP/KEGG")

class get_glycans_by_reactionRequest:
    def __init__(self):
        self._reaction_id = None
        return
get_glycans_by_reactionRequest.typecode = Struct(pname=("SOAP/KEGG","get_glycans_by_reaction"), ofwhat=[ZSI.TC.String(pname="reaction_id", aname="_reaction_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_glycans_by_reactionRequest, encoded="SOAP/KEGG")

class get_glycans_by_reactionResponse:
    def __init__(self):
        self._return = None
        return
get_glycans_by_reactionResponse.typecode = Struct(pname=("SOAP/KEGG","get_glycans_by_reactionResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_glycans_by_reactionResponse, encoded="SOAP/KEGG")

class get_compounds_by_enzymeRequest:
    def __init__(self):
        self._enzyme_id = None
        return
get_compounds_by_enzymeRequest.typecode = Struct(pname=("SOAP/KEGG","get_compounds_by_enzyme"), ofwhat=[ZSI.TC.String(pname="enzyme_id", aname="_enzyme_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_compounds_by_enzymeRequest, encoded="SOAP/KEGG")

class get_compounds_by_enzymeResponse:
    def __init__(self):
        self._return = None
        return
get_compounds_by_enzymeResponse.typecode = Struct(pname=("SOAP/KEGG","get_compounds_by_enzymeResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_compounds_by_enzymeResponse, encoded="SOAP/KEGG")

class get_glycans_by_enzymeRequest:
    def __init__(self):
        self._enzyme_id = None
        return
get_glycans_by_enzymeRequest.typecode = Struct(pname=("SOAP/KEGG","get_glycans_by_enzyme"), ofwhat=[ZSI.TC.String(pname="enzyme_id", aname="_enzyme_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_glycans_by_enzymeRequest, encoded="SOAP/KEGG")

class get_glycans_by_enzymeResponse:
    def __init__(self):
        self._return = None
        return
get_glycans_by_enzymeResponse.typecode = Struct(pname=("SOAP/KEGG","get_glycans_by_enzymeResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_glycans_by_enzymeResponse, encoded="SOAP/KEGG")

class convert_mol_to_kcfRequest:
    def __init__(self):
        self._mol_text = None
        return
convert_mol_to_kcfRequest.typecode = Struct(pname=("SOAP/KEGG","convert_mol_to_kcf"), ofwhat=[ZSI.TC.String(pname="mol_text", aname="_mol_text", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=convert_mol_to_kcfRequest, encoded="SOAP/KEGG")

class convert_mol_to_kcfResponse:
    def __init__(self):
        self._return = None
        return
convert_mol_to_kcfResponse.typecode = Struct(pname=("SOAP/KEGG","convert_mol_to_kcfResponse"), ofwhat=[ZSI.TC.String(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=convert_mol_to_kcfResponse, encoded="SOAP/KEGG")

class get_kos_by_pathwayRequest:
    def __init__(self):
        self._pathway_id = None
        return
get_kos_by_pathwayRequest.typecode = Struct(pname=("SOAP/KEGG","get_kos_by_pathway"), ofwhat=[ZSI.TC.String(pname="pathway_id", aname="_pathway_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_kos_by_pathwayRequest, encoded="SOAP/KEGG")

class get_kos_by_pathwayResponse:
    def __init__(self):
        self._return = None
        return
get_kos_by_pathwayResponse.typecode = Struct(pname=("SOAP/KEGG","get_kos_by_pathwayResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_kos_by_pathwayResponse, encoded="SOAP/KEGG")

class get_pathways_by_kosRequest:
    def __init__(self):
        self._ko_id_list = None
        self._org = None
        return
get_pathways_by_kosRequest.typecode = Struct(pname=("SOAP/KEGG","get_pathways_by_kos"), ofwhat=[ns0.ArrayOfstring_Def(pname="ko_id_list", aname="_ko_id_list", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.String(pname="org", aname="_org", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_pathways_by_kosRequest, encoded="SOAP/KEGG")

class get_pathways_by_kosResponse:
    def __init__(self):
        self._return = None
        return
get_pathways_by_kosResponse.typecode = Struct(pname=("SOAP/KEGG","get_pathways_by_kosResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_pathways_by_kosResponse, encoded="SOAP/KEGG")

class search_compounds_by_nameRequest:
    def __init__(self):
        self._name = None
        return
search_compounds_by_nameRequest.typecode = Struct(pname=("SOAP/KEGG","search_compounds_by_name"), ofwhat=[ZSI.TC.String(pname="name", aname="_name", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=search_compounds_by_nameRequest, encoded="SOAP/KEGG")

class search_compounds_by_nameResponse:
    def __init__(self):
        self._return = None
        return
search_compounds_by_nameResponse.typecode = Struct(pname=("SOAP/KEGG","search_compounds_by_nameResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=search_compounds_by_nameResponse, encoded="SOAP/KEGG")

class search_glycans_by_nameRequest:
    def __init__(self):
        self._name = None
        return
search_glycans_by_nameRequest.typecode = Struct(pname=("SOAP/KEGG","search_glycans_by_name"), ofwhat=[ZSI.TC.String(pname="name", aname="_name", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=search_glycans_by_nameRequest, encoded="SOAP/KEGG")

class search_glycans_by_nameResponse:
    def __init__(self):
        self._return = None
        return
search_glycans_by_nameResponse.typecode = Struct(pname=("SOAP/KEGG","search_glycans_by_nameResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=search_glycans_by_nameResponse, encoded="SOAP/KEGG")

class search_compounds_by_compositionRequest:
    def __init__(self):
        self._composition = None
        return
search_compounds_by_compositionRequest.typecode = Struct(pname=("SOAP/KEGG","search_compounds_by_composition"), ofwhat=[ZSI.TC.String(pname="composition", aname="_composition", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=search_compounds_by_compositionRequest, encoded="SOAP/KEGG")

class search_compounds_by_compositionResponse:
    def __init__(self):
        self._return = None
        return
search_compounds_by_compositionResponse.typecode = Struct(pname=("SOAP/KEGG","search_compounds_by_compositionResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=search_compounds_by_compositionResponse, encoded="SOAP/KEGG")

class search_compounds_by_massRequest:
    def __init__(self):
        self._mass = None
        self._range = None
        return
search_compounds_by_massRequest.typecode = Struct(pname=("SOAP/KEGG","search_compounds_by_mass"), ofwhat=[ZSI.TCnumbers.FPfloat(pname="mass", aname="_mass", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TCnumbers.FPfloat(pname="range", aname="_range", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=search_compounds_by_massRequest, encoded="SOAP/KEGG")

class search_compounds_by_massResponse:
    def __init__(self):
        self._return = None
        return
search_compounds_by_massResponse.typecode = Struct(pname=("SOAP/KEGG","search_compounds_by_massResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=search_compounds_by_massResponse, encoded="SOAP/KEGG")

class search_glycans_by_massRequest:
    def __init__(self):
        self._mass = None
        self._range = None
        return
search_glycans_by_massRequest.typecode = Struct(pname=("SOAP/KEGG","search_glycans_by_mass"), ofwhat=[ZSI.TCnumbers.FPfloat(pname="mass", aname="_mass", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TCnumbers.FPfloat(pname="range", aname="_range", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=search_glycans_by_massRequest, encoded="SOAP/KEGG")

class search_glycans_by_massResponse:
    def __init__(self):
        self._return = None
        return
search_glycans_by_massResponse.typecode = Struct(pname=("SOAP/KEGG","search_glycans_by_massResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=search_glycans_by_massResponse, encoded="SOAP/KEGG")

class search_glycans_by_compositionRequest:
    def __init__(self):
        self._composition = None
        return
search_glycans_by_compositionRequest.typecode = Struct(pname=("SOAP/KEGG","search_glycans_by_composition"), ofwhat=[ZSI.TC.String(pname="composition", aname="_composition", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=search_glycans_by_compositionRequest, encoded="SOAP/KEGG")

class search_glycans_by_compositionResponse:
    def __init__(self):
        self._return = None
        return
search_glycans_by_compositionResponse.typecode = Struct(pname=("SOAP/KEGG","search_glycans_by_compositionResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=search_glycans_by_compositionResponse, encoded="SOAP/KEGG")

class search_compounds_by_subcompRequest:
    def __init__(self):
        self._mol = None
        self._offset = None
        self._limit = None
        return
search_compounds_by_subcompRequest.typecode = Struct(pname=("SOAP/KEGG","search_compounds_by_subcomp"), ofwhat=[ZSI.TC.String(pname="mol", aname="_mol", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TCnumbers.Iint(pname="offset", aname="_offset", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TCnumbers.Iint(pname="limit", aname="_limit", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=search_compounds_by_subcompRequest, encoded="SOAP/KEGG")

class search_compounds_by_subcompResponse:
    def __init__(self):
        self._return = None
        return
search_compounds_by_subcompResponse.typecode = Struct(pname=("SOAP/KEGG","search_compounds_by_subcompResponse"), ofwhat=[ns0.ArrayOfStructureAlignment_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=search_compounds_by_subcompResponse, encoded="SOAP/KEGG")

class search_glycans_by_kcamRequest:
    def __init__(self):
        self._kcf = None
        self._program = None
        self._option = None
        self._offset = None
        self._limit = None
        return
search_glycans_by_kcamRequest.typecode = Struct(pname=("SOAP/KEGG","search_glycans_by_kcam"), ofwhat=[ZSI.TC.String(pname="kcf", aname="_kcf", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.String(pname="program", aname="_program", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.String(pname="option", aname="_option", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TCnumbers.Iint(pname="offset", aname="_offset", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TCnumbers.Iint(pname="limit", aname="_limit", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=search_glycans_by_kcamRequest, encoded="SOAP/KEGG")

class search_glycans_by_kcamResponse:
    def __init__(self):
        self._return = None
        return
search_glycans_by_kcamResponse.typecode = Struct(pname=("SOAP/KEGG","search_glycans_by_kcamResponse"), ofwhat=[ns0.ArrayOfStructureAlignment_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=search_glycans_by_kcamResponse, encoded="SOAP/KEGG")

class get_linkdb_between_databasesRequest:
    def __init__(self):
        self._from_db = None
        self._to_db = None
        self._offset = None
        self._limit = None
        return
get_linkdb_between_databasesRequest.typecode = Struct(pname=("SOAP/KEGG","get_linkdb_between_databases"), ofwhat=[ZSI.TC.String(pname="from_db", aname="_from_db", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.String(pname="to_db", aname="_to_db", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TCnumbers.Iint(pname="offset", aname="_offset", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TCnumbers.Iint(pname="limit", aname="_limit", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_linkdb_between_databasesRequest, encoded="SOAP/KEGG")

class get_linkdb_between_databasesResponse:
    def __init__(self):
        self._return = None
        return
get_linkdb_between_databasesResponse.typecode = Struct(pname=("SOAP/KEGG","get_linkdb_between_databasesResponse"), ofwhat=[ns0.ArrayOfLinkDBRelation_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_linkdb_between_databasesResponse, encoded="SOAP/KEGG")

class search_drugs_by_nameRequest:
    def __init__(self):
        self._name = None
        return
search_drugs_by_nameRequest.typecode = Struct(pname=("SOAP/KEGG","search_drugs_by_name"), ofwhat=[ZSI.TC.String(pname="name", aname="_name", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=search_drugs_by_nameRequest, encoded="SOAP/KEGG")

class search_drugs_by_nameResponse:
    def __init__(self):
        self._return = None
        return
search_drugs_by_nameResponse.typecode = Struct(pname=("SOAP/KEGG","search_drugs_by_nameResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=search_drugs_by_nameResponse, encoded="SOAP/KEGG")

class search_drugs_by_compositionRequest:
    def __init__(self):
        self._composition = None
        return
search_drugs_by_compositionRequest.typecode = Struct(pname=("SOAP/KEGG","search_drugs_by_composition"), ofwhat=[ZSI.TC.String(pname="composition", aname="_composition", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=search_drugs_by_compositionRequest, encoded="SOAP/KEGG")

class search_drugs_by_compositionResponse:
    def __init__(self):
        self._return = None
        return
search_drugs_by_compositionResponse.typecode = Struct(pname=("SOAP/KEGG","search_drugs_by_compositionResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=search_drugs_by_compositionResponse, encoded="SOAP/KEGG")

class search_drugs_by_massRequest:
    def __init__(self):
        self._mass = None
        self._range = None
        return
search_drugs_by_massRequest.typecode = Struct(pname=("SOAP/KEGG","search_drugs_by_mass"), ofwhat=[ZSI.TCnumbers.FPfloat(pname="mass", aname="_mass", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TCnumbers.FPfloat(pname="range", aname="_range", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=search_drugs_by_massRequest, encoded="SOAP/KEGG")

class search_drugs_by_massResponse:
    def __init__(self):
        self._return = None
        return
search_drugs_by_massResponse.typecode = Struct(pname=("SOAP/KEGG","search_drugs_by_massResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=search_drugs_by_massResponse, encoded="SOAP/KEGG")

class search_drugs_by_subcompRequest:
    def __init__(self):
        self._mol = None
        self._offset = None
        self._limit = None
        return
search_drugs_by_subcompRequest.typecode = Struct(pname=("SOAP/KEGG","search_drugs_by_subcomp"), ofwhat=[ZSI.TC.String(pname="mol", aname="_mol", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TCnumbers.Iint(pname="offset", aname="_offset", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TCnumbers.Iint(pname="limit", aname="_limit", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=search_drugs_by_subcompRequest, encoded="SOAP/KEGG")

class search_drugs_by_subcompResponse:
    def __init__(self):
        self._return = None
        return
search_drugs_by_subcompResponse.typecode = Struct(pname=("SOAP/KEGG","search_drugs_by_subcompResponse"), ofwhat=[ns0.ArrayOfStructureAlignment_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=search_drugs_by_subcompResponse, encoded="SOAP/KEGG")

class get_references_by_pathwayRequest:
    def __init__(self):
        self._pathway_id = None
        return
get_references_by_pathwayRequest.typecode = Struct(pname=("SOAP/KEGG","get_references_by_pathway"), ofwhat=[ZSI.TC.String(pname="pathway_id", aname="_pathway_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_references_by_pathwayRequest, encoded="SOAP/KEGG")

class get_references_by_pathwayResponse:
    def __init__(self):
        self._return = None
        return
get_references_by_pathwayResponse.typecode = Struct(pname=("SOAP/KEGG","get_references_by_pathwayResponse"), ofwhat=[ns0.ArrayOfint_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_references_by_pathwayResponse, encoded="SOAP/KEGG")

class get_drugs_by_pathwayRequest:
    def __init__(self):
        self._pathway_id = None
        return
get_drugs_by_pathwayRequest.typecode = Struct(pname=("SOAP/KEGG","get_drugs_by_pathway"), ofwhat=[ZSI.TC.String(pname="pathway_id", aname="_pathway_id", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_drugs_by_pathwayRequest, encoded="SOAP/KEGG")

class get_drugs_by_pathwayResponse:
    def __init__(self):
        self._return = None
        return
get_drugs_by_pathwayResponse.typecode = Struct(pname=("SOAP/KEGG","get_drugs_by_pathwayResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_drugs_by_pathwayResponse, encoded="SOAP/KEGG")

class get_pathways_by_drugsRequest:
    def __init__(self):
        self._drug_id_list = None
        return
get_pathways_by_drugsRequest.typecode = Struct(pname=("SOAP/KEGG","get_pathways_by_drugs"), ofwhat=[ns0.ArrayOfstring_Def(pname="drug_id_list", aname="_drug_id_list", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_pathways_by_drugsRequest, encoded="SOAP/KEGG")

class get_pathways_by_drugsResponse:
    def __init__(self):
        self._return = None
        return
get_pathways_by_drugsResponse.typecode = Struct(pname=("SOAP/KEGG","get_pathways_by_drugsResponse"), ofwhat=[ns0.ArrayOfstring_Def(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=get_pathways_by_drugsResponse, encoded="SOAP/KEGG")
