'''
@author  Rui Wang
@see     LICENSE (MIT style license file).
'''


import ZSI.TC
import copy

__author__="Rui Wang, Chaitanya Guttula"

class MessageHandler:
    '''handle message class'''        
    
    def msAssign(self, msInstance, nameValueDic):
        '''given message class instance, _name:value tree structure dictionary,
        assign the values to the correct leaves in the message tree,
        return message class instance with values'''
        
        #get the list of all parts of message
        partList=getattr(getattr(msInstance, 'typecode'), 'ofwhat')
        for part in partList:
            #_name of part of message
            partName=getattr(part, 'aname') 
            if partName not in nameValueDic.keys():
                continue
            #value assigned to part, can be simple type(directly assign) or tree structure(pass to complextypeAssign() or arraytypeAssign())
            partValue=nameValueDic[partName]
            if isinstance(part, ZSI.TC.ComplexType):
                complextypeHolderClassInstance=self.complextypeAssign(part, partValue)
                setattr(msInstance, partName, complextypeHolderClassInstance)
            elif isinstance(part, ZSI.TC.Array) :
                subArray=self.arraytypeAssign(part, partValue)
                setattr(msInstance, partName, subArray)
                print 'the arraay type is : ',subArray
            else:               
                #simple type such as string...directly assign the value to the part               
                setattr(msInstance, partName, partValue)
        return msInstance
    
    def complextypeAssign(self, complextypeInstance, subNameValueDic):
        '''given complex type instance, subtree of _name:value dictionary
        traverse the tree structure recursively,
        return top complextype holder class instance with values filled in'''
        
        if not isinstance(complextypeInstance, ZSI.TC.ComplexType):
            raise TypeError, 'First parameter has to be instance of ZSI.TC.ComplexType'
        else:
            complextypeHolderClassInstance=getattr(complextypeInstance,'pyclass')()
            
            #element instance list of complex type
            elementList=getattr(complextypeInstance, 'ofwhat')
            for ele in elementList:
            
                #_name of element of complex type
                eleName=getattr(ele, 'aname') 
                if eleName not in subNameValueDic.keys():
                    continue
                    
                #value assigned to element, can be simple type(directly assign) or tree structure(pass to complextypeAssign() or arraytypeAssign())
                eleValue=subNameValueDic[eleName]
                if isinstance(ele, ZSI.TC.ComplexType):
                    subclomplextypeClassInstance=self.complextypeAssign(ele, eleValue)
                    setattr(complextypeHolderClassInstance, eleName, subclomplextypeClassInstance)
                elif isinstance(ele, ZSI.TC.Array) :
                    subArray=self.arraytypeAssign(ele, eleValue)
                    setattr(complextypeHolderClassInstance, eleName, subArray)
                else:   
                            
                    #simple type such as string...directly assign the value to the element               
                    setattr(complextypeHolderClassInstance, eleName, eleValue)
            
            return complextypeHolderClassInstance
        
    def arraytypeAssign(self,arraytypeInstance, subValueArray):
        '''given arraytype class instance, [values...],
        recursively handle values,
        return [arraytypeInstance filled with values]'''
        
        
        if not isinstance(arraytypeInstance, ZSI.TC.Array):
            raise TypeError, 'First parameter has to be instance of ZSI.TC.Array'
        else:
            resultArray=[]
            if subValueArray is None:
                return None
            if subValueArray is []:
                return []
            
            #element instance of array type
            elementInstance=getattr(arraytypeInstance, 'ofwhat')
            if isinstance(elementInstance, ZSI.TC.ComplexType):                
                for eleValue in subValueArray:
                    subclomplextypeClassInstance=self.complextypeAssign(copy.deepcopy(elementInstance), eleValue)
                    resultArray.append(subclomplextypeClassInstance)
            elif isinstance(elementInstance, ZSI.TC.Array) :
                for eleValue in subValueArray:
                    subArray=self.arraytypeAssign(copy.deepcopy(elementInstance), eleValue)
                    resultArray.append(subArray)

            else:  
                         
                #simple type such as string...directly return the [value,...]        
                resultArray=subValueArray
            
            return resultArray
        
    def msParser(self, msInstance):
        '''given message class instance,
        parse the message class tree,
        return message tree of _name:value dictionary'''
        
        nameValueDic={}
        
        
        #get the list of all parts of message
        partList=getattr(getattr(msInstance, 'typecode'), 'ofwhat')
        for part in partList:
        
            #_name of part of message
            partName=getattr(part, 'aname')  
            partValueDefault=getattr(msInstance, partName)
            
            #value assigned to part, can be simple type(directly assign) or tree structure(pass to complextypeAssign() or arraytypeAssign())
#            partValue=nameValueDic[partName]
#            nameValueDic[partName]=None
            if isinstance(part, ZSI.TC.ComplexType):
                nameValueDic[partName]=self.complextypeParser(part)
            elif isinstance(part, ZSI.TC.Array) :
                nameValueDic[partName]=self.arraytypeParser(part, partValueDefault)
            else:               
                #simple type such as string...directly retrieve the value of the part               
                nameValueDic[partName]=partValueDefault
        return nameValueDic
    
    def complextypeParser(self, complextypeInstance):
        '''given complex type class instance, 
        traverse the tree structure recursively,
        return subtree of _name:value dictionary'''
        
        if not isinstance(complextypeInstance, ZSI.TC.ComplexType):
            raise TypeError, 'First parameter has to be instance of ZSI.TC.ComplexType'
        else:
            subNameValueDic={}
            complextypeHolderClassInstance=getattr(complextypeInstance,'pyclass')()
            #element instance list of complex type
            elementList=getattr(complextypeInstance, 'ofwhat')
            for ele in elementList:
                #_name of element of complex type
                eleName=getattr(ele, 'aname')  
                eleValueDefault=getattr(complextypeHolderClassInstance,eleName)
                print eleName
                #value assigned to element, can be simple type(directly assign) or tree structure(pass to complextypeAssign() or arraytypeAssign())
#                eleValue=subNameValueDic[eleName]
                if isinstance(ele, ZSI.TC.ComplexType):
                    if(getattr(ele,'maxOccurs')=='unbounded'):   # Handling element with maxOccurances as unbounded and type as complextype
                        print 'arraytype',eleName
                        tempArray=[]
                        sub = self.complextypeParser(ele)
                        tempArray.append(sub)
                        print 'array is : ',tempArray
                        subNameValueDic[eleName]=tempArray  #tempArray.append(sub)#self.arraytypeParser(ele, eleValueDefault)
                    else:
                        print 'complextype', eleName
                        subNameValueDic[eleName]=self.complextypeParser(ele)
                elif isinstance(ele, ZSI.TC.Array):
                    print 'arraytype', eleValueDefault
                    subNameValueDic[eleName]=self.arraytypeParser(ele, eleValueDefault)
                else:               
                    subNameValueDic[eleName] = eleValueDefault             
            
            return subNameValueDic
    
        
    def arraytypeParser(self,arraytypeInstance, defaultValueArray):
        '''given arraytype class instance, and its default value [defaultvalues...]
        if element of array is not simple type then recursively handle traverse the type tree,
        return [values...]
        else return defaultValueArray[defaultvalues...]'''
        
        
        if (not isinstance(arraytypeInstance, ZSI.TC.Array)): #or (getattr(arraytypeInstance,'maxOccurs')!='unbounded') :
            raise TypeError, 'First parameter has to be instance of ZSI.TC.Array'
        else:
            subValueArray=[]
            
            
            #element instance of array type
            elementInstance=getattr(arraytypeInstance, 'ofwhat')
            if isinstance(elementInstance, ZSI.TC.ComplexType):                
                if defaultValueArray is None:
                    subclomplextypeClassInstance=self.complextypeParser(elementInstance)
                    subValueArray.append(subclomplextypeClassInstance)
                else:
                    for eleValue in defaultValueArray:
                        subclomplextypeClassInstance=self.complextypeParser(eleValue)
                        subValueArray.append(subclomplextypeClassInstance)
            elif isinstance(elementInstance, ZSI.TC.Array) :
                if defaultValueArray is None:
                    subarraytypeClassInstance=self.arraytypeParser(elementInstance, None)
                    subValueArray.append(subarraytypeClassInstance)
                else:
                    for eleValue in defaultValueArray:
                        subArray=self.arraytypeParser(copy.deepcopy(elementInstance), eleValue)
                        subValueArray.append(subArray)

            else:               
                #simple type such as string...directly return the [value,...]of the arraytypeInstance (default value)       
                subValueArray=defaultValueArray
            
            return subValueArray
            
    
    def flatten(self,obj):
        if obj is None:
            return None
        elif hasattr(obj, '__dict__') and obj.__dict__:
            return dict([(k, self.flatten(v)) for (k, v) in obj.__dict__.items()])
        if isinstance(obj, (dict,)):
            return dict([(k, self.flatten(v)) for (k, v) in obj.items()])
        elif isinstance(obj, (list,)):
            return [self.flatten(x) for x in obj]
        elif isinstance(obj, (tuple,)):
            return tuple([flatten(x) for x in obj])
        else:
            return obj
            
    def getParameter(self, msInstance,param):
        '''given message class instance, and parameter
        parse the message class tree,
        return the element '''
        nameValueDic={}
        plist = []
        if(param.find('|0|')>-1):
            s = param.split('|0|')
            print 'found |0|',s
            for l in s:
                if(l.find('|')>-1):
                    t = l.split('|')
                    print 'found |',t
                    for i in t:
                        print 'i',i
                        plist.append(i)
                else:
                    plist.append(l)
        elif(param.find('|')>-1):
            plist = param.split('|')
        else:
            partlist = getattr(getattr(msInstance , 'typecode'),'ofwhat')
            for part in partlist:
                if param == getattr(part,'aname'):
                    print part
                    return part
            
        
        element = None
        #get the list of all parts of message
        partList=getattr(getattr(msInstance, 'typecode'), 'ofwhat')
        for part in partList:
            #_name of part of message
            partName=getattr(part, 'aname') 
                
            if(partName == plist[0]):
                
                partname=getattr(part,'pname') 
                partValueDefault=getattr(msInstance, partName)
                break
            #value assigned to part, can be simple type(directly assign) or tree structure(pass to complextypeAssign() or arraytypeAssign())
#            partValue=nameValueDic[partName]
#            nameValueDic[partName]=None
        if isinstance(part, ZSI.TC.ComplexType):
            print 'complextype', getattr(part,'aname')#plist[-1]
            sp = ( self.complextypParser(part,plist[-1]))
            if(sp !=None):
                element = sp
                
        elif isinstance(part, ZSI.TC.Array) :
                element = self.arraytypParser(part, partValueDefault,plist[-1])
                #nameValueDic[partName]=self.arraytypeParser(part, partValueDefault,param)
        else:               
                #simple type such as string...directly retrieve the value of the part               
            if(partName == plist[-1]):
                element = part
        print 'spart',element
        res = getattr(element,'nillable')
        print res
        return element
    
    def complextypParser(self, complextypeInstance,param):
        '''given complex type class instance, and paramater name 
        traverse the tree structure recursively,
        return the element with parameter name'''
        part =None
        if not isinstance(complextypeInstance, ZSI.TC.ComplexType):
            raise TypeError, 'First parameter has to be instance of ZSI.TC.ComplexType'
        else:
            subNameValueDic={}
            complextypeHolderClassInstance=getattr(complextypeInstance,'pyclass')()
            #element instance list of complex type
            elementList=getattr(complextypeInstance, 'ofwhat')
            
            for ele in elementList:
                #_name of element of complex type
                eleName=getattr(ele, 'aname') 
                eleValueDefault=getattr(complextypeHolderClassInstance, eleName)
                #value assigned to element, can be simple type(directly assign) or tree structure(pass to complextypeAssign() or arraytypeAssign())
#                eleValue=subNameValueDic[eleName]
                if isinstance(ele, ZSI.TC.ComplexType):

                    if getattr(ele,'aname') == param:
                        print 'returning the middle complex type'
                        return ele
                    else:
                        part = self.complextypParser(ele,param)
                        return part
                    #subNameValueDic[eleName]=self.complextypeParser(ele)
#                    setattr(complextypeHolderClassInstance, eleName, subclomplextypeClassInstance)
                elif isinstance(ele, ZSI.TC.Array) :
                    part = self.arraytypParser(ele, eleValueDefault,param)
                    return part
                    
                else:
                    if(param == eleName):
                        print 'matched',param
                        part = (ele)
                        return part
                    #simple type such as string...directly retrieve the value of the element  
                    subNameValueDic[eleName]=eleValueDefault             
            return None#subNameValueDic
    
    
        
    def arraytypParser(self,arraytypeInstance, defaultValueArray,param):
        '''given arraytype class instance, and its default value [defaultvalues...]
        if element of array is not simple type then recursively handle traverse the type tree,
        return [values...]
        else return defaultValueArray[defaultvalues...]'''
        
        
        if not isinstance(arraytypeInstance, ZSI.TC.Array):
            raise TypeError, 'First parameter has to be instance of ZSI.TC.Array'
        else:
            subValueArray=[]
            
            #element instance of array type
            elementInstance=getattr(arraytypeInstance, 'ofwhat')
            if isinstance(elementInstance, ZSI.TC.ComplexType):                
                if defaultValueArray is None:
                    part = self.complextypParser(elementInstance,param)
                    return part
      #              subclomplextypeClassInstance=self.complextypeParser(elementInstance)
       #             subValueArray.append(subclomplextypeClassInstance)
                else:
                    for eleValue in defaultValueArray:
                        part = self.complextypParser(eleValue,defaulValueArray,param)
                        subclomplextypeClassInstance=self.complextypeParser(eleValue)
         #               subValueArray.append(subclomplextypeClassInstance)
#                    setattr(elementInstance, eleName, subclomplextypeClassInstance)
            elif isinstance(elementInstance, ZSI.TC.Array) :
#                print 'arraytype', elementInstance
                if defaultValueArray is None:
                    part = self.arraytypParser(elementInstance, None,param)
          #          subarraytypeClassInstance=self.arraytypeParser(elementInstance, None)
           #         subValueArray.append(subarraytypeClassInstance)
                else:
                    for eleValue in defaultValueArray:
                        part = self.arraytypParser(copy.deepcopy(elementInstance), eleValue,param)
            #            subArray=self.arraytypeParser(copy.deepcopy(elementInstance), eleValue)
             #           subValueArray.append(subArray)

            else:               
                #simple type such as string...directly return the [value,...]of the arraytypeInstance (default value)       
                return elementInstance
            return None
    


#if __name__=="__main__":


