'''
@author  Chaitanya Guttula, Sumedha Ganjoo
@see     LICENSE (MIT style license file).
'''

import os

'''
Opens the toolconf.xml file and then adds the tool that is paased to it under Web Service tools
'''

__author__=""

class editToolConfig1(object):
    def addTool(self,toolName):
      galaxyhome=os.environ.get('GALAXY_HOME')
      f1=open(galaxyhome+'/tool_conf.xml','r')
      f1.seek(0,0)
      f2=open(galaxyhome+'/tool_conf_backup.xml','w')
      f2.seek(0,0)

      #copy everything from tool_conf.xml upto the section 'Web Service Tools' into another file f2
      line = f1.readline()
      f2.write(line)

      lineStripped=line.lstrip()
      lineStripped=lineStripped.rstrip()

      #add the one-time Web service invocation tool under Web Service Tools section
      while not lineStripped == '<section name="Select Web Service Tool" id="WebServices">':
        line = f1.readline()
        f2.write(line)
        lineStripped = line.lstrip()
        lineStripped=lineStripped.rstrip()        
      else:
        print line

      f2.write('    <tool file="WebServiceToolWorkflow_REST_SOAP/clients/'+toolName + '.xml"/>\n')

      #copy rest of tool_conf.xml file f2
      while not lineStripped == '</toolbox>':
        line = f1.readline()
        f2.write(line)
        lineStripped = line.lstrip()
        lineStripped=lineStripped.rstrip()          
      else:
        print line

      ##close f1 and f2
      f1.close()
      f2.close()

      ##interchange modes of f1 and f2
      f1=open(galaxyhome+'/tool_conf.xml','w')
      f1.seek(0,0)
      f2=open(galaxyhome+'/tool_conf_backup.xml','r')
      f2.seek(0,0)

      line = f2.readline()
      f1.write(line)

      lineStripped=line.lstrip()
      lineStripped = lineStripped.rstrip()

      ##write entire f2 into f1 (reverse roles)
      while not lineStripped == '</toolbox>':
        line = f2.readline()
        f1.write(line)
        lineStripped = line.lstrip()
        lineStripped = lineStripped.rstrip()        
      else:
        print line

      f1.close()
      f2.close()
