'''
@author  Chaitanya Guttula
@see     LICENSE (MIT style license file).
'''


# Author = Chaitanya Guttula

import warnings

with warnings.catch_warnings():
    warnings.simplefilter("ignore")

    import platform
    import commands
    import ZSI
    import os
    from clientGenerator.creatorEngineComplex import *
    from clientGenerator.wsdl2path import *
    from jpype._jpackage import JPackage
    from jpype import *
    import sys

class Document(object):  

    '''    
        Method to get all the operations from the WSDL file and write it to Galaxy output datasets
    '''
     	    
    def getWSDLMethods(self, url , outputFileUrl):
        wLoad=wsdlLoader()
        a= str(url).split('/')
        wsdlnamelist = a[len(a)-1].split(".")
        if len(wsdlnamelist)==1:
    	    wsdlnamelist=a[len(a)-1].split('?')
    	    print wsdlnamelist

        foldername=wsdlnamelist[0]
        
        galaxyhome=os.environ.get('GALAXY_HOME')
        path =galaxyhome+'/tools/WebServiceToolWorkflow_REST_SOAP/clientGenerator/'+foldername
        os.chdir(galaxyhome+'/tools/WebServiceToolWorkflow_REST_SOAP/clientGenerator/')
        
    #creates the client stubs
        clientfile=wLoad.wsdlUrl2path(str(url),foldername)
        
    #Gets the list of operations
        test=ClientCreator()
        operations=test.path2Ops(str(clientfile)).keys()
        
    #COnvert ~ to __tilda__
        if(url.find('~')>-1):
            ulist = url.split('~')
            url = '__tilda__'.join(ulist)


    #Print all the operations and web service info to the Galaxy output dataset
        outputfile=open(outputFileUrl,'w')
        count=0
        outputfile.seek(0,0)
        for k in operations:
            count=count+1
            if(count==1):
                outputfile.write(k+'\t'+clientfile+'\t'+url+'\n')
    	    else:
                outputfile.write(k+'\n')

    #invoked to get REST methods described in a WSDL 2.0 document. Steps are similar to getWADLMethods except the library to parse WSDL 2.0 is used.
    def getWSDLRESTMethods(self, wsdlUrl, outputFileUrl ):
        javahome = os.environ.get('JAVA_HOME')
        galaxyhome=os.environ.get('GALAXY_HOME')
        classpath= galaxyhome + '/tools/WebServiceToolWorkflow_REST_SOAP/WodenWSDLParser/bin'
        jarpath = galaxyhome + '/tools/WebServiceToolWorkflow_REST_SOAP/WodenWSDLParser/lib/'
        machine = platform.machine()
        
    #start JVM depending on the machine. The location of libjvm.so is assumed to be standard.
    #you can replace lines 81 to 88, with startJVM("LOCATION OF YOUR LIBJVM.SO","-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        if machine == 'x86_64' :
            startJVM("%s/jre/lib/amd64/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        elif machine == 'i686' :
            startJVM("%s/jre/lib/i386/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        elif machine == 'sun4u' :
            startJVM("%s/jre/lib/sparc/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        else :
            System.exit("Could not identify machine, please specify path to libjvm.so")
    
        pkg=JPackage('lsdis')
       
        outputfile=open(outputFileUrl,'w')
        outputfile.seek(0,0)
        length=(len(sys.argv))
    
        urls = []
        methods = []

	if(wsdlUrl.find('__tilda__')>-1):
	    ulist = wsdlUrl.split('__tilda__')
	    urlToPass = '~'.join(ulist)

        WSDLParserDriver=pkg.WSDLParserDriver
        wPD=WSDLParserDriver()
        wPD.parse(urlToPass)
        urls = wPD.getUrl()
        methods = wPD.getCompleteMethodList()
        	            
        i=0
        for url in urls:
           outputfile.write(wsdlUrl+"\t")
           outputfile.write(str(methods[i].getName().getLocalPart())+"\t")
           outputfile.write(str(url)+"\n")
           i=i+1

                

    '''
        Invoked to get methods described in a WADL document 
    '''
    def getWADLMethods(self, wadlUrl, outputFileUrl ):

    #get environment variables JAVA_HOME and GALAXY_HOME
        javahome = os.environ.get('JAVA_HOME')
        galaxyhome=os.environ.get('GALAXY_HOME')

    #classpath, jarpath are variables pointing to the java libraries required to parse a WADL document
        classpath= galaxyhome + '/tools/WebServiceToolWorkflow_REST_SOAP/ParserForWADL/bin'
        jarpath = galaxyhome + '/tools/WebServiceToolWorkflow_REST_SOAP/ParserForWADL/lib/'
    
    #start JVM depending on the machine. The location of libjvm.so is assumed to be standard.
    #you can replace lines 28 to 35, with startJVM("LOCATION OF YOUR LIBJVM.SO","-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        machine = platform.machine()
        if machine == 'x86_64' :
            startJVM("%s/jre/lib/amd64/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        elif machine == 'i686' :
            startJVM("%s/jre/lib/i386/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        elif machine == 'sun4u' :
            startJVM("%s/jre/lib/sparc/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        else :
            System.exit("Could not identify machine, please specify path to libjvm.so")
        
    #tell JPYPE that the package name is lsdis 
        pkg=JPackage('lsdis')
    
        urlToPass=java.net.URL(wadlUrl)	

    #convert __tilda__ to ~
        if(wadlUrl.find('__tilda__')>-1):
	        ulist = wadlUrl.split('__tilda__')
	        urlToPass = java.net.URL('~'.join(ulist))
        
   
        outputfile=open(outputFileUrl,'w')
        outputfile.seek(0,0)
         
        urls = []
        methods = []

    #using JPYPE call appropriate Java classes and methods to parse the WADL document and get a list of methods defined in it
        WADLParserDriver=pkg.WADLParserDriver
        wPD=WADLParserDriver()
        wPD.parse(urlToPass)
        urls = wPD.getUrl()
        methods = wPD.getCompleteMethodList()
    
    #write the url of the WADL and the list of methods to the output in a tabular format, for the Step 2 tool to read from.
        i=0
        for url in urls:
            outputfile.write(str(url)+"\t")
            outputfile.write(str(methods[i].getId())+"\t")
            outputfile.write(wadlUrl+"\n")
            i=i+1
     	    

   
    # invoked to get methods described in a SAWADL document    
    def getSAWADLMethods(self, sawadlUrl, outputFileUrl ):
        javahome = os.environ.get('JAVA_HOME')
        galaxyhome=os.environ.get('GALAXY_HOME')
        classpath= galaxyhome + '/tools/restclientSAWADL/lib/SAWADLParser/bin'
        machine = platform.machine()
        
    #start JVM depending on the machine. The location of libjvm.so is assumed to be standard.
    #you can replace lines 126 to 133, with startJVM("LOCATION OF YOUR LIBJVM.SO","-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)        
        if machine == 'x86_64' :
            startJVM("%s/jre/lib/amd64/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath)
        elif machine == 'i686' :
            startJVM("%s/jre/lib/i386/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath)
        elif machine == 'sun4u' :
            startJVM("%s/jre/lib/sparc/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath)            
        else :
            System.exit("Could not identify machine, please specify path to libjvm.so")
    
        pkg=JPackage('edu.uga.cs.lsdis.meteors.wadls')
        

   # Open the output file for galaxy
        outputfile=open(outputFileUrl,'w')
        outputfile.seek(0,0)
   
    	if(sawadlUrl.find('__tilda__')>-1):
    	    ulist = sawadlUrl.split('__tilda__')
    	    urlToPass = '~'.join(ulist)
	         
        urls = []
        methods = []

    #invoke the parser and get the method list
        SAWADLParserDriver=pkg.SAWADLParserDriver
        sawPD=SAWADLParserDriver()
        sawPD.parse(urlToPass)
        urls = sawPD.getUrl()
        methods = sawPD.getCompleteMethodList()
        
    #Print the methods and service information to the 
        i=0
        for url in urls:
           outputfile.write(sawadlUrl+"\t")
           outputfile.write(str(methods[i].getName())+"\t")    
           outputfile.write(str(url)+"\n")
           i=i+1

