'''
@author  Chaitanya Guttula, Sumedha Ganjoo
@see     LICENSE (MIT style license file).
'''

import os

'''
Open the toolconf.xml file and adds the tool under 'Web Service Workflow Tools' that has been passed to it.

'''
class editToolConfig(object):
    def addTool(self,toolName):
      galaxyhome=os.environ.get('GALAXY_HOME')
      f1=open(galaxyhome+'/tool_conf.xml','r')
      f1.seek(0,0)
      f2=open(galaxyhome+'/tool_conf_backup.xml','w')
      f2.seek(0,0)

      ##first copy everything upto WebServiceTool1.xml into another file f2
      line = f1.readline()
      f2.write(line)

      lineStripped=line.lstrip()
      lineStripped=lineStripped.rstrip()

      #add the workflow Web service invocation tool under Web Service Workflow Tools section
      while not lineStripped == '<section name="Select Web Service Workflow Tool" id="WebServiceWorkflow">':
        line = f1.readline()
        f2.write(line)
        lineStripped = line.lstrip()
        lineStripped=lineStripped.rstrip()
      else:
        print line

      ## add new tool to f2
      f2.write('    <tool file="WebServiceToolWorkflow_REST_SOAP/workflowclients/'+toolName + '.xml"/>\n')

      ## copy rest of f1 into f2
      while not lineStripped == '</toolbox>':
        line = f1.readline()
        f2.write(line)
        lineStripped = line.lstrip()
        lineStripped=lineStripped.rstrip()        
      else:
        print line

      ##close f1 and f2
      f1.close()
      f2.close()

      ##interchange modes of f1 and f2
      f1=open(galaxyhome+'/tool_conf.xml','w')
      f1.seek(0,0)
      f2=open(galaxyhome+'/tool_conf_backup.xml','r')
      f2.seek(0,0)

      line = f2.readline()
      f1.write(line)

      lineStripped=line.lstrip()

      ##write entire f2 into f1 (reverse roles)
      while not lineStripped == '</toolbox>':
        line = f2.readline()
        f1.write(line)
        lineStripped = line.lstrip()
        lineStripped=lineStripped.rstrip()        
      else:
        print line

      f1.close()
      f2.close()
