#!/bin/bash

echo $@

OUTPUT=$1
shift
WITHMIXTURES=$1
shift
COLUMNNS=$1
shift
COLUMNGAPS=$1
shift
SAMPLENS=$1
shift
SAMPLEGAPS=$1
shift
REFERENCE=$1
shift
INCLUDE=$1
shift
EXCLUDE=$1
shift
STATS=$1
shift
INPUT=$@

CMD="phenix.py vcf2fasta --out $OUTPUT --input $INPUT"

if [ $WITHMIXTURES != "NOTTHERE" ]; then
    CMD="$CMD --with-mixtures $WITHMIXTURES"
fi

if [ $COLUMNNS != "NOTTHERE" ]; then
    CMD="$CMD --column-Ns $COLUMNNS"
fi

if [ $COLUMNGAPS != "NOTTHERE" ]; then
    CMD="$CMD --column-gaps $COLUMNGAPS"
fi

if [ $SAMPLENS != "NOTTHERE" ]; then
    CMD="$CMD --sample-Ns $SAMPLENS"
fi

if [ $SAMPLEGAPS != "NOTTHERE" ]; then
    CMD="$CMD --sample-gaps $SAMPLEGAPS"
fi

if [ $REFERENCE != "NOTTHERE" ]; then
    CMD="$CMD --reference $REFERENCE"
fi

if [ $INCLUDE != "NOTTHERE" ]; then
    CMD="$CMD --include $INCLUDE"
fi

if [ $EXCLUDE != "NOTTHERE" ]; then
    CMD="$CMD --exclude $EXCLUDE"
fi

echo $CMD
eval $CMD
