#!/bin/bash

echo $@

OUTPUT=$1
shift
WITHMIXTURES=$1
shift
COLUMNNS=$1
shift
SAMPLENS=$1
shift
REFERENCE=$1
shift
INCLUDE=$1
shift
EXCLUDE=$1
shift
INPUT=$@

DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
export PATH=$PATH:$DIR

CMD="vcfs2fasta.py --out $OUTPUT --input $INPUT"

if [ $WITHMIXTURES != "NOTTHERE" ]; then
    CMD="$CMD --with-mixtures $WITHMIXTURES"
fi

if [ $COLUMNNS != "NOTTHERE" ]; then
    CMD="$CMD --column-Ns $COLUMNNS"
fi

if [ $SAMPLENS != "NOTTHERE" ]; then
    CMD="$CMD --sample-Ns $SAMPLENS"
fi

if [ $REFERENCE != "NOTTHERE" ]; then
    CMD="$CMD --reference $REFERENCE"
fi

if [ $INCLUDE != "NOTTHERE" ]; then
    CMD="$CMD --include INCLUDE"
fi

if [ $EXCLUDE != "NOTTHERE" ]; then
    CMD="$CMD --exclude EXCLUDE"
fi

echo $CMD
eval $CMD
