#!/usr/bin/env python

# Copyright INRA (Institut National de la Recherche Agronomique)
# http://www.inra.fr
# http://urgi.versailles.inra.fr
#
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software.  You can  use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
#
# As a counterpart to the access to the source code and  rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty  and the software's author,  the holder of the
# economic rights,  and the successive licensors  have only  limited
# liability.
#
# In this respect, the user's attention is drawn to the risks associated
# with loading,  using,  modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean  that it is complicated to manipulate,  and  that  also
# therefore means  that it is reserved for developers  and  experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and,  more generally, to use and operate it in the
# same conditions as regards security.
#
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.

import os, sys
from commons.core.checker.CheckerUtils import CheckerUtils
from commons.core.utils.RepetOptionParser import RepetOptionParser
from commons.core.utils.FileUtils import FileUtils
import subprocess

class Cufflinks(object):
         
    def __init__(self, input_mapped = "", input_transcripts = "", workingDir = "", verbosity = 3):
        self._input_mapped = input_mapped
	self._transcripts = input_transcripts
        self._output_dir = workingDir
        self._verbosity = verbosity
        
    def setAttributesFromCmdLine(self):
        description = "It accepts aligned RNA-Seq reads and assembles the alignments into a parsimonious set of transcripts." 
        usage = "Cufflinks.py -i  <hits.bam> -g <transcripts.gtf> -o <output-dir>\n"
        parser = RepetOptionParser(description = description, usage = usage)
        parser.add_option( '-i', '--input_mapped', dest='input_mapped', help='aligned RNA-Seq reads' )
	parser.add_option( '-g' , '--input_transcripts', dest='input_transcripts', help='GTF/GFF with known transcripts'    , default="" )
        parser.add_option( '-o', '--output_dir', dest='output_dir', help='write all output files to this directory', default = "")
        options, args = parser.parse_args()
        self.setAttributesFromOptions(options)
    
    def setAttributesFromOptions(self, options):
        self._input_mapped = options.input_mapped
	self._transcripts = options.input_transcripts
        self._output_dir = options.output_dir
        
    def checkExecutables(self):
        if not CheckerUtils.isExecutableInUserPath("cufflinks"):
            raise Exception("ERROR: cufflinks must be in your path")
    
    def checkOptions(self):   
        if self._input_mapped != "":
            if not FileUtils.isRessourceExists(self._input_mapped):
                raise Exception("ERROR: reference file %s does not exist!" % self._input_mapped)
        else:
            raise Exception("ERROR: No specified -i option!")

	if self._transcripts != "" :
	    if not FileUtils.isRessourceExists(self._input_mapped):
                raise Exception("ERROR: reference file %s does not exist!" % self._transcripts)

   
    def getCufflinksCmd(self, mapped, transcripts, output_dir ): 
	if self._transcripts != "" :
	        cmd = 'cufflinks %s -g %s -o %s' % (mapped, transcripts , output_dir)
	else:
		cmd = 'cufflinks %s -o %s' % (mapped , output_dir)
#        print cmd
        return cmd
    
    def run(self):
        self.checkExecutables()
        self.checkOptions()
        try:
            workingDir =  self._output_dir
            if os.path.exists(workingDir):
		print "ERROR: %s already exists." % workingDir
		sys.exit(1)
                raise Exception("ERROR: %s already exists." % workingDir)
            cmd_cufflinks = self.getCufflinksCmd(self._input_mapped, self._transcripts,  self._output_dir)
            ## hide output of subprocess: stdout = index_dir_stderr
            fstdout = open( "cufflinks.log" , 'w' )
            process = subprocess.Popen(cmd_cufflinks, shell = True, stdout = fstdout, stderr=subprocess.STDOUT)
            returncode = process.wait()
            fstdout.close()
            # get stderr, allowing for case where it's very large
            fstdout = open("cufflinks.log", 'rb' )
            stderr = ''
            buffsize = 1048576
            try:
                while True:
                    stderr += fstdout.read( buffsize )
                    if not stderr or len( stderr ) % buffsize != 0:
                        break
            except OverflowError:
                    pass
            fstdout.close()
            if returncode != 0:
                    raise Exception, stderr
            os.system("mv cufflinks.log  %s/cufflinks.log " % workingDir) 
        except Exception:
            raise Exception("ERROR in %s " % cmd_cufflinks)
        
                
if __name__ == "__main__":
    iLaunch = Cufflinks()
    iLaunch.setAttributesFromCmdLine()
    iLaunch.run()

