import os, shutil, glob, re, sys, time
from distutils.util import convert_path
from distutils.core import setup
from distutils.core import Command

class Devtools(object):
    
    @staticmethod
    def find_sub_packages(lrootPackage, lExclude=()):
        lPackages = Devtools.find_packages(exclude=lExclude)
        lSubPackage = []
        for package in lPackages:
                for rootPackage in lrootPackage:
                        if package.startswith(rootPackage):
                                lSubPackage.append(package)         
        return lSubPackage
    
    @staticmethod
    def find_packages(where='.', exclude=()):
        out = []
        stack=[(convert_path(where), '')]
        while stack:
            where,prefix = stack.pop(0)
            for name in os.listdir(where):
                fn = os.path.join(where,name)
                if ('.' not in name and os.path.isdir(fn) and os.path.isfile(os.path.join(fn,'__init__.py'))):
                    out.append(prefix+name); stack.append((fn,prefix+name+'.'))
        for pat in list(exclude)+['ez_setup', 'distribute_setup']:
            from fnmatch import fnmatchcase
            out = [item for item in out if not fnmatchcase(item,pat)]
        return out
    
    @staticmethod
    def findall(directory = os.curdir):
        all_files = []
        for base, dirs, files in os.walk(directory):
            if base==os.curdir or base.startswith(os.curdir+os.sep):
                base = base[2:]
            if base:
                files = [os.path.join(base, f) for f in files]
            all_files.extend(filter(os.path.isfile, files))
        return all_files


class Install(Command):
    description = "Install TEiso_tools"
    user_options = []
 
    def initialize_options(self):
        """Use this to set option defaults before parsing."""
        pass
 
    def finalize_options(self):
        """Code to validate/modify command-line/config input goes here."""
        pass

    def _isToLink(self, fileName):
        if re.search("__\w*.py", fileName):
            return False
        elif re.search("Test\w*.py", fileName):
            return False
        elif re.search("\w*.py$", fileName):
            return True
        return False        

    def run(self):
        cwd = os.getcwd()
        print "Build TEiso in %s" % (cwd)
        if not os.path.isdir("bin"):
            os.mkdir("bin")
        os.chdir("bin")
        lPackages = ["TEiso"]
        for package in lPackages:
            if os.path.isdir("../%s" % package):
                print "processing %s/..." % package
                [os.symlink(i, os.path.basename(i)) for i in Devtools.findall("../%s" % package) if self._isToLink(os.path.basename(i))]
        os.system("chmod 0755 *")
        print "TEiso is ready to use"

class PublicRelease(Command):
    description = "public release for TEiso_tools"
    user_options = []
 
    def initialize_options(self):
        """Use this to set option defaults before parsing."""
        pass
 
    def finalize_options(self):
        """Code to validate/modify command-line/config input goes here."""
        pass
 
    def run(self):
        
        print "START Releasing (%s)" % time.strftime("%Y-%m-%d %H:%M:%S")
        sys.stdout.flush()

        cwd = os.getcwd()
        
        print "Removing all '.pyc' files and dead symlinks in bin, then adding execution rights to all 'py' files (%s)" % time.strftime("%Y-%m-%d %H:%M:%S")
        sys.stdout.flush()
        
        os.system("find . -name '*.pyc' -exec rm {} \;")
        os.system("find . -name '*.py' -exec chmod +x {} \;")
        os.system("find -L ./bin -type l -exec rm {} +")

#        lSetupFiles = FileUtils.getFileNamesList(cwd, "setup_.*.py")
#        lSetupFiles.remove("setup_REPET.py")
#        FileUtils.removeFilesFromList(lSetupFiles)

        os.chdir("..")
        os.system("tar -czf %s.tar.gz %s" % (os.path.basename(cwd), os.path.basename(cwd)))

        print "END Releasing (%s)" % time.strftime("%Y-%m-%d %H:%M:%S")
        sys.stdout.flush()
    
setup(
      name = "TEisotools",
      version = "1.1.a",
      description='Set of tools to analyse RNA_seq for the France Genomics projects.',
      author='URGI team',
      author_email='urgi-support@versailles.inra.fr',
      url='https://urgi.versailles.inra.fr/Projects/TEiso',
      packages=[],
      #Additionnal Files
      data_files=[('TEiso',["TEiso/LaunchTEiso.py", "TEiso/Tophat.py", "TEiso/Cufflinks.py", "TEiso/Cuffcompare.py", "TEiso/Bowtie_build.py", "TEiso/Bedtools_closest.py","TEiso/ClosestToStartSite.py", "TEiso/GFFToBed.py", "TEiso/CufflinksGTFToBed.py"]),
                  ("commons/core", glob.glob("commons/core/*.py")),
                  ("commons", glob.glob("commons/*.py")),
                  ("commons/core/utils", glob.glob("commons/core/utils/*.py")),
                  ("commons/core/checker", glob.glob("commons/core/checker/*.py")),
                  ("commons/core/seq", glob.glob("commons/core/seq/*.py")),
                  ("commons/core/coord", glob.glob("commons/core/coord/*.py")),
                  ('commons/core/parsing',["commons/core/parsing/GtfParser.py", "commons/core/parsing/TranscriptListParser.py", "commons/core/parsing/GffParser.py", "commons/core/parsing/__init__.py"]),
                  ('',['TEiso/doc/README_TEiso.txt']),('',['LICENSE'])],
      cmdclass={
     'install' : Install
        }
      )


