#!/usr/bin/env python


import subprocess, tempfile, sys, os, glob, shutil, time
from optparse import OptionParser


class ClosestToStartSiteWrapper(object):

    def __init__(self):
        self._options = None
        
        
    def stop_err(self, msg ):
        sys.stderr.write( "%s\n" % msg )
        sys.exit()
        
        
    def setAttributesFromCmdLine(self):
        description = "ClosestToStartSite"
        epilog = "\nParser a bed file and create a bed file to create a report about positions of features A to features B. \n"
        epilog +="it can also add the class code of features A. \n"
        epilog += "example: ClosestToStartSite.py -i <inputFile> -c <cuff_in.tmap> -o <outputFile>\n"
        parser = OptionParser(description = description, version = "1.0")
        parser.add_option("-i", "--inputFile",  dest = "inputFile",  action = "store", type = "string", help = "input bed file",  default = "")
        parser.add_option("-c", "--cuffcom_tmap",  dest = "cuffcom_tmap",  action = "store", type = "string", help = "input gtf file",  default = "")
        parser.add_option("-o", "--outputFile", dest = "outputFile", action = "store", type = "string", help = "output Bed File name", default = "")
        #parser.add_option("-t", "--outputFileclasscode", dest = "outputFile_classcode", action = "store", type = "string", help = "output Bed File name with class code.", default = "")
        parser.add_option("-v", "--verbosity",  dest = "verbosity",  action = "store", type = "int",    help = "verbosity [optional] [default: 3]",default = 3)
        options = parser.parse_args()[0]
        self._setAttributesFromOptions(options)

    def _setAttributesFromOptions(self, options):
        self._options = options

    def run(self):
        prg = "ClosestToStartSite.py"
        args = ""
        args += "-i %s" % self._options.inputFile
	args += " "
        args += "-o %s" % self._options.outputFile
        if  self._options.cuffcom_tmap != "":
            args += " "
            args += "-c %s" % self._options.cuffcom_tmap
        cmd = "%s %s" %(prg, args)
        print cmd
        
        try:
            tmp_err = tempfile.NamedTemporaryFile().name
            tmp_stderr = open( tmp_err, 'wb' )
            proc = subprocess.Popen( args=cmd, shell=True, cwd=".", stderr=tmp_stderr )
            returncode = proc.wait()
            tmp_stderr.close()
            # get stderr, allowing for case where it's very large
            tmp_stderr = open( tmp_err, 'rb' )
            stderr = ''
            buffsize = 1048576
            try:
                while True:
                    stderr += tmp_stderr.read( buffsize )
                    if not stderr or len( stderr ) % buffsize != 0:
                        break
            except OverflowError:
                pass
            tmp_stderr.close()
            if stderr:
                raise Exception, stderr
        except Exception, e:
            self.stop_err( 'Error in ClosestToStartSite:\n' + str( e ) ) 
        
if __name__ == "__main__":
    iWrapper = ClosestToStartSiteWrapper()
    iWrapper.setAttributesFromCmdLine()
    iWrapper.run()    
