'''
usage:

python endbias.py utr5-coverage utr3-coverage outputfile
'''
import sys,math

def getCoverage(filename):
    f = open(filename)
    coverage = {}
    for line in f:
        flds = line.strip().split('\t')
        score = float(flds[4])
        name = (flds[0].split('utr'))[0].strip('_')
        if coverage.has_key(name):
            if score > coverage[name]:
                coverage[name] = score
        else:
            coverage[name] = score
    return coverage

def endBias(filename,utr5,utr3):
    out = open(filename,'w')
    for txpt in utr5.keys():
        if utr3.has_key(txpt):
            out.write('\t'.join([txpt,str(utr5[txpt]),str(utr3[txpt]),str(math.log((1+utr5[txpt])/(1+utr3[txpt]),2))])+'\n')
    out.close()
   
   
utr5 = getCoverage(sys.argv[1])
utr3 = getCoverage(sys.argv[2])
endBias(sys.argv[3],utr5,utr3)
            
'''

utr5 = getCoverage('hmga2-utr5.coverage')
utr3 = getCoverage('hmga2-utr3.coverage')
logratio, cov5,cov3= endBias(utr5,utr3)
2**pylab.median(logratio.values())

log2utr5 = pylab.log2(pylab.array(cov5)+1)
log2utr3 = pylab.log2(pylab.array(cov3)+1)
  
pylab.plot(log2utr5,log2utr3,'bo')   

pylab.show()               

utr5 = getCoverage('control-utr5.coverage')
utr3 = getCoverage('control-utr3.coverage')
logratio, cov5,cov3= endBias(utr5,utr3)
2**pylab.median(logratio.values())
'''
