import sys,os

infile = sys.argv[1]
outfile = sys.argv[2]
uselog = sys.argv[3]
subset = sys.argv[4]
reorder = sys.argv[5]
color = sys.argv[6]
scale = sys.argv[7] # rescale each row
cols = sys.argv[8]
rscript = open('tmp.r','w')

rscript.write("x <- read.table('"+infile+"')\n")
rscript.write("x <- x[,c("+cols+")]\n")
rscript.write("nr <- nrow(x) \n")
rscript.write("nc <- ncol(x)\n")
rscript.write("rowsum <- apply(x,1,sum)\n")

if subset =='subset':
    rscript.write("if (nr*nc > 100000) {\n")
    rscript.write("  nr2 <- as.integer(100000/nc)\n")
    rscript.write("  subind <- sample(seq(nr),nr2)\n")
    rscript.write("  x <- x[subind,]\n")
    rscript.write("  rowsum <- rowsum[subind]\n")
    rscript.write("}\n")

rscript.write("pdf('"+outfile+"')\n")

if uselog == 'uselog':
    rscript.write("x <- -(log(as.matrix(x,nc=nc)))\n")
else:
    rscript.write("x <- -as.matrix(x,nc=nc)\n")
if scale == 'scale':
    rscript.write("x <- scale(x)\n")
if reorder == 'average':
    rscript.write("hc <- hclust(dist(x),method= 'average')\n")
    rscript.write("x <- x[hc$order,]\n")
elif reorder == 'centroid':
    rscript.write("hc <- hclust(dist(x),method= 'centroid')\n")
    rscript.write("x <- x[hc$order,]\n")
elif reorder == 'complete':
    rscript.write("hc <- hclust(dist(x),method= 'complete')\n")
    rscript.write("x <- x[hc$order,]\n")
elif reorder == 'single':
    rscript.write("hc <- hclust(dist(x),method= 'single')\n")
    rscript.write("x <- x[hc$order,]\n")
elif reorder == 'median':
    rscript.write("hc <- hclust(dist(x),method= 'median')\n")
    rscript.write("x <- x[hc$order,]\n")    
elif reorder == 'sort_by_total':
    rscript.write("srt <- sort(rowsum,index.return=T)\n")
    rscript.write("x <- x[srt$ix,]\n")
elif reorder == 'sort_by_center':
    rscript.write("srt <- sort(x[,as.integer(nc/2)],index.return=T)\n")
    rscript.write("x <- x[srt$ix,]\n")
if color == 'heat':
    rscript.write("colormap = heat.colors(1000)\n")
elif color == 'topo':
    rscript.write("colormap = topo.colors(1000)\n")
elif color == 'rainbow':
    rscript.write("colormap = rainbow(1000)\n")
elif color == 'terrain':
    rscript.write("colormap = terrain.colors(1000)\n")
else:
    rscript.write("colormap = gray.colors(1000)\n")

#rscript.write("qt <- quantile(as.vector(x),probs=c(0.1,0.9))\n")
#rscript.write("breaks <- c(min(as.vector(x)),seq(qt[1],qt[2],length.out=99),max(as.vector(x)))\n")
#rscript.write("image(t(x),col=colormap,breaks=breaks,axes=F)\n")
rscript.write("image(t(x),col=colormap,axes=F)\n")
rscript.write("dev.off()\n")

rscript.close()

os.system("R --slave < tmp.r")
os.system("rm tmp.r")

