#!/usr/bin/env python

"""
Yufei LUO
"""



import optparse, sys


def __main__():
    #Parse Command Line
    parser = optparse.OptionParser()
    parser.add_option('-i', '--inputs', dest='inputFiles', default=None, help='several input files. (seperated by @ or @@' )
    parser.add_option( '-o', '--output', dest='outputSingleFile', default=None, help='The output list of fastq files on txt format.' )
    parser.add_option( '', '--pairedEnd', dest='outputPaireFile', default=None, help='paired end option help to upload the corresponding paired end complementary fastq files' )
    ( options, args ) = parser.parse_args()

    

    if options.outputSingleFile == None: 
        raise Exception, 'OutSingleFile txt file name is not defined!'
    else:
        outSingle = open(options.outputSingleFile, 'w')
    
    if options.inputFiles == None:
        raise Exception, 'input file name is not defined!'
    
    groupCount = 1
    fileCount = 0        
    
    if options.outputPaireFile == None:
        inputFiles = sys.argv[4:]
        i = 0
        while i < (len(inputFiles)-1):
	    if inputFiles[i] == "@":
                i += 1
                fileCount = 1
                groupCount += 1
                outSingle.write("Group%s_%s\t%s\n" % (groupCount, fileCount, inputFiles[i]))
                
            else:
                fileCount += 1
                outSingle.write("Group%s_%s\t%s\n" % (groupCount, fileCount, inputFiles[i]))
                
            i += 1
    else:
        inputFiles = sys.argv[6:]
        print '\n\nthe length of inputfiles is : %s \n' % len(inputFiles)
        outPaire = open(options.outputPaireFile, 'w')
        i = 0
        while i < (len(inputFiles)-1):
            if inputFiles[i] == "@@":
                i += 1
                outPaire.write("Group%s_%s\t%s\n" % (groupCount, fileCount, inputFiles[i]))
            elif inputFiles[i] == "@":
                i += 1
                fileCount = 1
                groupCount += 1
                outSingle.write("Group%s_%s\t%s\n" % (groupCount, fileCount, inputFiles[i]))
            else:
                fileCount += 1
                outSingle.write("Group%s_%s\t%s\n" % (groupCount, fileCount, inputFiles[i]))
                
            i += 1
                
        
        
        outPaire.close()
           
    outSingle.close()   
    
        

if __name__=="__main__": __main__()
