# pairwiseScatterPlots
# scatter plots for pairwise comparaisons of log counts

# input : counts, target, outputName
# output : scatter plots (pdf: allows multiple figures in one file)

# created Feb 21th, 2012
# modified Sept 27th, 2012 (pdf output file)
# modified Oct 30th, 2012 (png)
# Marie-Agnes Dillies


pairwiseScatterPlots <- function( counts, target, OUT_scatterPlot, out = TRUE, pdffile = FALSE ){

  if (out & !pdffile) png( OUT_scatterPlot )
  if (pdffile) pdf( OUT_scatterPlot )
  
  conds <- unique(target$group)
  # colnames(counts) <- target$label
  
  for (i in 1:(length(conds)-1)){
  	for (j in (i+1):length(conds)){
  		cond1 <- conds[i]; cond2 <- conds[j]
		pairs( log2(counts[, which(target$group %in% c(as.character(cond1), as.character(cond2)))]+1), 
				pch=".", cex=0.5, main = paste(cond1, cond2, sep=" vs ") )
  	}
  }

  if (pdffile) dev.off()
  if (out) dev.off()
}
