# Marie-Anges Dillies
# plotDispEstimates
# scatter plots representing dispersion estimates vs mean expression

# input : cds, OUT_plotDispEstimatesName
# output : scatterplot (png)

plotDispEstimates <- function( cds, OUT_plotDispEstimatesName, out = TRUE ){

  if (out) png( file=OUT_plotDispEstimatesName )
  
  plot(
  	rowMeans( counts(cds, normalized=T) ),
  	fitInfo(cds)$perGeneDispEsts,
  	pch=".", log="xy",
  	xlab = "Mean expression strength", ylab = "Dispersion estimate" )
  	
  xg <- 10^seq(-.5, 5, length.out=300)
  lines( xg, fitInfo(cds)$dispFun(xg), col="red" )

  if (out) dev.off()
}
