# barplotTC
# barplot representing total count per sample

# input : counts, target, projectName
# output : barplotTC (png)

# created Feb 7th, 2012
# modified April 30th, 2012 (group instead of target$group)
# Marie-Anges Dillies

barplotTC <- function( counts, group, OUT_barplotTCName, out = TRUE ){

  if (out) png( file=OUT_barplotTCName )

  ylim <- c(0, max(colSums(counts))*1.2)
  barplot( colSums(counts), col=as.integer(group)+1, main = "Total Read Count per Sample",  ylim=ylim )
  legend( "topright", as.character(unique(group)), lty=1,
         col=as.integer(unique(group))+1 )

  if (out) dev.off()
}
