import unittest
import os, glob

class Test_F_restrictSequenceList(unittest.TestCase):

    def setUp(self):
        self.sequencesFileName = "inputFile.fasta"
        self.namesFileName     = "names.txt"
        self.outputFileName    = "outputFile.fasta"
         
    def tearDown(self):
        for fileRoot in (self.sequencesFileName, self.namesFileName, self.outputFileName):
            for file in glob.glob("%s*" % (fileRoot)):
                os.remove(file)

    def test_run_simple(self):
        handle = open(self.sequencesFileName, "w")
        handle.write(">sequence1\n")
        handle.write("AAAAAAAAAAAAAAAAAAAA\n")
        handle.write(">sequence2\n")
        handle.write("CCCCCCCCCCCCCCCCCCCC\n")
        handle.close()
        handle = open(self.namesFileName, "w")
        handle.write("""sequence1""")
        handle.close()
        os.system("python ../restrictSequenceList.py -i %s -f fasta -n %s -o %s -v 0" % (self.sequencesFileName, self.namesFileName, self.outputFileName))
        handle = open(self.outputFileName)
        lines = handle.readlines()
        handle.close()
        self.assertEqual(len(lines), 2)
        self.assertEqual(lines[0], ">sequence1\n")
        self.assertEqual(lines[1], "AAAAAAAAAAAAAAAAAAAA\n")

        
if __name__ == "__main__":
    unittest.main()

