#! /usr/bin/env python
#
# Copyright INRA-URGI 2009-2010
# 
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software. You can use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
# 
# As a counterpart to the access to the source code and rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty and the software's author, the holder of the
# economic rights, and the successive licensors have only limited
# liability.
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading, using, modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean that it is complicated to manipulate, and that also
# therefore means that it is reserved for developers and experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and, more generally, to use and operate it in the
# same conditions as regards security.
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
#
"""Get the first element (exon / intron) from a list of transcripts"""

import os
from optparse import OptionParser
from commons.core.writer.Gff3Writer import *
from SMART.Java.Python.structure.TranscriptContainer import *
from SMART.Java.Python.misc.Progress import *


if __name__ == "__main__":
    
    # parse command line
    description = "Get Element v1.0.1: Get the first element (exon / intron) from a list of transcripts. [Category: Personnal]"

    parser = OptionParser(description = description)
    parser.add_option("-i", "--input",         dest="inputFileName",    action="store",                                                type="string", help="input file [compulsory] [format: file in transcript format given by -f]")
    parser.add_option("-f", "--format",        dest="format",                 action="store",                                                type="string", help="format of file [compulsory] [format: transcript file format]")
    parser.add_option("-o", "--output",        dest="outputFileName", action="store",                                                type="string", help="output file [compulsory] [format: output file in GFF3 format]")
    parser.add_option("-y", "--mysql",         dest="mysql",                    action="store_true", default=False,                                     help="mySQL output [format: bool] [default: false]")
    parser.add_option("-t", "--type",            dest="type",                     action="store",                                                type="string", help="type of the element    [format: choice (exon, intron)]")
    parser.add_option("-v", "--verbosity", dest="verbosity",            action="store",            default=1,                type="int",        help="trace level [format: int]")
    parser.add_option("-l", "--log",             dest="log",                        action="store_true", default=False,                                     help="write a log file [format: bool] [default: false]")
    (options, args) = parser.parse_args()

    parser        = TranscriptContainer(options.inputFileName, options.format, options.verbosity)
    writer        = Gff3Writer(options.outputFileName, options.verbosity)
    sqlWriter = MySqlTranscriptWriter(options.outputFileName, options.verbosity)
    
    nbLines = parser.getNbTranscripts()
    print "%i lines found" % (nbLines)

    # treat transcripts
    nbWritten = 0
    nbUsed        = 0
    progress    = Progress(nbLines, "Analyzing transcripts of " + options.inputFileName, options.verbosity)
    for transcript in parser.getIterator():

        outTranscript = Transcript()
        outTranscript.setName(transcript.getName())
        outTranscript.setDirection(transcript.getDirection())
        outTranscript.setChromosome(transcript.getChromosome())
        
        if options.type == "exon":
            if len(transcript.getExons()) > 1:
                transcript.sortExons()
                outTranscript.setStart(transcript.getExons()[0].getStart())
                outTranscript.setEnd(transcript.getExons()[0].getEnd())
                writer.addTranscript(outTranscript)
                if options.mysql:
                    sqlWriter.addTranscript(transcript)
                nbWritten += 1
                nbUsed        += 1
        elif options.type == "intron":
            used = False
            for intron in transcript.getIntrons():
                used = True
                thisTranscript = Transcript()
                thisTranscript.copy(outTranscript)
                thisTranscript.setStart(intron.getStart())
                thisTranscript.setEnd(intron.getEnd())
                writer.addTranscript(thisTranscript)
                if options.mysql:
                    sqlWriter.addTranscript(transcript)
                nbWritten += 1
            if used:
                nbUsed += 1
        else:
            sys.exit("Cannot understan type %s" % (options.type))
        progress.inc()
    progress.done()

    if options.mysql:
        sqlWriter.write()

    print "nb sequences used: %d" % (nbUsed)
    print "nb elements used: %d" % (nbWritten)
