import unittest
import os, glob
from SMART.Java.Python.plotCoverage import PlotParser


class Test_F_PlotCoverage(unittest.TestCase):

    def setUp(self):
        self.queryFileName  = "queryFile.gff3"
        self.refFileName    = "refFile.gff3"
        self.outputFileName = "outputFile"
         
    def tearDown(self):
        for fileRoot in (self.queryFileName, self.refFileName, self.outputFileName):
            for file in glob.glob("%s*" % (fileRoot)):
                os.remove(file)
        os.remove(".RData")

    def test_run_simple(self):
        handle = open(self.refFileName, "w")
        handle.write("chr1\tSMART\tmRNA\t1000\t2000\t.\t+\t.\tID=test1;Name=test1")
        handle.close()
        handle = open(self.queryFileName, "w")
        handle.write("chr1\tSMART\tmRNA\t1100\t1200\t.\t+\t.\tID=test2.1;Name=test2.1\n")
        handle.write("chr1\tSMART\tmRNA\t1300\t1400\t.\t+\t.\tID=test2.2;Name=test2.2\n")
        handle.close()
        pp = PlotParser(0)
        pp.addInput(0, self.queryFileName, "gff3")
        pp.addInput(1, self.refFileName, "gff3")
        pp.setLabels("x", "y")
        pp.setPlotSize(1000, 500)
        pp.setOutput(self.outputFileName)
        pp.start()
        self.assertTrue(os.path.exists("%s_test1_overlap.png" % (self.outputFileName)))
        self.assertTrue(os.path.exists("%s_test1_coverage.png" % (self.outputFileName)))
        
if __name__ == "__main__":
    unittest.main()

