import unittest
import os
from optparse import OptionParser
from SMART.Java.Python.structure.Transcript import Transcript
from commons.core.parsing.ParserChooser import ParserChooser
from commons.core.parsing.GffParser import GffParser
from commons.core.writer.Gff3Writer import Gff3Writer
from SMART.Java.Python.CombineTags import CombineTags

class Test_F_CombineTags(unittest.TestCase):

    def setUp(self):
        self._inputFileName  = "inputFileTest.gff3"
        self._outputFileName = "outputFileTest.gff3"
        self._tag1           = "tag1"
        self._tag2           = "tag2"
        self._outputTag      = "outputTag"
        
    def tearDown(self):
        os.remove(self._inputFileName)
        os.remove(self._outputFileName)

    def test_plus(self):
        transcript = self._createDummyTranscript()
        transcript.setTagValue(self._tag1, 1)
        transcript.setTagValue(self._tag2, 2)
        self._writeTranscript(transcript)
        combiner = CombineTags(0)
        combiner.setInputFile(self._inputFileName, "gff3")
        combiner.setOutputFile(self._outputFileName)
        combiner.setTags(self._tag1, self._tag2, self._outputTag, None)
        combiner.setOperation("plus")
        combiner.run()
        self._testOutputTag(3)

    def test_minus(self):
        transcript = self._createDummyTranscript()
        transcript.setTagValue(self._tag1, 2)
        transcript.setTagValue(self._tag2, 1)
        self._writeTranscript(transcript)
        combiner = CombineTags(0)
        combiner.setInputFile(self._inputFileName, "gff3")
        combiner.setOutputFile(self._outputFileName)
        combiner.setTags(self._tag1, self._tag2, self._outputTag, None)
        combiner.setOperation("minus")
        combiner.run()
        self._testOutputTag(1)

    def test_times(self):
        transcript = self._createDummyTranscript()
        transcript.setTagValue(self._tag1, 6)
        transcript.setTagValue(self._tag2, 3)
        self._writeTranscript(transcript)
        combiner = CombineTags(0)
        combiner.setInputFile(self._inputFileName, "gff3")
        combiner.setOutputFile(self._outputFileName)
        combiner.setTags(self._tag1, self._tag2, self._outputTag, None)
        combiner.setOperation("times")
        combiner.run()
        self._testOutputTag(18)

    def test_div(self):
        transcript = self._createDummyTranscript()
        transcript.setTagValue(self._tag1, 6)
        transcript.setTagValue(self._tag2, 3)
        self._writeTranscript(transcript)
        combiner = CombineTags(0)
        combiner.setInputFile(self._inputFileName, "gff3")
        combiner.setOutputFile(self._outputFileName)
        combiner.setTags(self._tag1, self._tag2, self._outputTag, None)
        combiner.setOperation("div")
        combiner.run()
        self._testOutputTag(2)

    def test_default(self):
        transcript = self._createDummyTranscript()
        transcript.setTagValue(self._tag1, 1)
        self._writeTranscript(transcript)
        combiner = CombineTags(0)
        combiner.setInputFile(self._inputFileName, "gff3")
        combiner.setOutputFile(self._outputFileName)
        combiner.setTags(self._tag1, self._tag2, self._outputTag, 0)
        combiner.setOperation("plus")
        combiner.run()
        self._testOutputTag(0)

    def _createDummyTranscript(self):
        transcript = Transcript()
        transcript.setChromosome("chr1")
        transcript.setName("test1")
        transcript.setEnd(200)
        transcript.setStart(100)
        transcript.setDirection("+")
        return transcript
    
    def _testOutputTag(self, value):
        parser = GffParser(self._outputFileName, 0)
        for transcript in parser.getIterator():
            self.assertEquals(float(transcript.getTagValue(self._outputTag)), value)
        parser.close()

    def _writeTranscript(self, transcript):
        f = open(self._inputFileName, "w")
        f.write(transcript.printGff3("test"))
        f.close()
        

if __name__ == "__main__":
    unittest.main()
