import unittest
import os, os.path
from SMART.Java.Python.misc import Utils
from SMART.Java.Python.getWigData import *

class Test_F_getWigData(unittest.TestCase):


    def setUp(self):
        self._inputGffFileName = 'inputGff.gff3'
        self._writeInputGff(self._inputGffFileName)
        self._inputWigFileName = '../TestFiles/sorted_query_wig.wig'
        self._expOutFileName = 'expOut.gff3'
        self._outFileName = 'outGffWig.gff3'


    def tearDown(self):
        os.remove(self._inputGffFileName)
        os.remove(self._expOutFileName)
        os.remove(self._outFileName)


    def test_getWigData_DefaultOption_asScript(self):
        cmd = 'python ../getWigData.py -i %s -f gff3 -w %s -t wigValue -o %s -v 0' % (self._inputGffFileName, self._inputWigFileName, self._outFileName)
        os.system(cmd)
        self._writeExpDefaultOption(self._expOutFileName)
        self.assertTrue(Utils.diff(self._expOutFileName, self._outFileName))
        
    def test_getWigData_strandsOption(self):
        cmd = 'python ../getWigData.py -i %s -f gff3 -w %s -t wigValue -o %s -s -v 0' % (self._inputGffFileName, self._inputWigFileName, self._outFileName)
        os.system(cmd)
        self._writeExpStransOption(self._expOutFileName)
        self.assertTrue(Utils.diff(self._expOutFileName, self._outFileName))  
        
    
    def _writeInputGff(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tquery\ttest1.1\t25\t150\t126\t+\t.\tID=query_1;Name=test1.1\n")
        f.write("chr1\tquery\ttest1.2\t70\t850\t781\t-\t.\tID=query_2;Name=test1.2\n")
        f.write("chr1\tquery\ttest1.3\t550\t850\t201\t-\t.\tID=query_3;Name=test1.3\n")
        f.write("chr1\tquery\ttest1.4\t925\t1025\t101\t+\t.\tID=query_4;Name=test1.4\n")
        f.write("chr1\tquery\ttest1.5\t1201\t1210\t10\t+\t.\tID=query_5;Name=test1.5\n")
        f.write("chr1\tquery\ttest1.6\t1500\t1600\t101\t+\t.\tID=query_6;Name=test1.6\n")
        f.close()
        
    def _writeExpDefaultOption(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tS-MART\ttest1.1\t25\t150\t126\t+\t.\twigValue=1.64285714286;ID=query_1;Name=test1.1\n")
        f.write("chr1\tS-MART\ttest1.2\t70\t850\t781\t-\t.\twigValue=1.48911651729;ID=query_2;Name=test1.2\n")
        f.write("chr1\tS-MART\ttest1.3\t550\t850\t201\t-\t.\twigValue=2.0;ID=query_3;Name=test1.3\n")
        f.write("chr1\tS-MART\ttest1.4\t925\t1025\t101\t+\t.\twigValue=1.0;ID=query_4;Name=test1.4\n")
        f.write("chr1\tS-MART\ttest1.5\t1201\t1210\t10\t+\t.\twigValue=1.0;ID=query_5;Name=test1.5\n")
        f.write("chr1\tS-MART\ttest1.6\t1500\t1600\t101\t+\t.\twigValue=1.0;ID=query_6;Name=test1.6\n")
        f.close()
        
    def _writeExpStransOption(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tS-MART\ttest1.1\t25\t150\t126\t+\t.\twigValue=0.0;ID=query_1;Name=test1.1\n")
        f.write("chr1\tS-MART\ttest1.2\t70\t850\t781\t-\t.\twigValue=0.0;ID=query_2;Name=test1.2\n")
        f.write("chr1\tS-MART\ttest1.3\t550\t850\t201\t-\t.\twigValue=0.0;ID=query_3;Name=test1.3\n")
        f.write("chr1\tS-MART\ttest1.4\t925\t1025\t101\t+\t.\twigValue=0.0;ID=query_4;Name=test1.4\n")
        f.write("chr1\tS-MART\ttest1.5\t1201\t1210\t10\t+\t.\twigValue=0.0;ID=query_5;Name=test1.5\n")
        f.write("chr1\tS-MART\ttest1.6\t1500\t1600\t101\t+\t.\twigValue=0.0;ID=query_6;Name=test1.6\n")
        f.close() 
        
    
        


if __name__ == "__main__":
    unittest.main()
