import unittest
import os, glob
from SMART.Java.Python.getWigProfile import GetWigProfile


class Test_F_GetWigProfile(unittest.TestCase):

    def setUp(self):
        self.transcriptFileName = "transcriptFile.gff3"
        self.wigFileName        = "file.wig"
        self.outputFileName     = "outputFile.png"
         
    def tearDown(self):
        for fileRoot in (self.transcriptFileName, self.wigFileName, self.outputFileName):
            for file in glob.glob("%s*" % (fileRoot)):
                os.remove(file)
        os.system("rm .RData .chr1.index ")

    def test_run_simple(self):
        handle = open(self.transcriptFileName, "w")
        handle.write("chr1\tSMART\tmRNA\t10\t20\t.\t+\t.\tID=test1;Name=test1")
        handle.close()
        handle = open(self.wigFileName, "w")
        handle.write("variableStep chrom=chr1\n")
        handle.write("1 1\n")
        handle.write("2 1\n")
        handle.write("3 1\n")
        handle.write("4 1\n")
        handle.write("5 1\n")
        handle.write("6 1\n")
        handle.write("7 1\n")
        handle.write("8 1\n")
        handle.write("9 1\n")
        handle.write("10 1\n")
        handle.write("11 2\n")
        handle.write("12 3\n")
        handle.write("13 4\n")
        handle.write("14 5\n")
        handle.write("15 5\n")
        handle.write("16 5\n")
        handle.write("17 5\n")
        handle.write("18 5\n")
        handle.write("19 5\n")
        handle.write("20 5\n")
        handle.write("21 1\n")
        handle.write("21 1\n")
        handle.close()
        wigProfile = GetWigProfile(0)
        wigProfile.strands        = False
        wigProfile.inputFileName  = self.transcriptFileName
        wigProfile.inputFormat    = "gff3"
        wigProfile.wig            = self.wigFileName
        wigProfile.nbPoints       = 11
        wigProfile.distance       = 1
        wigProfile.smoothenForce  = None
        wigProfile.log            = False
        wigProfile.outputFileName = self.outputFileName
        wigProfile.readTranscripts()
        wigProfile.smoothen()
        wigProfile.plot()
        self.assertTrue(os.path.exists(self.outputFileName))
        
if __name__ == "__main__":
    unittest.main()

